/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import javax.resource.spi.ConnectionManager;
import javax.security.auth.Subject;
import org.apache.geronimo.connector.outbound.GenericConnectionManager;
import org.apache.geronimo.connector.outbound.SubjectSource;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.proxy.ProxyManager;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;

@GBean(j2eeType="JCAConnectionManager")
public class GenericConnectionManagerGBean
extends GenericConnectionManager
implements GBeanLifecycle,
Serializable,
Externalizable {
    private Kernel kernel;
    private AbstractName abstractName;
    private static final int VERSION = 1;

    public GenericConnectionManagerGBean(@ParamAttribute(name="transactionSupport") TransactionSupport transactionSupport, @ParamAttribute(name="pooling") PoolingSupport pooling, @ParamAttribute(name="containerManagedSecurity") boolean containerManagedSecurity, @ParamReference(name="ConnectionTracker", namingType="JCAConnectionTracker") ConnectionTracker connectionTracker, @ParamReference(name="TransactionManager", namingType="JTAResource") RecoverableTransactionManager transactionManager, @ParamSpecial(type=SpecialAttributeType.objectName) String objectName, @ParamSpecial(type=SpecialAttributeType.abstractName) AbstractName abstractName, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel) {
        super(transactionSupport, pooling, GenericConnectionManagerGBean.getSubjectSource(containerManagedSecurity), connectionTracker, transactionManager, objectName, classLoader);
        this.kernel = kernel;
        this.abstractName = abstractName;
    }

    public GenericConnectionManagerGBean() {
    }

    public ConnectionManager getConnectionManager() {
        ConnectionManager unproxied = super.getConnectionManager();
        ProxyManager pm = this.kernel.getProxyManager();
        if (pm.isProxy((Object)unproxied)) {
            return unproxied;
        }
        return (ConnectionManager)pm.createProxy(this.kernel.getAbstractNameFor((Object)unproxied), unproxied.getClass().getClassLoader());
    }

    private static SubjectSource getSubjectSource(boolean containerManagedSecurity) {
        if (containerManagedSecurity) {
            return new SubjectSource(){

                public Subject getSubject() {
                    return ContextManager.getNextCaller();
                }
            };
        }
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            return this.kernel.getGBean(this.abstractName);
        }
        catch (GBeanNotFoundException e) {
            throw (ObjectStreamException)new InvalidObjectException("Could not locate connection manager gbean").initCause(e);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.kernel.getKernelName());
        out.writeObject(this.abstractName);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 1) {
            throw new IOException("Wrong version, expected 1, got: " + version);
        }
        String kernelName = (String)in.readObject();
        this.kernel = KernelRegistry.getKernel((String)kernelName);
        if (this.kernel == null) {
            this.kernel = KernelRegistry.getSingleKernel();
        }
        if (this.kernel == null) {
            throw new IOException("No kernel named: '" + kernelName + "' found");
        }
        this.abstractName = (AbstractName)in.readObject();
    }
}

