/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.util.Properties;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.openejb.ServerServiceGBean;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class EjbDaemonGBean
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(EjbDaemonGBean.class);
    private final Kernel kernel;
    private final AbstractName name;
    private final BundleContext bundleContext;
    private final ClassLoader classLoader;
    private ServiceTracker tracker;
    private ServiceManager serviceManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EjbDaemonGBean(@ParamAttribute(name="host") String host, @ParamAttribute(name="port") int port, @ParamAttribute(name="threads") int threads, @ParamAttribute(name="clusterName") String clusterName, @ParamAttribute(name="multicastHost") String multicastHost, @ParamAttribute(name="multicastPort") int multicastPort, @ParamAttribute(name="multicastEnabled") boolean multicastEnabled, @ParamAttribute(name="multipointEnabled") boolean multipointEnabled, @ParamAttribute(name="multipointHost") String multipointHost, @ParamAttribute(name="multipointPort") int multipointPort, @ParamAttribute(name="multipointServers") String multipointServers, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.abstractName) AbstractName name, final @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader) throws Exception {
        System.setProperty("openejb.nobanner", "true");
        this.kernel = kernel;
        this.name = name;
        this.bundleContext = bundleContext;
        this.classLoader = classLoader;
        this.serviceManager = ServiceManager.getManager();
        this.tracker = new ServiceTracker(bundleContext, ServerService.class.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                ServerService service = (ServerService)bundleContext.getService(reference);
                return EjbDaemonGBean.this.addServerService(service);
            }

            public void modifiedService(ServiceReference reference, Object obj) {
            }

            public void removedService(ServiceReference reference, Object obj) {
                EjbDaemonGBean.this.removeServerService((AbstractName)obj);
            }
        });
        Properties properties = SystemInstance.get().getProperties();
        properties.setProperty("ejbd.bind", host);
        properties.setProperty("ejbd.port", Integer.toString(port));
        properties.setProperty("ejbds.bind", host);
        properties.setProperty("ejbds.disabled", "true");
        if (threads > 0) {
            properties.setProperty("ejbd.threads", Integer.toString(threads));
            properties.setProperty("ejbds.threads", Integer.toString(threads));
        }
        properties.setProperty("multicast.bind", multicastHost);
        properties.setProperty("multicast.port", Integer.toString(multicastPort));
        properties.setProperty("multicast.disabled", Boolean.toString(!multicastEnabled));
        properties.setProperty("multicast.group", clusterName);
        properties.setProperty("multipoint.bind", multipointHost);
        properties.setProperty("multipoint.port", Integer.toString(multipointPort));
        properties.setProperty("multipoint.initialServers", multipointServers);
        properties.setProperty("multipoint.disabled", Boolean.toString(!multipointEnabled));
        properties.setProperty("multipoint.group", clusterName);
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            this.serviceManager.init();
            this.serviceManager.start(false);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        this.tracker.open();
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        this.serviceManager.stop();
        this.tracker.close();
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception e) {
            log.info("exception failing", (Throwable)e);
        }
    }

    private AbstractName addServerService(ServerService service) {
        AbstractName beanName = this.getUnqiueName(service.getName());
        GBeanData connectorData = new GBeanData(beanName, ServerServiceGBean.getGBeanInfo());
        try {
            this.kernel.loadGBean(connectorData, this.bundleContext);
            this.kernel.startRecursiveGBean(beanName);
            ServerServiceGBean connectorGBean = (ServerServiceGBean)this.kernel.getGBean(beanName);
            connectorGBean.setServerService(service);
            return beanName;
        }
        catch (Exception e) {
            log.warn("Failed to create gbean for ServerService", (Throwable)e);
            return null;
        }
    }

    private AbstractName getUnqiueName(String gbeanName) {
        AbstractName beanName = this.kernel.getNaming().createRootName(this.name.getArtifact(), gbeanName, "NetworkConnector");
        int i = 1;
        while (this.kernel.isLoaded(beanName)) {
            beanName = this.kernel.getNaming().createRootName(this.name.getArtifact(), gbeanName + "-" + i, "NetworkConnector");
            ++i;
        }
        return beanName;
    }

    private void removeServerService(AbstractName gbeanName) {
        try {
            if (this.kernel.getGBeanState(gbeanName) == 1) {
                this.kernel.stopGBean(gbeanName);
            }
            this.kernel.unloadGBean(gbeanName);
        }
        catch (GBeanNotFoundException gBeanNotFoundException) {
            // empty catch block
        }
    }
}

