/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.cdi;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.enterprise.inject.spi.Bean;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.SecurityService;
import org.apache.webbeans.spi.api.ResourceReference;
import org.apache.webbeans.util.AnnotationUtil;

public class GeronimoResourceInjectionService
implements ResourceInjectionService {
    private final Context context;
    private WebBeansContext webBeansContext;

    public GeronimoResourceInjectionService(WebBeansContext webBeansContext) {
        try {
            this.context = new InitialContext();
            this.webBeansContext = webBeansContext;
        }
        catch (NamingException e) {
            throw new WebBeansException("could not set up naming context", (Throwable)e);
        }
    }

    public void injectJavaEEResources(Object managedBeanInstance) {
        SecurityService securityService = this.webBeansContext.getSecurityService();
        for (Class<?> currentClass = managedBeanInstance.getClass(); currentClass != null && Object.class != currentClass; currentClass = currentClass.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = securityService.doPrivilegedGetDeclaredFields(currentClass)) {
                Annotation ann;
                if (Modifier.isStatic(field.getModifiers()) || (ann = AnnotationUtil.hasOwbInjectableResource((Annotation[])field.getDeclaredAnnotations())) == null) continue;
                ResourceReference resourceRef = new ResourceReference(field.getDeclaringClass(), field.getName(), field.getType(), ann);
                boolean acess = field.isAccessible();
                try {
                    securityService.doPrivilegedSetAccessible((AccessibleObject)field, true);
                    field.set(managedBeanInstance, this.getResourceReference(resourceRef));
                }
                catch (Exception e) {
                    throw new WebBeansException("Unable to inject field" + field, (Throwable)e);
                }
                finally {
                    securityService.doPrivilegedSetAccessible((AccessibleObject)field, acess);
                }
            }
        }
    }

    public <X, T extends Annotation> X getResourceReference(ResourceReference<X, T> resourceReference) {
        String jndiName = resourceReference.getJndiName();
        Class type = resourceReference.getResourceType();
        try {
            return (X)type.cast(this.context.lookup(jndiName));
        }
        catch (NamingException e) {
            throw new WebBeansException("Could not get resource of type " + type + " at jndi name " + jndiName, (Throwable)e);
        }
    }

    public void clear() {
    }

    public <T> void writeExternal(Bean<T> bean, T actualResource, ObjectOutput out) throws IOException {
    }

    public <T> T readExternal(Bean<T> bean, ObjectInput out) throws IOException, ClassNotFoundException {
        return (T)((ResourceBean)bean).getActualInstance();
    }
}

