/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.persistence;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import javax.persistence.spi.ClassTransformer;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public class TransformerWrapper
implements ClassFileTransformer {
    private final ClassTransformer classTransformer;
    private final Bundle bundle;

    public TransformerWrapper(ClassTransformer classTransformer, Bundle bundle) {
        this.classTransformer = classTransformer;
        this.bundle = BundleUtils.unwrapBundle((Bundle)bundle);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (loader instanceof BundleReference && ((BundleReference)loader).getBundle() == this.bundle) {
            try {
                return this.classTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
            }
            catch (IllegalClassFormatException e) {
                throw e;
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        return null;
    }
}

