/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.file;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.rmi.server.UID;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.Codec;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileConstants;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.SeekableFileInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;

public class DataFileWriter<D>
implements Closeable,
Flushable {
    private Schema schema;
    private DatumWriter<D> dout;
    private BufferedFileOutputStream out;
    private Encoder vout;
    private final Map<String, byte[]> meta = new HashMap<String, byte[]>();
    private long blockCount;
    private NonCopyingByteArrayOutputStream buffer;
    private Encoder bufOut;
    private byte[] sync;
    private int syncInterval = 16000;
    private boolean isOpen;
    private Codec codec;

    public DataFileWriter(DatumWriter<D> dout) {
        this.dout = dout;
    }

    private void assertOpen() {
        if (!this.isOpen) {
            throw new AvroRuntimeException("not open");
        }
    }

    private void assertNotOpen() {
        if (this.isOpen) {
            throw new AvroRuntimeException("already open");
        }
    }

    public DataFileWriter<D> setCodec(CodecFactory c) {
        this.assertNotOpen();
        this.codec = c.createInstance();
        this.setMetaInternal("avro.codec", this.codec.getName());
        return this;
    }

    public DataFileWriter<D> setSyncInterval(int syncInterval) {
        if (syncInterval < 32 || syncInterval > 0x40000000) {
            throw new IllegalArgumentException("Invalid syncInterval value: " + syncInterval);
        }
        this.syncInterval = syncInterval;
        return this;
    }

    public DataFileWriter<D> create(Schema schema, File file) throws IOException {
        return this.create(schema, new FileOutputStream(file));
    }

    public DataFileWriter<D> create(Schema schema, OutputStream outs) throws IOException {
        this.assertNotOpen();
        this.schema = schema;
        this.setMetaInternal("avro.schema", schema.toString());
        this.sync = DataFileWriter.generateSync();
        this.init(outs);
        this.out.write(DataFileConstants.MAGIC);
        this.vout.writeMapStart();
        this.vout.setItemCount(this.meta.size());
        for (Map.Entry<String, byte[]> entry : this.meta.entrySet()) {
            this.vout.startItem();
            this.vout.writeString(entry.getKey());
            this.vout.writeBytes(entry.getValue());
        }
        this.vout.writeMapEnd();
        this.vout.flush();
        this.out.write(this.sync);
        return this;
    }

    public DataFileWriter<D> appendTo(File file) throws IOException {
        this.assertNotOpen();
        if (!file.exists()) {
            throw new FileNotFoundException("Not found: " + file);
        }
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        FileDescriptor fd = raf.getFD();
        DataFileReader reader = new DataFileReader(new SeekableFileInput(fd), new GenericDatumReader());
        this.schema = reader.getSchema();
        this.sync = reader.sync;
        this.meta.putAll(reader.meta);
        byte[] codecBytes = this.meta.get("avro.codec");
        if (codecBytes != null) {
            String strCodec = new String(codecBytes, "UTF-8");
            this.codec = CodecFactory.fromString(strCodec).createInstance();
        } else {
            this.codec = CodecFactory.nullCodec().createInstance();
        }
        FileChannel channel = raf.getChannel();
        channel.position(channel.size());
        this.init(new FileOutputStream(fd));
        return this;
    }

    private void init(OutputStream outs) throws IOException {
        this.out = new BufferedFileOutputStream(outs);
        this.vout = new BinaryEncoder(this.out);
        this.dout.setSchema(this.schema);
        this.buffer = new NonCopyingByteArrayOutputStream(Math.min((int)((double)this.syncInterval * 1.25), 0x3FFFFFFE));
        this.bufOut = new BinaryEncoder(this.buffer);
        if (this.codec == null) {
            this.codec = CodecFactory.nullCodec().createInstance();
        }
        this.isOpen = true;
    }

    private static byte[] generateSync() {
        try {
            MessageDigest digester = MessageDigest.getInstance("MD5");
            long time = System.currentTimeMillis();
            digester.update((new UID() + "@" + time).getBytes());
            return digester.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private DataFileWriter<D> setMetaInternal(String key, byte[] value) {
        this.assertNotOpen();
        this.meta.put(key, value);
        return this;
    }

    public DataFileWriter<D> setMetaInternal(String key, String value) {
        try {
            return this.setMetaInternal(key, value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public DataFileWriter<D> setMeta(String key, byte[] value) {
        if (this.isReserved(key)) {
            throw new AvroRuntimeException("Cannot set reserved meta key: " + key);
        }
        return this.setMetaInternal(key, value);
    }

    private boolean isReserved(String key) {
        return key.startsWith("avro.");
    }

    public DataFileWriter<D> setMeta(String key, String value) {
        try {
            return this.setMeta(key, value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public DataFileWriter<D> setMeta(String key, long value) {
        return this.setMeta(key, Long.toString(value));
    }

    public void append(D datum) throws IOException {
        this.assertOpen();
        this.dout.write(datum, this.bufOut);
        ++this.blockCount;
        if (this.buffer.size() >= this.syncInterval) {
            this.writeBlock();
        }
    }

    public void appendAllFrom(DataFileStream<D> otherFile, boolean recompress) throws IOException {
        this.assertOpen();
        Schema otherSchema = otherFile.getSchema();
        if (!this.schema.equals(otherSchema)) {
            throw new IOException("Schema from file " + otherFile + " does not match");
        }
        this.writeBlock();
        Codec otherCodec = otherFile.resolveCodec();
        DataFileStream.DataBlock nextBlockRaw = null;
        if (this.codec.equals(otherCodec) && !recompress) {
            while (otherFile.hasNextBlock()) {
                nextBlockRaw = otherFile.nextBlock(nextBlockRaw);
                this.writeRawBlock(nextBlockRaw);
            }
        } else {
            while (otherFile.hasNextBlock()) {
                nextBlockRaw = otherFile.nextBlock(nextBlockRaw);
                ByteBuffer uncompressedData = otherCodec.decompress(ByteBuffer.wrap(nextBlockRaw.data, 0, nextBlockRaw.blockSize));
                ByteBuffer compressed = this.codec.compress(uncompressedData);
                nextBlockRaw.data = compressed.array();
                nextBlockRaw.blockSize = compressed.remaining();
                this.writeRawBlock(nextBlockRaw);
            }
        }
    }

    private void writeRawBlock(DataFileStream.DataBlock rawBlock) throws IOException {
        this.vout.writeLong(rawBlock.numEntries);
        this.vout.writeLong(rawBlock.blockSize);
        this.vout.writeFixed(rawBlock.data, 0, rawBlock.blockSize);
        this.vout.writeFixed(this.sync);
    }

    private void writeBlock() throws IOException {
        if (this.blockCount > 0L) {
            this.vout.writeLong(this.blockCount);
            ByteBuffer uncompressed = this.buffer.getByteArrayAsByteBuffer();
            ByteBuffer block = this.codec.compress(uncompressed);
            this.vout.writeLong(block.remaining());
            this.vout.writeFixed(block.array(), block.position() + block.arrayOffset(), block.remaining());
            this.buffer.reset();
            this.blockCount = 0L;
            this.vout.writeFixed(this.sync);
        }
    }

    public long sync() throws IOException {
        this.assertOpen();
        this.writeBlock();
        return this.out.tell();
    }

    @Override
    public void flush() throws IOException {
        this.sync();
        this.vout.flush();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
        this.isOpen = false;
    }

    static class NonCopyingByteArrayOutputStream
    extends ByteArrayOutputStream {
        NonCopyingByteArrayOutputStream(int initialSize) {
            super(initialSize);
        }

        ByteBuffer getByteArrayAsByteBuffer() {
            return ByteBuffer.wrap(this.buf, 0, this.count);
        }
    }

    private class BufferedFileOutputStream
    extends BufferedOutputStream {
        private long position;

        public BufferedFileOutputStream(OutputStream out) throws IOException {
            super(null);
            this.out = new PositionFilter(out);
        }

        public long tell() {
            return this.position + (long)this.count;
        }

        private class PositionFilter
        extends FilterOutputStream {
            public PositionFilter(OutputStream out) throws IOException {
                super(out);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
                BufferedFileOutputStream.this.position += len;
            }
        }
    }
}

