/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.ipc.AvroRemoteException;
import org.apache.avro.ipc.ByteBufferInputStream;
import org.apache.avro.ipc.ByteBufferOutputStream;
import org.apache.avro.ipc.HandshakeMatch;
import org.apache.avro.ipc.HandshakeRequest;
import org.apache.avro.ipc.HandshakeResponse;
import org.apache.avro.ipc.MD5;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.Utf8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Responder {
    private static final Logger LOG = LoggerFactory.getLogger(Responder.class);
    private static final Schema META = Schema.createMap(Schema.create(Schema.Type.BYTES));
    private static final GenericDatumReader<Map<Utf8, ByteBuffer>> META_READER = new GenericDatumReader(META);
    private static final GenericDatumWriter<Map<Utf8, ByteBuffer>> META_WRITER = new GenericDatumWriter(META);
    private Map<MD5, Protocol> protocols = Collections.synchronizedMap(new HashMap());
    private Protocol local;
    private MD5 localHash;
    protected List<RPCPlugin> rpcMetaPlugins;
    private SpecificDatumWriter<HandshakeResponse> handshakeWriter = new SpecificDatumWriter<HandshakeResponse>(HandshakeResponse.class);
    private SpecificDatumReader<HandshakeRequest> handshakeReader = new SpecificDatumReader<HandshakeRequest>(HandshakeRequest.class);

    protected Responder(Protocol local) {
        this.local = local;
        this.localHash = new MD5();
        this.localHash.bytes(local.getMD5());
        this.protocols.put(this.localHash, local);
        this.rpcMetaPlugins = Collections.synchronizedList(new ArrayList());
    }

    public Protocol getLocal() {
        return this.local;
    }

    public void addRPCPlugin(RPCPlugin plugin) {
        this.rpcMetaPlugins.add(plugin);
    }

    public List<ByteBuffer> respond(List<ByteBuffer> buffers) throws IOException {
        BinaryDecoder in = DecoderFactory.defaultFactory().createBinaryDecoder(new ByteBufferInputStream(buffers), null);
        ByteBufferOutputStream bbo = new ByteBufferOutputStream();
        BinaryEncoder out = new BinaryEncoder(bbo);
        AvroRemoteException error = null;
        RPCContext context = new RPCContext();
        try {
            Protocol remote = this.handshake(in, out);
            if (remote == null) {
                return bbo.getBufferList();
            }
            context.setRequestCallMeta(META_READER.read(null, in));
            String messageName = ((Decoder)in).readString(null).toString();
            Protocol.Message m = remote.getMessages().get(messageName);
            if (m == null) {
                throw new AvroRuntimeException("No such remote message: " + messageName);
            }
            context.setMessage(m);
            Object request = this.readRequest(m.getRequest(), in);
            for (RPCPlugin plugin : this.rpcMetaPlugins) {
                plugin.serverReceiveRequest(context);
            }
            m = this.getLocal().getMessages().get(messageName);
            if (m == null) {
                throw new AvroRuntimeException("No message named " + messageName + " in " + this.getLocal());
            }
            Object response = null;
            try {
                response = this.respond(m, request);
                context.setResponse(response);
            }
            catch (AvroRemoteException e) {
                error = e;
                context.setError(error);
            }
            catch (Exception e) {
                LOG.warn("application error", (Throwable)e);
                error = new AvroRemoteException(new Utf8(e.toString()));
                context.setError(error);
            }
            for (RPCPlugin plugin : this.rpcMetaPlugins) {
                plugin.serverSendResponse(context);
            }
            META_WRITER.write(context.responseCallMeta(), out);
            ((Encoder)out).writeBoolean(error != null);
            if (error == null) {
                this.writeResponse(m.getResponse(), response, out);
            } else {
                this.writeError(m.getErrors(), error, out);
            }
        }
        catch (AvroRuntimeException e) {
            LOG.warn("system error", (Throwable)e);
            error = new AvroRemoteException(e);
            context.setError(error);
            bbo = new ByteBufferOutputStream();
            out = new BinaryEncoder(bbo);
            META_WRITER.write(context.responseCallMeta(), out);
            ((Encoder)out).writeBoolean(true);
            this.writeError(Protocol.SYSTEM_ERRORS, error, out);
        }
        return bbo.getBufferList();
    }

    private Protocol handshake(Decoder in, Encoder out) throws IOException {
        HandshakeRequest request = this.handshakeReader.read(null, in);
        Protocol remote = this.protocols.get(request.clientHash);
        if (remote == null && request.clientProtocol != null) {
            remote = Protocol.parse(request.clientProtocol.toString());
            this.protocols.put(request.clientHash, remote);
        }
        HandshakeResponse response = new HandshakeResponse();
        if (this.localHash.equals(request.serverHash)) {
            response.match = remote == null ? HandshakeMatch.NONE : HandshakeMatch.BOTH;
        } else {
            HandshakeMatch handshakeMatch = response.match = remote == null ? HandshakeMatch.NONE : HandshakeMatch.CLIENT;
        }
        if (response.match != HandshakeMatch.BOTH) {
            response.serverProtocol = new Utf8(this.local.toString());
            response.serverHash = this.localHash;
        }
        RPCContext context = new RPCContext();
        context.setRequestHandshakeMeta(request.meta);
        for (RPCPlugin plugin : this.rpcMetaPlugins) {
            plugin.serverConnecting(context);
        }
        response.meta = context.responseHandshakeMeta();
        this.handshakeWriter.write(response, out);
        return remote;
    }

    public abstract Object respond(Protocol.Message var1, Object var2) throws AvroRemoteException;

    public abstract Object readRequest(Schema var1, Decoder var2) throws IOException;

    public abstract void writeResponse(Schema var1, Object var2, Encoder var3) throws IOException;

    public abstract void writeError(Schema var1, AvroRemoteException var2, Encoder var3) throws IOException;
}

