/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

public class S3ALocatedFileStatus
extends LocatedFileStatus {
    private static final long serialVersionUID = 3597192103662929338L;
    private final String eTag;
    private final String versionId;
    private final Tristate isEmptyDirectory;

    public S3ALocatedFileStatus(S3AFileStatus status, BlockLocation[] locations) {
        super((FileStatus)Preconditions.checkNotNull((Object)((Object)status)), locations);
        this.eTag = status.getETag();
        this.versionId = status.getVersionId();
        this.isEmptyDirectory = status.isEmptyDirectory();
    }

    public String getETag() {
        return this.eTag;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public S3AFileStatus toS3AFileStatus() {
        return new S3AFileStatus(this.getPath(), this.isDirectory(), this.isEmptyDirectory, this.getLen(), this.getModificationTime(), this.getBlockSize(), this.getOwner(), this.getETag(), this.getVersionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("[eTag='").append(this.eTag != null ? this.eTag : "").append('\'');
        sb.append(", versionId='").append(this.versionId != null ? this.versionId : "").append('\'');
        sb.append(']');
        return sb.toString();
    }
}

