/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.amazonaws.services.s3.model.SelectObjectContentResult;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3ARetryPolicy;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.WriteOperations;
import org.apache.hadoop.fs.s3a.s3guard.BulkOperationState;
import org.apache.hadoop.fs.s3a.s3guard.S3Guard;
import org.apache.hadoop.fs.s3a.select.SelectBinding;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.functional.CallableRaisingIOE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class WriteOperationHelper
implements WriteOperations {
    private static final Logger LOG = LoggerFactory.getLogger(WriteOperationHelper.class);
    private final S3AFileSystem owner;
    private final Invoker invoker;
    private final Configuration conf;
    private final String bucket;
    private final S3AStatisticsContext statisticsContext;

    protected WriteOperationHelper(S3AFileSystem owner, Configuration conf, S3AStatisticsContext statisticsContext) {
        this.owner = owner;
        this.invoker = new Invoker(new S3ARetryPolicy(conf), this::operationRetried);
        this.conf = conf;
        this.statisticsContext = statisticsContext;
        this.bucket = owner.getBucket();
    }

    void operationRetried(String text, Exception ex, int retries, boolean idempotent) {
        LOG.info("{}: Retried {}: {}", new Object[]{text, retries, ex.toString()});
        LOG.debug("Stack", (Throwable)ex);
        this.owner.operationRetried(text, ex, retries, idempotent);
    }

    @Override
    public <T> T retry(String action, String path, boolean idempotent, CallableRaisingIOE<T> operation) throws IOException {
        return this.invoker.retry(action, path, idempotent, operation);
    }

    @Override
    public PutObjectRequest createPutObjectRequest(String destKey, InputStream inputStream, long length, Map<String, String> headers) {
        ObjectMetadata objectMetadata = this.newObjectMetadata(length);
        if (headers != null) {
            objectMetadata.setUserMetadata(headers);
        }
        return this.owner.newPutObjectRequest(destKey, objectMetadata, inputStream);
    }

    @Override
    public PutObjectRequest createPutObjectRequest(String dest, File sourceFile) {
        Preconditions.checkState((sourceFile.length() < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"File length is too big for a single PUT upload");
        return this.owner.newPutObjectRequest(dest, this.newObjectMetadata((int)sourceFile.length()), sourceFile);
    }

    @Override
    public void writeSuccessful(long length) {
    }

    @Override
    public void writeFailed(Exception ex) {
        LOG.debug("Write to {} failed", (Object)this, (Object)ex);
    }

    @Override
    public ObjectMetadata newObjectMetadata(long length) {
        return this.owner.newObjectMetadata(length);
    }

    @Override
    public String initiateMultiPartUpload(String destKey) throws IOException {
        LOG.debug("Initiating Multipart upload to {}", (Object)destKey);
        InitiateMultipartUploadRequest initiateMPURequest = new InitiateMultipartUploadRequest(this.bucket, destKey, this.newObjectMetadata(-1L));
        initiateMPURequest.setCannedACL(this.owner.getCannedACL());
        this.owner.setOptionalMultipartUploadRequestParameters(initiateMPURequest);
        return (String)this.retry("initiate MultiPartUpload", destKey, true, () -> this.owner.initiateMultipartUpload(initiateMPURequest).getUploadId());
    }

    private CompleteMultipartUploadResult finalizeMultipartUpload(String destKey, String uploadId, List<PartETag> partETags, long length, Invoker.Retried retrying, @Nullable BulkOperationState operationState) throws IOException {
        if (partETags.isEmpty()) {
            throw new PathIOException(destKey, "No upload parts in multipart upload");
        }
        CompleteMultipartUploadResult uploadResult = (CompleteMultipartUploadResult)this.invoker.retry("Completing multipart upload", destKey, true, retrying, () -> this.owner.getAmazonS3Client().completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucket, destKey, uploadId, new ArrayList(partETags))));
        this.owner.finishedWrite(destKey, length, uploadResult.getETag(), uploadResult.getVersionId(), operationState);
        return uploadResult;
    }

    @Override
    public CompleteMultipartUploadResult completeMPUwithRetries(String destKey, String uploadId, List<PartETag> partETags, long length, AtomicInteger errorCount) throws IOException {
        Preconditions.checkNotNull((Object)uploadId);
        Preconditions.checkNotNull(partETags);
        LOG.debug("Completing multipart upload {} with {} parts", (Object)uploadId, (Object)partETags.size());
        return this.finalizeMultipartUpload(destKey, uploadId, partETags, length, (text, e, r, i) -> errorCount.incrementAndGet(), null);
    }

    @Override
    public void abortMultipartUpload(String destKey, String uploadId, boolean shouldRetry, Invoker.Retried retrying) throws IOException {
        if (shouldRetry) {
            this.invoker.retry("Aborting multipart upload ID " + uploadId, destKey, true, retrying, () -> this.owner.abortMultipartUpload(destKey, uploadId));
        } else {
            Invoker.once("Aborting multipart upload ID " + uploadId, destKey, () -> this.owner.abortMultipartUpload(destKey, uploadId));
        }
    }

    @Override
    public void abortMultipartUpload(MultipartUpload upload) throws IOException {
        this.invoker.retry("Aborting multipart commit", upload.getKey(), true, () -> this.owner.abortMultipartUpload(upload));
    }

    @Override
    public int abortMultipartUploadsUnderPath(String prefix) throws IOException {
        LOG.debug("Aborting multipart uploads under {}", (Object)prefix);
        int count = 0;
        List<MultipartUpload> multipartUploads = this.owner.listMultipartUploads(prefix);
        LOG.debug("Number of outstanding uploads: {}", (Object)multipartUploads.size());
        for (MultipartUpload upload : multipartUploads) {
            try {
                this.abortMultipartUpload(upload);
                ++count;
            }
            catch (FileNotFoundException e) {
                LOG.debug("Already aborted: {}", (Object)upload.getKey(), (Object)e);
            }
        }
        return count;
    }

    @Override
    public void abortMultipartCommit(String destKey, String uploadId) throws IOException {
        this.abortMultipartUpload(destKey, uploadId, true, this.invoker.getRetryCallback());
    }

    @Override
    public UploadPartRequest newUploadPartRequest(String destKey, String uploadId, int partNumber, int size, InputStream uploadStream, File sourceFile, Long offset) throws PathIOException {
        Preconditions.checkNotNull((Object)uploadId);
        Preconditions.checkArgument((boolean)(uploadStream != null ^ sourceFile != null), (Object)"Data source");
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (String)"Invalid partition size %s", (int)size);
        Preconditions.checkArgument((partNumber > 0 ? 1 : 0) != 0, (String)"partNumber must be between 1 and %s inclusive, but is %s", (int)10000, (int)partNumber);
        LOG.debug("Creating part upload request for {} #{} size {}", new Object[]{uploadId, partNumber, size});
        long partCountLimit = S3AUtils.longOption(this.conf, "fs.s3a.internal.upload.part.count.limit", 10000L, 1L);
        if (partCountLimit != 10000L) {
            LOG.warn("Configuration property {} shouldn't be overridden by client", (Object)"fs.s3a.internal.upload.part.count.limit");
        }
        String pathErrorMsg = "Number of parts in multipart upload exceeded. Current part count = %s, Part count limit = %s ";
        if ((long)partNumber > partCountLimit) {
            throw new PathIOException(destKey, String.format("Number of parts in multipart upload exceeded. Current part count = %s, Part count limit = %s ", partNumber, partCountLimit));
        }
        UploadPartRequest request = new UploadPartRequest().withBucketName(this.bucket).withKey(destKey).withUploadId(uploadId).withPartNumber(partNumber).withPartSize((long)size);
        if (uploadStream != null) {
            request.setInputStream(uploadStream);
        } else {
            Preconditions.checkArgument((boolean)sourceFile.exists(), (String)"Source file does not exist: %s", (Object)sourceFile);
            Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"Invalid offset %s", (Object)offset);
            long length = sourceFile.length();
            Preconditions.checkArgument((offset == 0L || offset < length ? 1 : 0) != 0, (String)"Offset %s beyond length of file %s", (Object)offset, (long)length);
            request.setFile(sourceFile);
            request.setFileOffset(offset.longValue());
        }
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteOperationHelper {bucket=").append(this.bucket);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws IOException {
        return (PutObjectResult)this.retry("Writing Object", putObjectRequest.getKey(), true, () -> this.owner.putObjectDirect(putObjectRequest));
    }

    @Override
    public UploadResult uploadObject(PutObjectRequest putObjectRequest) throws IOException {
        return (UploadResult)this.retry("Writing Object", putObjectRequest.getKey(), true, () -> this.owner.executePut(putObjectRequest, null));
    }

    @Override
    public void revertCommit(String destKey, @Nullable BulkOperationState operationState) throws IOException {
        Invoker.once("revert commit", destKey, () -> {
            Path destPath = this.owner.keyToQualifiedPath(destKey);
            this.owner.deleteObjectAtPath(destPath, destKey, true, operationState);
            this.owner.maybeCreateFakeParentDirectory(destPath);
        });
    }

    @Override
    public CompleteMultipartUploadResult commitUpload(String destKey, String uploadId, List<PartETag> partETags, long length, @Nullable BulkOperationState operationState) throws IOException {
        Preconditions.checkNotNull((Object)uploadId);
        Preconditions.checkNotNull(partETags);
        LOG.debug("Completing multipart upload {} with {} parts", (Object)uploadId, (Object)partETags.size());
        return this.finalizeMultipartUpload(destKey, uploadId, partETags, length, Invoker.NO_OP, operationState);
    }

    @Override
    public BulkOperationState initiateCommitOperation(Path path) throws IOException {
        return this.initiateOperation(path, BulkOperationState.OperationType.Commit);
    }

    @Override
    public BulkOperationState initiateOperation(Path path, BulkOperationState.OperationType operationType) throws IOException {
        return S3Guard.initiateBulkWrite(this.owner.getMetadataStore(), operationType, path);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest request) throws IOException {
        return (UploadPartResult)this.retry("upload part #" + request.getPartNumber() + " upload ID " + request.getUploadId(), request.getKey(), true, () -> this.owner.uploadPart(request));
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public SelectObjectContentRequest newSelectRequest(Path path) {
        SelectObjectContentRequest request = new SelectObjectContentRequest();
        request.setBucketName(this.bucket);
        request.setKey(this.owner.pathToKey(path));
        return request;
    }

    @Override
    public SelectObjectContentResult select(Path source, SelectObjectContentRequest request, String action) throws IOException {
        String bucketName = request.getBucketName();
        Preconditions.checkArgument((boolean)this.bucket.equals(bucketName), (String)"wrong bucket: %s", (Object)bucketName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initiating select call {} {}", (Object)source, (Object)request.getExpression());
            LOG.debug(SelectBinding.toString(request));
        }
        return (SelectObjectContentResult)this.invoker.retry(action, source.toString(), true, () -> {
            Throwable throwable = null;
            try (DurationInfo ignored = new DurationInfo(LOG, "S3 Select operation", new Object[0]);){
                SelectObjectContentResult selectObjectContentResult = this.owner.getAmazonS3Client().selectObjectContent(request);
                return selectObjectContentResult;
            }
            catch (AmazonS3Exception e) {
                try {
                    LOG.error("Failure of S3 Select request against {}", (Object)source);
                    LOG.debug("S3 Select request against {}:\n{}", new Object[]{source, SelectBinding.toString(request), e});
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        });
    }

    @Override
    public void incrementWriteOperations() {
        this.owner.incrementWriteOperations();
    }
}

