/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.amazonaws.services.dynamodbv2.xspec.ExpressionSpecBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.Listing;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3ALocatedFileStatus;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.S3ListRequest;
import org.apache.hadoop.fs.s3a.s3guard.AbstractS3GuardDynamoDBDiagnostic;
import org.apache.hadoop.fs.s3a.s3guard.DDBPathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.DynamoDBMetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.PathOrderComparators;
import org.apache.hadoop.fs.s3a.s3guard.S3GuardTableAccess;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.launcher.ServiceLaunchException;
import org.apache.hadoop.service.launcher.ServiceLauncher;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.ExitUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DumpS3GuardDynamoTable
extends AbstractS3GuardDynamoDBDiagnostic {
    private static final Logger LOG = LoggerFactory.getLogger(DumpS3GuardDynamoTable.class);
    public static final String NAME = "DumpS3GuardDynamoTable";
    private static final String USAGE_MESSAGE = "DumpS3GuardDynamoTable <filesystem> <dest-file>";
    public static final String FLAT_CSV = "-flat.csv";
    public static final String RAW_CSV = "-s3.csv";
    public static final String SCAN_CSV = "-scan.csv";
    public static final String SCAN2_CSV = "-scan-2.csv";
    public static final String TREE_CSV = "-tree.csv";
    public static final String STORE_CSV = "-store.csv";
    private String destPath;
    private Pair<Long, Long> scanEntryResult;
    private Pair<Long, Long> secondScanResult;
    private long rawObjectStoreCount;
    private long listStatusCount;
    private long treewalkCount;

    public DumpS3GuardDynamoTable(String name) {
        super(name);
    }

    public DumpS3GuardDynamoTable() {
        this(NAME);
    }

    public DumpS3GuardDynamoTable(S3AFileSystem fs, DynamoDBMetadataStore store, File destFile, URI uri) {
        super(NAME, fs, store, uri);
        this.destPath = destFile.getAbsolutePath();
    }

    protected void serviceStart() throws Exception {
        if (this.getStore() == null) {
            List<String> arg = this.getArgumentList(2, 2, USAGE_MESSAGE);
            this.bindFromCLI(arg.get(0));
            this.destPath = arg.get(1);
        }
    }

    public int execute() throws ServiceLaunchException, IOException {
        try {
            Throwable throwable;
            File scanFile = new File(this.destPath + SCAN_CSV).getCanonicalFile();
            File parentDir = scanFile.getParentFile();
            if (!parentDir.mkdirs() && !parentDir.isDirectory()) {
                throw new PathIOException(parentDir.toString(), "Could not create destination directory");
            }
            try (CsvFile csv = new CsvFile(scanFile);){
                throwable = null;
                try (DurationInfo ignored = new DurationInfo(LOG, "scanFile dump to %s", new Object[]{scanFile});){
                    this.scanEntryResult = this.scanMetastore(csv);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            if (this.getFilesystem() != null) {
                Throwable throwable3;
                Object ignored4;
                Object ignored22;
                Object ignored32;
                Path basePath = this.getFilesystem().qualify(new Path(this.getUri()));
                File destFile = new File(this.destPath + STORE_CSV).getCanonicalFile();
                LOG.info("Writing Store details to {}", (Object)destFile);
                throwable = null;
                try (CsvFile csv = new CsvFile(destFile);){
                    ignored32 = new DurationInfo(LOG, "List metastore", new Object[0]);
                    Throwable throwable4 = null;
                    try {
                        LOG.info("Base path: {}", (Object)basePath);
                        this.dumpMetastore(csv, basePath);
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (ignored32 != null) {
                            if (throwable4 != null) {
                                try {
                                    ignored32.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable4.addSuppressed(throwable6);
                                }
                            } else {
                                ignored32.close();
                            }
                        }
                    }
                }
                catch (Throwable ignored32) {
                    throwable = ignored32;
                    throw ignored32;
                }
                File treewalkFile = new File(this.destPath + TREE_CSV).getCanonicalFile();
                CsvFile csv = new CsvFile(treewalkFile);
                ignored32 = null;
                try {
                    ignored22 = new DurationInfo(LOG, "Treewalk to %s", new Object[]{treewalkFile});
                    Throwable throwable7 = null;
                    try {
                        this.treewalkCount = this.treewalkFilesystem(csv, basePath);
                    }
                    catch (Throwable throwable8) {
                        throwable7 = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (ignored22 != null) {
                            if (throwable7 != null) {
                                try {
                                    ignored22.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable7.addSuppressed(throwable9);
                                }
                            } else {
                                ignored22.close();
                            }
                        }
                    }
                }
                catch (Throwable ignored22) {
                    ignored32 = ignored22;
                    throw ignored22;
                }
                finally {
                    if (csv != null) {
                        if (ignored32 != null) {
                            try {
                                csv.close();
                            }
                            catch (Throwable ignored22) {
                                ((Throwable)ignored32).addSuppressed(ignored22);
                            }
                        } else {
                            csv.close();
                        }
                    }
                }
                File flatlistFile = new File(this.destPath + FLAT_CSV).getCanonicalFile();
                CsvFile csv2 = new CsvFile(flatlistFile);
                ignored22 = null;
                try {
                    ignored4 = new DurationInfo(LOG, "Flat list to %s", new Object[]{flatlistFile});
                    throwable3 = null;
                    try {
                        this.listStatusCount = this.listStatusFilesystem(csv2, basePath);
                    }
                    catch (Throwable throwable10) {
                        throwable3 = throwable10;
                        throw throwable10;
                    }
                    finally {
                        if (ignored4 != null) {
                            if (throwable3 != null) {
                                try {
                                    ignored4.close();
                                }
                                catch (Throwable throwable11) {
                                    throwable3.addSuppressed(throwable11);
                                }
                            } else {
                                ignored4.close();
                            }
                        }
                    }
                }
                catch (Throwable ignored4) {
                    ignored22 = ignored4;
                    throw ignored4;
                }
                finally {
                    if (csv2 != null) {
                        if (ignored22 != null) {
                            try {
                                csv2.close();
                            }
                            catch (Throwable ignored4) {
                                ((Throwable)ignored22).addSuppressed(ignored4);
                            }
                        } else {
                            csv2.close();
                        }
                    }
                }
                File rawFile = new File(this.destPath + RAW_CSV).getCanonicalFile();
                CsvFile csv3 = new CsvFile(rawFile);
                ignored4 = null;
                try (DurationInfo ignored5 = new DurationInfo(LOG, "Raw dump to %s", new Object[]{rawFile});){
                    this.rawObjectStoreCount = this.dumpRawS3ObjectStore(csv3);
                }
                catch (Throwable throwable12) {
                    ignored4 = throwable12;
                    throw throwable12;
                }
                finally {
                    if (csv3 != null) {
                        if (ignored4 != null) {
                            try {
                                csv3.close();
                            }
                            catch (Throwable throwable13) {
                                ((Throwable)ignored4).addSuppressed(throwable13);
                            }
                        } else {
                            csv3.close();
                        }
                    }
                }
                File scanFile2 = new File(this.destPath + SCAN2_CSV).getCanonicalFile();
                throwable3 = null;
                try (CsvFile csv4 = new CsvFile(scanFile);
                     DurationInfo ignored6 = new DurationInfo(LOG, "scanFile dump to %s", new Object[]{scanFile2});){
                    this.secondScanResult = this.scanMetastore(csv4);
                }
                catch (Throwable throwable14) {
                    throwable3 = throwable14;
                    throw throwable14;
                }
            }
            return 0;
        }
        catch (IOException | RuntimeException e) {
            LOG.error("failure", (Throwable)e);
            throw e;
        }
    }

    private <T> void pushAll(Deque<T> queue, List<T> entries) {
        List reversed = Lists.reverse(entries);
        for (Object t : reversed) {
            queue.push(t);
        }
    }

    protected long treewalkFilesystem(CsvFile csv, Path base) throws IOException {
        ArrayDeque<Path> queue = new ArrayDeque<Path>();
        queue.add(base);
        long count = 0L;
        while (!queue.isEmpty()) {
            FileStatus[] fileStatuses;
            Path path = (Path)queue.pop();
            ++count;
            try {
                fileStatuses = this.getFilesystem().listStatus(path);
            }
            catch (FileNotFoundException e) {
                LOG.warn("File {} was not found", (Object)path);
                continue;
            }
            for (FileStatus fileStatus : fileStatuses) {
                csv.entry((S3AFileStatus)fileStatus);
            }
            ArrayList<Path> dirs = new ArrayList<Path>(fileStatuses.length);
            for (FileStatus fileStatus : fileStatuses) {
                if (fileStatus.isDirectory() && !fileStatus.getPath().equals((Object)path)) {
                    dirs.add(fileStatus.getPath());
                } else {
                    ++count;
                }
                this.pushAll(queue, dirs);
            }
        }
        return count;
    }

    protected long listStatusFilesystem(CsvFile csv, Path path) throws IOException {
        long count = 0L;
        RemoteIterator<S3ALocatedFileStatus> iterator = this.getFilesystem().listFilesAndEmptyDirectories(path, true);
        while (iterator.hasNext()) {
            S3ALocatedFileStatus status = (S3ALocatedFileStatus)((Object)iterator.next());
            csv.entry(status.toS3AFileStatus());
        }
        return count;
    }

    protected long dumpRawS3ObjectStore(CsvFile csv) throws IOException {
        S3AFileSystem fs = this.getFilesystem();
        Path rootPath = fs.qualify(new Path("/"));
        Listing listing = fs.getListing();
        S3ListRequest request = listing.createListObjectsRequest("", null);
        long count = 0L;
        Listing.FileStatusListingIterator st = listing.createFileStatusListingIterator(rootPath, request, S3AUtils.ACCEPT_ALL, new Listing.AcceptAllButSelfAndS3nDirs(rootPath));
        while (st.hasNext()) {
            S3AFileStatus next = (S3AFileStatus)((Object)st.next());
            LOG.debug("[{}] {}", (Object)(++count), (Object)next);
            csv.entry(next);
        }
        LOG.info("entry count: {}", (Object)count);
        return count;
    }

    protected void dumpMetastore(CsvFile csv, Path basePath) throws IOException {
        this.dumpStoreEntries(csv, this.getStore().listChildren(basePath));
    }

    private Pair<Long, Long> dumpStoreEntries(CsvFile csv, DirListingMetadata dir) throws IOException {
        ArrayDeque<DirListingMetadata> queue = new ArrayDeque<DirListingMetadata>();
        queue.add(dir);
        long files = 0L;
        long dirs = 1L;
        while (!queue.isEmpty()) {
            DirListingMetadata next = (DirListingMetadata)queue.pop();
            ArrayList<DDBPathMetadata> childDirs = new ArrayList<DDBPathMetadata>();
            Collection<PathMetadata> listing = next.getListing();
            ArrayList<PathMetadata> sorted = new ArrayList<PathMetadata>(listing);
            sorted.sort(new PathOrderComparators.PathMetadataComparator((l, r) -> l.compareTo(r)));
            for (PathMetadata pmd : sorted) {
                DDBPathMetadata ddbMd = (DDBPathMetadata)pmd;
                this.dumpEntry(csv, ddbMd);
                if (ddbMd.getFileStatus().isDirectory()) {
                    childDirs.add(ddbMd);
                    continue;
                }
                ++files;
            }
            ArrayList<DirListingMetadata> childMD = new ArrayList<DirListingMetadata>(childDirs.size());
            for (DDBPathMetadata childDir : childDirs) {
                childMD.add(this.getStore().listChildren(childDir.getFileStatus().getPath()));
            }
            this.pushAll(queue, childMD);
        }
        return Pair.of((Object)dirs, (Object)files);
    }

    private void dumpEntry(CsvFile csv, DDBPathMetadata md) {
        LOG.debug("{}", (Object)md.prettyPrint());
        csv.entry(md);
    }

    private Pair<Long, Long> scanMetastore(CsvFile csv) {
        S3GuardTableAccess tableAccess = new S3GuardTableAccess(this.getStore());
        ExpressionSpecBuilder builder = new ExpressionSpecBuilder();
        Iterable<DDBPathMetadata> results = this.getStore().wrapWithRetries(tableAccess.scanMetadata(builder));
        long live = 0L;
        long tombstone = 0L;
        for (DDBPathMetadata md : results) {
            if (md instanceof S3GuardTableAccess.VersionMarker) continue;
            csv.entry(md);
            if (md.isDeleted()) {
                ++tombstone;
                continue;
            }
            ++live;
        }
        return Pair.of((Object)live, (Object)tombstone);
    }

    public Pair<Long, Long> getScanEntryResult() {
        return this.scanEntryResult;
    }

    public Pair<Long, Long> getSecondScanResult() {
        return this.secondScanResult;
    }

    public long getRawObjectStoreCount() {
        return this.rawObjectStoreCount;
    }

    public long getListStatusCount() {
        return this.listStatusCount;
    }

    public long getTreewalkCount() {
        return this.treewalkCount;
    }

    private static String stringify(long millis) {
        return new Date(millis).toString();
    }

    public static void main(String[] args) {
        try {
            DumpS3GuardDynamoTable.serviceMain(Arrays.asList(args), new DumpS3GuardDynamoTable());
        }
        catch (ExitUtil.ExitException e) {
            ExitUtil.terminate((ExitUtil.ExitException)e);
        }
    }

    static void serviceMain(List<String> argsList, AbstractS3GuardDynamoDBDiagnostic service) {
        ServiceLauncher serviceLauncher = new ServiceLauncher(service.getName());
        ExitUtil.ExitException ex = serviceLauncher.launchService(new Configuration(), (Service)service, argsList, false, true);
        if (ex != null) {
            throw ex;
        }
    }

    public static DumpS3GuardDynamoTable dumpStore(@Nullable S3AFileSystem fs, @Nullable DynamoDBMetadataStore store, @Nullable Configuration conf, File destFile, @Nullable URI uri) throws ExitUtil.ExitException {
        DumpS3GuardDynamoTable dump;
        ExitUtil.ExitException ex;
        ServiceLauncher serviceLauncher = new ServiceLauncher(NAME);
        if (conf == null) {
            conf = ((S3AFileSystem)Preconditions.checkNotNull((Object)fs, (Object)"No filesystem")).getConf();
        }
        if (store == null) {
            store = (DynamoDBMetadataStore)((S3AFileSystem)Preconditions.checkNotNull((Object)fs, (Object)"No filesystem")).getMetadataStore();
        }
        if ((ex = serviceLauncher.launchService(conf, (Service)(dump = new DumpS3GuardDynamoTable(fs, store, destFile, uri)), Collections.emptyList(), false, true)) != null && ex.getExitCode() != 0) {
            throw ex;
        }
        LOG.info("Results:");
        Pair<Long, Long> r = dump.getScanEntryResult();
        LOG.info("Metastore entries: {}", r);
        LOG.info("Metastore scan total {}, entries {}, tombstones {}", new Object[]{(Long)r.getLeft() + (Long)r.getRight(), r.getLeft(), r.getRight()});
        LOG.info("S3 count {}", (Object)dump.getRawObjectStoreCount());
        LOG.info("Treewalk Count {}", (Object)dump.getTreewalkCount());
        LOG.info("List Status Count {}", (Object)dump.getListStatusCount());
        r = dump.getSecondScanResult();
        if (r != null) {
            LOG.info("Second metastore scan total {}, entries {}, tombstones {}", new Object[]{(Long)r.getLeft() + (Long)r.getRight(), r.getLeft(), r.getRight()});
        }
        return dump;
    }

    private static final class CsvFile
    implements Closeable {
        public static final long ALL_QUOTES = Integer.MAX_VALUE;
        public static final int ROW_QUOTE_MAP = 3743;
        public static final long NO_QUOTES = 0L;
        private final Path path;
        private final PrintWriter out;
        private final String separator;
        private final String eol;
        private final String quote;

        private CsvFile(Path path, PrintWriter out, String separator, String eol, String quote) throws IOException {
            this.separator = (String)Preconditions.checkNotNull((Object)separator);
            this.eol = (String)Preconditions.checkNotNull((Object)eol);
            this.quote = (String)Preconditions.checkNotNull((Object)quote);
            this.path = path;
            this.out = (PrintWriter)Preconditions.checkNotNull((Object)out);
            this.header();
        }

        private CsvFile(File file) throws IOException {
            this(null, new PrintWriter(file, "UTF-8"), "\t", "\n", "\"");
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.out != null) {
                this.out.close();
            }
        }

        public Path getPath() {
            return this.path;
        }

        public String getSeparator() {
            return this.separator;
        }

        public String getEol() {
            return this.eol;
        }

        public CsvFile row(long quotes, Object ... columns) {
            Preconditions.checkNotNull((Object)this.out);
            for (int i = 0; i < columns.length; ++i) {
                Object column;
                if (i != 0) {
                    this.out.write(this.separator);
                }
                boolean toQuote = (quotes & 1L) == 1L;
                quotes >>>= 1;
                if (toQuote) {
                    this.out.write(this.quote);
                }
                this.out.write((column = columns[i]) != null ? column.toString() : "");
                if (!toQuote) continue;
                this.out.write(this.quote);
            }
            this.out.write(this.eol);
            return this;
        }

        public CsvFile line(String line) {
            this.out.write(line);
            this.out.write(this.eol);
            return this;
        }

        public PrintWriter getOut() {
            return this.out;
        }

        void header() {
            this.row(Integer.MAX_VALUE, "type", "deleted", "path", "is_auth_dir", "is_empty_dir", "len", "updated", "updated_s", "last_modified", "last_modified_s", "etag", "version");
        }

        void entry(DDBPathMetadata md) {
            S3AFileStatus fileStatus = md.getFileStatus();
            this.row(3743L, fileStatus.isDirectory() ? "dir" : "file", md.isDeleted(), fileStatus.getPath().toString(), md.isAuthoritativeDir(), md.isEmptyDirectory().name(), fileStatus.getLen(), md.getLastUpdated(), DumpS3GuardDynamoTable.stringify(md.getLastUpdated()), fileStatus.getModificationTime(), DumpS3GuardDynamoTable.stringify(fileStatus.getModificationTime()), fileStatus.getETag(), fileStatus.getVersionId());
        }

        void entry(S3AFileStatus fileStatus) {
            this.row(3743L, fileStatus.isDirectory() ? "dir" : "file", "false", fileStatus.getPath().toString(), "", fileStatus.isEmptyDirectory().name(), fileStatus.getLen(), "", "", fileStatus.getModificationTime(), DumpS3GuardDynamoTable.stringify(fileStatus.getModificationTime()), fileStatus.getETag(), fileStatus.getVersionId());
        }
    }
}

