/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.amazonaws.SdkBaseException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.impl.AbstractStoreOperation;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.s3guard.BulkOperationState;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.DurationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RenameTracker
extends AbstractStoreOperation {
    public static final Logger LOG = LoggerFactory.getLogger(RenameTracker.class);
    private final Path sourceRoot;
    private final Path dest;
    private final DurationInfo durationInfo;
    private final String name;
    private final BulkOperationState operationState;
    private final MetadataStore metadataStore;

    protected RenameTracker(String name, StoreContext storeContext, MetadataStore metadataStore, Path sourceRoot, Path dest, BulkOperationState operationState) {
        super((StoreContext)Preconditions.checkNotNull((Object)storeContext));
        Preconditions.checkNotNull((Object)storeContext.getUsername(), (Object)"No username");
        this.metadataStore = (MetadataStore)Preconditions.checkNotNull((Object)metadataStore);
        this.sourceRoot = (Path)Preconditions.checkNotNull((Object)sourceRoot);
        this.dest = (Path)Preconditions.checkNotNull((Object)dest);
        this.operationState = operationState;
        this.name = String.format("%s (%s, %s)", name, sourceRoot, dest);
        this.durationInfo = new DurationInfo(LOG, false, name + " (%s, %s)", new Object[]{sourceRoot, dest});
    }

    public String toString() {
        return this.name;
    }

    public Path getSourceRoot() {
        return this.sourceRoot;
    }

    public Path getDest() {
        return this.dest;
    }

    public String getOwner() {
        return this.getStoreContext().getUsername();
    }

    public BulkOperationState getOperationState() {
        return this.operationState;
    }

    protected MetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    public abstract void fileCopied(Path var1, S3ObjectAttributes var2, S3ObjectAttributes var3, Path var4, long var5, boolean var7) throws IOException;

    public void directoryMarkerCopied(Path sourcePath, Path destPath, boolean addAncestors) throws IOException {
    }

    public IOException deleteFailed(Exception e, List<Path> pathsToDelete, List<Path> undeletedObjects) {
        return this.convertToIOException(e);
    }

    public void moveSourceDirectory() throws IOException {
    }

    public void sourceObjectsDeleted(Collection<Path> paths) throws IOException {
    }

    public void completeRename() throws IOException {
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.operationState});
        this.noteRenameFinished();
    }

    protected void noteRenameFinished() {
        this.durationInfo.close();
    }

    public IOException renameFailed(Exception ex) {
        LOG.debug("Rename has failed", (Throwable)ex);
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.operationState});
        this.noteRenameFinished();
        return this.convertToIOException(ex);
    }

    protected IOException convertToIOException(Exception ex) {
        if (ex instanceof IOException) {
            return (IOException)ex;
        }
        if (ex instanceof SdkBaseException) {
            return S3AUtils.translateException("rename " + this.sourceRoot + " to " + this.dest, this.sourceRoot.toString(), (SdkBaseException)((Object)ex));
        }
        return new IOException(ex);
    }
}

