/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Stat
extends FsCommand {
    public static final String NAME = "stat";
    public static final String USAGE = "[format] <path> ...";
    public static final String DESCRIPTION = "Print statistics about the file/directory at <path>\nin the specified format. Format accepts filesize in blocks (%b), filename (%n),\nblock size (%o), replication (%r), modification date (%y, %Y)\n";
    protected static final SimpleDateFormat timeFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected String format = "%y";

    Stat() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Stat.class, "-stat");
    }

    @Override
    protected void processOptions(LinkedList<String> args) throws IOException {
        CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "R");
        cf.parse(args);
        this.setRecursive(cf.getOpt("R"));
        if (args.getFirst().contains("%")) {
            this.format = args.removeFirst();
        }
        cf.parse(args);
    }

    @Override
    protected void processPath(PathData item) throws IOException {
        FileStatus stat = item.stat;
        StringBuilder buf = new StringBuilder();
        char[] fmt = this.format.toCharArray();
        block9: for (int i = 0; i < fmt.length; ++i) {
            if (fmt[i] != '%') {
                buf.append(fmt[i]);
                continue;
            }
            if (i + 1 == fmt.length) break;
            switch (fmt[++i]) {
                case 'b': {
                    buf.append(stat.getLen());
                    continue block9;
                }
                case 'F': {
                    buf.append(stat.isDirectory() ? "directory" : (stat.isFile() ? "regular file" : "symlink"));
                    continue block9;
                }
                case 'n': {
                    buf.append(item.path.getName());
                    continue block9;
                }
                case 'o': {
                    buf.append(stat.getBlockSize());
                    continue block9;
                }
                case 'r': {
                    buf.append(stat.getReplication());
                    continue block9;
                }
                case 'y': {
                    buf.append(timeFmt.format(new Date(stat.getModificationTime())));
                    continue block9;
                }
                case 'Y': {
                    buf.append(stat.getModificationTime());
                    continue block9;
                }
                default: {
                    buf.append(fmt[i]);
                }
            }
        }
        this.out.println(buf.toString());
    }

    static {
        timeFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

