/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FilterFileSystem
extends FileSystem {
    protected FileSystem fs;

    public FilterFileSystem() {
    }

    public FilterFileSystem(FileSystem fs) {
        this.fs = fs;
        this.statistics = fs.statistics;
    }

    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        this.fs.initialize(name, conf);
    }

    @Override
    public URI getUri() {
        return this.fs.getUri();
    }

    @Override
    public Path makeQualified(Path path) {
        return this.fs.makeQualified(path);
    }

    @Override
    protected void checkPath(Path path) {
        this.fs.checkPath(path);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        return this.fs.getFileBlockLocations(file, start, len);
    }

    @Override
    public Path resolvePath(Path p) throws IOException {
        return this.fs.resolvePath(p);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return this.fs.open(f, bufferSize);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return this.fs.append(f, bufferSize, progress);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fs.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Override
    public boolean setReplication(Path src, short replication) throws IOException {
        return this.fs.setReplication(src, replication);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        return this.fs.rename(src, dst);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.fs.delete(f, recursive);
    }

    @Override
    public boolean deleteOnExit(Path f) throws IOException {
        return this.fs.deleteOnExit(f);
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        return this.fs.listStatus(f);
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws IOException {
        return this.fs.listLocatedStatus(f);
    }

    @Override
    public Path getHomeDirectory() {
        return this.fs.getHomeDirectory();
    }

    @Override
    public void setWorkingDirectory(Path newDir) {
        this.fs.setWorkingDirectory(newDir);
    }

    @Override
    public Path getWorkingDirectory() {
        return this.fs.getWorkingDirectory();
    }

    @Override
    protected Path getInitialWorkingDirectory() {
        return this.fs.getInitialWorkingDirectory();
    }

    @Override
    public FsStatus getStatus(Path p) throws IOException {
        return this.fs.getStatus(p);
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.fs.mkdirs(f, permission);
    }

    @Override
    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.fs.copyFromLocalFile(delSrc, src, dst);
    }

    @Override
    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        this.fs.copyFromLocalFile(delSrc, overwrite, srcs, dst);
    }

    @Override
    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.fs.copyFromLocalFile(delSrc, overwrite, src, dst);
    }

    @Override
    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.fs.copyToLocalFile(delSrc, src, dst);
    }

    @Override
    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return this.fs.startLocalOutput(fsOutputFile, tmpLocalFile);
    }

    @Override
    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        this.fs.completeLocalOutput(fsOutputFile, tmpLocalFile);
    }

    @Override
    public long getUsed() throws IOException {
        return this.fs.getUsed();
    }

    @Override
    public long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize();
    }

    @Override
    public short getDefaultReplication() {
        return this.fs.getDefaultReplication();
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        return this.fs.getFileStatus(f);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws IOException {
        return this.fs.getFileChecksum(f);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) {
        this.fs.setVerifyChecksum(verifyChecksum);
    }

    @Override
    public Configuration getConf() {
        return this.fs.getConf();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.fs.close();
    }

    @Override
    public void setOwner(Path p, String username, String groupname) throws IOException {
        this.fs.setOwner(p, username, groupname);
    }

    @Override
    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.fs.setTimes(p, mtime, atime);
    }

    @Override
    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.fs.setPermission(p, permission);
    }

    @Override
    protected FSDataOutputStream primitiveCreate(Path f, FsPermission absolutePermission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress, int bytesPerChecksum) throws IOException {
        return this.fs.primitiveCreate(f, absolutePermission, flag, bufferSize, replication, blockSize, progress, bytesPerChecksum);
    }

    @Override
    protected boolean primitiveMkdir(Path f, FsPermission abdolutePermission) throws IOException {
        return this.fs.primitiveMkdir(f, abdolutePermission);
    }

    @Override
    public String getCanonicalServiceName() {
        return this.fs.getCanonicalServiceName();
    }

    @Override
    public Token<?> getDelegationToken(String renewer) throws IOException {
        return this.fs.getDelegationToken(renewer);
    }

    @Override
    public List<Token<?>> getDelegationTokens(String renewer) throws IOException {
        return this.fs.getDelegationTokens(renewer);
    }
}

