/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandFormat {
    final String name;
    final int minPar;
    final int maxPar;
    final Map<String, Boolean> options = new HashMap<String, Boolean>();
    boolean ignoreUnknownOpts = false;

    public CommandFormat(String n, int min, int max, String ... possibleOpt) {
        this.name = n;
        this.minPar = min;
        this.maxPar = max;
        for (String opt : possibleOpt) {
            if (opt == null) {
                this.ignoreUnknownOpts = true;
                continue;
            }
            this.options.put(opt, Boolean.FALSE);
        }
    }

    public List<String> parse(String[] args, int pos) {
        ArrayList<String> parameters = new ArrayList<String>(Arrays.asList(args));
        parameters.subList(0, pos).clear();
        this.parse(parameters);
        return parameters;
    }

    public void parse(List<String> args) {
        int pos = 0;
        while (pos < args.size()) {
            String arg = args.get(pos);
            if (arg.startsWith("-") && arg.length() > 1) {
                String opt = arg.substring(1);
                if (this.options.containsKey(opt)) {
                    args.remove(pos);
                    this.options.put(opt, Boolean.TRUE);
                    continue;
                }
                if (!this.ignoreUnknownOpts) {
                    throw new UnknownOptionException(arg);
                }
            }
            ++pos;
        }
        int psize = args.size();
        if (psize < this.minPar) {
            throw new NotEnoughArgumentsException(this.minPar, psize);
        }
        if (psize > this.maxPar) {
            throw new TooManyArgumentsException(this.maxPar, psize);
        }
    }

    public boolean getOpt(String option) {
        return this.options.containsKey(option) ? this.options.get(option) : false;
    }

    public Set<String> getOpts() {
        HashSet<String> optSet = new HashSet<String>();
        for (Map.Entry<String, Boolean> entry : this.options.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            optSet.add(entry.getKey());
        }
        return optSet;
    }

    public static class UnknownOptionException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 0L;
        protected String option = null;

        public UnknownOptionException(String unknownOption) {
            super("Illegal option " + unknownOption);
            this.option = unknownOption;
        }

        public String getOption() {
            return this.option;
        }
    }

    public static class NotEnoughArgumentsException
    extends IllegalNumberOfArgumentsException {
        private static final long serialVersionUID = 0L;

        public NotEnoughArgumentsException(int expected, int actual) {
            super(expected, actual);
        }

        @Override
        public String getMessage() {
            return "Not enough arguments: " + super.getMessage();
        }
    }

    public static class TooManyArgumentsException
    extends IllegalNumberOfArgumentsException {
        private static final long serialVersionUID = 0L;

        public TooManyArgumentsException(int expected, int actual) {
            super(expected, actual);
        }

        @Override
        public String getMessage() {
            return "Too many arguments: " + super.getMessage();
        }
    }

    public static abstract class IllegalNumberOfArgumentsException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 0L;
        protected int expected;
        protected int actual;

        protected IllegalNumberOfArgumentsException(int want, int got) {
            this.expected = want;
            this.actual = got;
        }

        @Override
        public String getMessage() {
            return "expected " + this.expected + " but got " + this.actual;
        }
    }
}

