/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.PathExceptions;

abstract class CommandWithDestination
extends FsCommand {
    protected PathData dst;
    protected boolean overwrite = false;

    CommandWithDestination() {
    }

    protected void setOverwrite(boolean flag) {
        this.overwrite = flag;
    }

    protected void getLocalDestination(LinkedList<String> args) throws IOException {
        String pathString = args.size() < 2 ? "." : args.removeLast();
        this.dst = new PathData(new File(pathString), this.getConf());
    }

    protected void getRemoteDestination(LinkedList<String> args) throws IOException {
        if (args.size() < 2) {
            this.dst = new PathData(".", this.getConf());
        } else {
            String pathString = args.removeLast();
            PathData[] items = PathData.expandAsGlob(pathString, this.getConf());
            switch (items.length) {
                case 0: {
                    throw new PathExceptions.PathNotFoundException(pathString);
                }
                case 1: {
                    this.dst = items[0];
                    break;
                }
                default: {
                    throw new PathExceptions.PathIOException(pathString, "Too many matches");
                }
            }
        }
    }

    @Override
    protected void processArguments(LinkedList<PathData> args) throws IOException {
        if (args.size() > 1) {
            if (!this.dst.exists) {
                throw new PathExceptions.PathNotFoundException(this.dst.toString());
            }
            if (!this.dst.stat.isDirectory()) {
                throw new PathExceptions.PathIsNotDirectoryException(this.dst.toString());
            }
        } else if (this.dst.exists && !this.dst.stat.isDirectory() && !this.overwrite) {
            throw new PathExceptions.PathExistsException(this.dst.toString());
        }
        super.processArguments(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processPaths(PathData parent, PathData ... items) throws IOException {
        PathData savedDst = this.dst;
        try {
            if (parent != null) {
                this.dst = this.dst.getPathDataForChild(parent);
            }
            super.processPaths(parent, items);
        }
        finally {
            this.dst = savedDst;
        }
    }

    @Override
    protected void processPath(PathData src) throws IOException {
        PathData target = this.dst.exists && this.dst.stat.isDirectory() ? this.dst.getPathDataForChild(src) : this.dst;
        if (target.exists && !this.overwrite) {
            throw new PathExceptions.PathExistsException(target.toString());
        }
        try {
            this.processPath(src, target);
        }
        catch (PathExceptions.PathIOException e) {
            if (e.getTargetPath() == null) {
                e.setTargetPath(target.toString());
            }
            throw e;
        }
    }

    protected abstract void processPath(PathData var1, PathData var2) throws IOException;
}

