/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.PathExceptions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class Delete
extends FsCommand {
    Delete() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Rm.class, "-rm");
        factory.addClass(Rmr.class, "-rmr");
        factory.addClass(Expunge.class, "-expunge");
    }

    static class Expunge
    extends FsCommand {
        public static final String NAME = "expunge";
        public static final String USAGE = "";
        public static final String DESCRIPTION = "Empty the Trash";

        Expunge() {
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(null, 0, 0, new String[0]);
            cf.parse(args);
        }

        @Override
        protected void processArguments(LinkedList<PathData> args) throws IOException {
            Trash trash = new Trash(this.getConf());
            trash.expunge();
            trash.checkpoint();
        }
    }

    static class Rmr
    extends Rm {
        public static final String NAME = "rmr";

        Rmr() {
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            args.addFirst("-r");
            super.processOptions(args);
        }

        @Override
        public String getReplacementCommand() {
            return "rm -r";
        }
    }

    public static class Rm
    extends FsCommand {
        public static final String NAME = "rm";
        public static final String USAGE = "[-r|-R] [-skipTrash] <src> ...";
        public static final String DESCRIPTION = "Delete all files that match the specified file pattern.\nEquivalent to the Unix command \"rm <src>\"\n-skipTrash option bypasses trash, if enabled, and immediately\ndeletes <src>\n  -[rR]  Recursively deletes directories";
        private boolean skipTrash = false;
        private boolean deleteDirs = false;

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(null, 1, Integer.MAX_VALUE, "r", "R", "skipTrash");
            cf.parse(args);
            this.deleteDirs = cf.getOpt("r") || cf.getOpt("R");
            this.skipTrash = cf.getOpt("skipTrash");
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            if (item.stat.isDirectory() && !this.deleteDirs) {
                throw new PathExceptions.PathIsDirectoryException(item.toString());
            }
            if (this.moveToTrash(item)) {
                return;
            }
            if (!item.fs.delete(item.path, this.deleteDirs)) {
                throw new PathExceptions.PathIOException(item.toString());
            }
            this.out.println("Deleted " + item);
        }

        private boolean moveToTrash(PathData item) throws IOException {
            boolean success = false;
            if (!this.skipTrash) {
                success = Trash.moveToAppropriateTrash(item.fs, item.path, this.getConf());
            }
            return success;
        }
    }
}

