/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.local.LocalConfigKeys;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ChRootedFs;
import org.apache.hadoop.fs.viewfs.Constants;
import org.apache.hadoop.fs.viewfs.InodeTree;
import org.apache.hadoop.fs.viewfs.ViewFsFileStatus;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ViewFs
extends AbstractFileSystem {
    final long creationTime = System.currentTimeMillis();
    final UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
    final Configuration config;
    InodeTree<AbstractFileSystem> fsState;
    Path homeDir = null;

    static AccessControlException readOnlyMountTable(String operation, String p) {
        return new AccessControlException("InternalDir of ViewFileSystem is readonly; operation=" + operation + "Path=" + p);
    }

    static AccessControlException readOnlyMountTable(String operation, Path p) {
        return ViewFs.readOnlyMountTable(operation, p.toString());
    }

    public ViewFs(Configuration conf) throws IOException, URISyntaxException {
        this(FsConstants.VIEWFS_URI, conf);
    }

    ViewFs(URI theUri, Configuration conf) throws IOException, URISyntaxException {
        super(theUri, "viewfs", false, -1);
        this.config = conf;
        String authority = theUri.getAuthority();
        this.fsState = new InodeTree<AbstractFileSystem>(conf, authority){

            @Override
            protected AbstractFileSystem getTargetFileSystem(URI uri) throws URISyntaxException, UnsupportedFileSystemException {
                return new ChRootedFs(AbstractFileSystem.createFileSystem(uri, ViewFs.this.config), new Path(uri.getPath()));
            }

            @Override
            protected AbstractFileSystem getTargetFileSystem(InodeTree.INodeDir<AbstractFileSystem> dir) throws URISyntaxException {
                return new InternalDirOfViewFs(dir, ViewFs.this.creationTime, ViewFs.this.ugi, ViewFs.this.getUri());
            }

            @Override
            protected AbstractFileSystem getTargetFileSystem(URI[] mergeFsURIList) throws URISyntaxException, UnsupportedFileSystemException {
                throw new UnsupportedFileSystemException("mergefs not implemented yet");
            }
        };
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return LocalConfigKeys.getServerDefaults();
    }

    @Override
    public int getUriDefaultPort() {
        return -1;
    }

    @Override
    public Path getHomeDirectory() {
        if (this.homeDir == null) {
            String base = this.fsState.getHomeDirPrefixValue();
            if (base == null) {
                base = "/user";
            }
            this.homeDir = this.makeQualified(new Path(base + "/" + this.ugi.getShortUserName()));
        }
        return this.homeDir;
    }

    @Override
    public Path resolvePath(Path f) throws FileNotFoundException, AccessControlException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        if (res.isInternalDir()) {
            return f;
        }
        return ((AbstractFileSystem)res.targetFileSystem).resolvePath(res.remainingPath);
    }

    @Override
    public FSDataOutputStream createInternal(Path f, EnumSet<CreateFlag> flag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, int bytesPerChecksum, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res;
        try {
            res = this.fsState.resolve(this.getUriPath(f), false);
        }
        catch (FileNotFoundException e) {
            if (createParent) {
                throw ViewFs.readOnlyMountTable("create", f);
            }
            throw e;
        }
        assert (res.remainingPath != null);
        return ((AbstractFileSystem)res.targetFileSystem).createInternal(res.remainingPath, flag, absolutePermission, bufferSize, replication, blockSize, progress, bytesPerChecksum, createParent);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        if (res.isInternalDir() || res.remainingPath == InodeTree.SlashPath) {
            throw new AccessControlException("Cannot delete internal mount table directory: " + f);
        }
        return ((AbstractFileSystem)res.targetFileSystem).delete(res.remainingPath, recursive);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((AbstractFileSystem)res.targetFileSystem).getFileBlockLocations(res.remainingPath, start, len);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((AbstractFileSystem)res.targetFileSystem).getFileChecksum(f);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        FileStatus status = ((AbstractFileSystem)res.targetFileSystem).getFileStatus(res.remainingPath);
        return new ViewFsFileStatus(status, this.makeQualified(f));
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws AccessControlException, FileNotFoundException, UnsupportedFileSystemException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), false);
        return ((AbstractFileSystem)res.targetFileSystem).getFileLinkStatus(res.remainingPath);
    }

    @Override
    public FsStatus getFsStatus() throws AccessControlException, FileNotFoundException, IOException {
        return new FsStatus(0L, 0L, 0L);
    }

    @Override
    public RemoteIterator<FileStatus> listStatusIterator(final Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        final InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        final RemoteIterator<FileStatus> fsIter = ((AbstractFileSystem)res.targetFileSystem).listStatusIterator(res.remainingPath);
        if (res.isInternalDir()) {
            return fsIter;
        }
        return new RemoteIterator<FileStatus>(){
            final RemoteIterator<FileStatus> myIter;
            final ChRootedFs targetFs;
            {
                this.myIter = fsIter;
                this.targetFs = (ChRootedFs)res.targetFileSystem;
            }

            @Override
            public boolean hasNext() throws IOException {
                return this.myIter.hasNext();
            }

            @Override
            public FileStatus next() throws IOException {
                FileStatus status;
                String suffix = this.targetFs.stripOutRoot((status = this.myIter.next()).getPath());
                return new ViewFsFileStatus(status, ViewFs.this.makeQualified(suffix.length() == 0 ? f : new Path(res.resolvedPath, suffix)));
            }
        };
    }

    @Override
    public FileStatus[] listStatus(Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        FileStatus[] statusLst = ((AbstractFileSystem)res.targetFileSystem).listStatus(res.remainingPath);
        if (!res.isInternalDir()) {
            ChRootedFs targetFs = (ChRootedFs)res.targetFileSystem;
            int i = 0;
            for (FileStatus status : statusLst) {
                String suffix = targetFs.stripOutRoot(status.getPath());
                statusLst[i++] = new ViewFsFileStatus(status, this.makeQualified(suffix.length() == 0 ? f : new Path(res.resolvedPath, suffix)));
            }
        }
        return statusLst;
    }

    @Override
    public void mkdir(Path dir, FsPermission permission, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(dir), false);
        ((AbstractFileSystem)res.targetFileSystem).mkdir(res.remainingPath, permission, createParent);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((AbstractFileSystem)res.targetFileSystem).open(res.remainingPath, bufferSize);
    }

    @Override
    public void renameInternal(Path src, Path dst, boolean overwrite) throws IOException, UnresolvedLinkException {
        InodeTree.ResolveResult<AbstractFileSystem> resSrc = this.fsState.resolve(this.getUriPath(src), false);
        if (resSrc.isInternalDir()) {
            throw new AccessControlException("Cannot Rename within internal dirs of mount table: it is readOnly");
        }
        InodeTree.ResolveResult<AbstractFileSystem> resDst = this.fsState.resolve(this.getUriPath(dst), false);
        if (resDst.isInternalDir()) {
            throw new AccessControlException("Cannot Rename within internal dirs of mount table: it is readOnly");
        }
        if (resSrc.targetFileSystem != resDst.targetFileSystem) {
            throw new IOException("Renames across Mount points not supported");
        }
        ((AbstractFileSystem)resSrc.targetFileSystem).renameInternal(resSrc.remainingPath, resDst.remainingPath, overwrite);
    }

    @Override
    public void renameInternal(Path src, Path dst) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnresolvedLinkException, IOException {
        this.renameInternal(src, dst, false);
    }

    @Override
    public boolean supportsSymlinks() {
        return true;
    }

    @Override
    public void createSymlink(Path target, Path link, boolean createParent) throws IOException, UnresolvedLinkException {
        InodeTree.ResolveResult<AbstractFileSystem> res;
        try {
            res = this.fsState.resolve(this.getUriPath(link), false);
        }
        catch (FileNotFoundException e) {
            if (createParent) {
                throw ViewFs.readOnlyMountTable("createSymlink", link);
            }
            throw e;
        }
        assert (res.remainingPath != null);
        ((AbstractFileSystem)res.targetFileSystem).createSymlink(target, res.remainingPath, createParent);
    }

    @Override
    public Path getLinkTarget(Path f) throws IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), false);
        return ((AbstractFileSystem)res.targetFileSystem).getLinkTarget(res.remainingPath);
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((AbstractFileSystem)res.targetFileSystem).setOwner(res.remainingPath, username, groupname);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((AbstractFileSystem)res.targetFileSystem).setPermission(res.remainingPath, permission);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        return ((AbstractFileSystem)res.targetFileSystem).setReplication(res.remainingPath, replication);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        InodeTree.ResolveResult<AbstractFileSystem> res = this.fsState.resolve(this.getUriPath(f), true);
        ((AbstractFileSystem)res.targetFileSystem).setTimes(res.remainingPath, mtime, atime);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) throws AccessControlException, IOException {
    }

    public MountPoint[] getMountPoints() {
        List<InodeTree.MountPoint<AbstractFileSystem>> mountPoints = this.fsState.getMountPoints();
        MountPoint[] result = new MountPoint[mountPoints.size()];
        for (int i = 0; i < mountPoints.size(); ++i) {
            result[i] = new MountPoint(new Path(mountPoints.get((int)i).src), mountPoints.get((int)i).target.targetDirLinkList);
        }
        return result;
    }

    @Override
    public List<Token<?>> getDelegationTokens(String renewer) throws IOException {
        List<InodeTree.MountPoint<AbstractFileSystem>> mountPoints = this.fsState.getMountPoints();
        int initialListSize = 0;
        for (InodeTree.MountPoint<AbstractFileSystem> im : mountPoints) {
            initialListSize += im.target.targetDirLinkList.length;
        }
        ArrayList result = new ArrayList(initialListSize);
        for (int i = 0; i < mountPoints.size(); ++i) {
            List<Token<?>> tokens = ((AbstractFileSystem)mountPoints.get((int)i).target.targetFileSystem).getDelegationTokens(renewer);
            if (tokens == null) continue;
            result.addAll(tokens);
        }
        return result;
    }

    static class InternalDirOfViewFs
    extends AbstractFileSystem {
        final InodeTree.INodeDir<AbstractFileSystem> theInternalDir;
        final long creationTime;
        final UserGroupInformation ugi;
        final URI myUri;

        public InternalDirOfViewFs(InodeTree.INodeDir<AbstractFileSystem> dir, long cTime, UserGroupInformation ugi, URI uri) throws URISyntaxException {
            super(FsConstants.VIEWFS_URI, "viewfs", false, -1);
            this.theInternalDir = dir;
            this.creationTime = cTime;
            this.ugi = ugi;
            this.myUri = uri;
        }

        private static void checkPathIsSlash(Path f) throws IOException {
            if (f != InodeTree.SlashPath) {
                throw new IOException("Internal implementation error: expected file name to be /");
            }
        }

        @Override
        public FSDataOutputStream createInternal(Path f, EnumSet<CreateFlag> flag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, int bytesPerChecksum, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, UnresolvedLinkException, IOException {
            throw ViewFs.readOnlyMountTable("create", f);
        }

        @Override
        public boolean delete(Path f, boolean recursive) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFs.readOnlyMountTable("delete", f);
        }

        @Override
        public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public FileChecksum getFileChecksum(Path f) throws FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public FileStatus getFileStatus(Path f) throws IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            return new FileStatus(0L, true, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_RRR, this.ugi.getUserName(), this.ugi.getGroupNames()[0], new Path(this.theInternalDir.fullPath).makeQualified(this.myUri, null));
        }

        @Override
        public FileStatus getFileLinkStatus(Path f) throws FileNotFoundException {
            FileStatus result;
            InodeTree.INode inode = this.theInternalDir.children.get(f.toUri().toString().substring(1));
            if (inode == null) {
                throw new FileNotFoundException("viewFs internal mount table - missing entry:" + f);
            }
            if (inode instanceof InodeTree.INodeLink) {
                InodeTree.INodeLink inodelink = (InodeTree.INodeLink)inode;
                result = new FileStatus(0L, false, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_RRR, this.ugi.getUserName(), this.ugi.getGroupNames()[0], inodelink.getTargetLink(), new Path(inode.fullPath).makeQualified(this.myUri, null));
            } else {
                result = new FileStatus(0L, true, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_RRR, this.ugi.getUserName(), this.ugi.getGroupNames()[0], new Path(inode.fullPath).makeQualified(this.myUri, null));
            }
            return result;
        }

        @Override
        public FsStatus getFsStatus() {
            return new FsStatus(0L, 0L, 0L);
        }

        @Override
        public FsServerDefaults getServerDefaults() throws IOException {
            throw new IOException("FsServerDefaults not implemented yet");
        }

        @Override
        public int getUriDefaultPort() {
            return -1;
        }

        @Override
        public FileStatus[] listStatus(Path f) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            FileStatus[] result = new FileStatus[this.theInternalDir.children.size()];
            int i = 0;
            for (Map.Entry iEntry : this.theInternalDir.children.entrySet()) {
                InodeTree.INode inode = iEntry.getValue();
                if (inode instanceof InodeTree.INodeLink) {
                    InodeTree.INodeLink link = (InodeTree.INodeLink)inode;
                    result[i++] = new FileStatus(0L, false, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_RRR, this.ugi.getUserName(), this.ugi.getGroupNames()[0], link.getTargetLink(), new Path(inode.fullPath).makeQualified(this.myUri, null));
                    continue;
                }
                result[i++] = new FileStatus(0L, true, 0, 0L, this.creationTime, this.creationTime, Constants.PERMISSION_RRR, this.ugi.getUserName(), this.ugi.getGroupNames()[0], new Path(inode.fullPath).makeQualified(this.myUri, null));
            }
            return result;
        }

        @Override
        public void mkdir(Path dir, FsPermission permission, boolean createParent) throws AccessControlException, FileAlreadyExistsException {
            if (this.theInternalDir.isRoot & dir == null) {
                throw new FileAlreadyExistsException("/ already exits");
            }
            throw ViewFs.readOnlyMountTable("mkdir", dir);
        }

        @Override
        public FSDataInputStream open(Path f, int bufferSize) throws FileNotFoundException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw new FileNotFoundException("Path points to dir not a file");
        }

        @Override
        public void renameInternal(Path src, Path dst) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(src);
            InternalDirOfViewFs.checkPathIsSlash(dst);
            throw ViewFs.readOnlyMountTable("rename", src);
        }

        @Override
        public boolean supportsSymlinks() {
            return true;
        }

        @Override
        public void createSymlink(Path target, Path link, boolean createParent) throws AccessControlException {
            throw ViewFs.readOnlyMountTable("createSymlink", link);
        }

        @Override
        public Path getLinkTarget(Path f) throws FileNotFoundException, IOException {
            return this.getFileLinkStatus(f).getSymlink();
        }

        @Override
        public void setOwner(Path f, String username, String groupname) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFs.readOnlyMountTable("setOwner", f);
        }

        @Override
        public void setPermission(Path f, FsPermission permission) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFs.readOnlyMountTable("setPermission", f);
        }

        @Override
        public boolean setReplication(Path f, short replication) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFs.readOnlyMountTable("setReplication", f);
        }

        @Override
        public void setTimes(Path f, long mtime, long atime) throws AccessControlException, IOException {
            InternalDirOfViewFs.checkPathIsSlash(f);
            throw ViewFs.readOnlyMountTable("setTimes", f);
        }

        @Override
        public void setVerifyChecksum(boolean verifyChecksum) throws AccessControlException {
            throw ViewFs.readOnlyMountTable("setVerifyChecksum", "");
        }
    }

    public static class MountPoint {
        private Path src;
        private URI[] targets;

        MountPoint(Path srcPath, URI[] targetURIs) {
            this.src = srcPath;
            this.targets = targetURIs;
        }

        Path getSrc() {
            return this.src;
        }

        URI[] getTargets() {
            return this.targets;
        }
    }
}

