/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.SocketIOWithTimeout;
import org.apache.hadoop.net.SocketInputStream;
import org.apache.hadoop.net.SocketOutputStream;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class NetUtils {
    private static final Log LOG = LogFactory.getLog(NetUtils.class);
    private static Map<String, String> hostToResolved = new HashMap<String, String>();
    private static final Pattern ipPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}:?\\d*");

    public static SocketFactory getSocketFactory(Configuration conf, Class<?> clazz) {
        SocketFactory factory = null;
        String propValue = conf.get("hadoop.rpc.socket.factory.class." + clazz.getSimpleName());
        if (propValue != null && propValue.length() > 0) {
            factory = NetUtils.getSocketFactoryFromProperty(conf, propValue);
        }
        if (factory == null) {
            factory = NetUtils.getDefaultSocketFactory(conf);
        }
        return factory;
    }

    public static SocketFactory getDefaultSocketFactory(Configuration conf) {
        String propValue = conf.get("hadoop.rpc.socket.factory.class.default");
        if (propValue == null || propValue.length() == 0) {
            return SocketFactory.getDefault();
        }
        return NetUtils.getSocketFactoryFromProperty(conf, propValue);
    }

    public static SocketFactory getSocketFactoryFromProperty(Configuration conf, String propValue) {
        try {
            Class<?> theClass = conf.getClassByName(propValue);
            return (SocketFactory)ReflectionUtils.newInstance(theClass, conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Socket Factory class not found: " + cnfe);
        }
    }

    public static InetSocketAddress createSocketAddr(String target) {
        return NetUtils.createSocketAddr(target, -1);
    }

    public static InetSocketAddress createSocketAddr(String target, int defaultPort) {
        String hostname;
        if (target == null) {
            throw new IllegalArgumentException("Target address cannot be null.");
        }
        int colonIndex = target.indexOf(58);
        if (colonIndex < 0 && defaultPort == -1) {
            throw new RuntimeException("Not a host:port pair: " + target);
        }
        int port = -1;
        if (!target.contains("/")) {
            if (colonIndex == -1) {
                hostname = target;
            } else {
                hostname = target.substring(0, colonIndex);
                port = Integer.parseInt(target.substring(colonIndex + 1));
            }
        } else {
            URI addr = new Path(target).toUri();
            hostname = addr.getHost();
            port = addr.getPort();
        }
        if (port == -1) {
            port = defaultPort;
        }
        if (NetUtils.getStaticResolution(hostname) != null) {
            hostname = NetUtils.getStaticResolution(hostname);
        }
        return new InetSocketAddress(hostname, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStaticResolution(String host, String resolvedName) {
        Map<String, String> map = hostToResolved;
        synchronized (map) {
            hostToResolved.put(host, resolvedName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStaticResolution(String host) {
        Map<String, String> map = hostToResolved;
        synchronized (map) {
            return hostToResolved.get(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> getAllStaticResolutions() {
        Map<String, String> map = hostToResolved;
        synchronized (map) {
            Set<Map.Entry<String, String>> entries = hostToResolved.entrySet();
            if (entries.size() == 0) {
                return null;
            }
            ArrayList<String[]> l = new ArrayList<String[]>(entries.size());
            for (Map.Entry<String, String> e : entries) {
                l.add(new String[]{e.getKey(), e.getValue()});
            }
            return l;
        }
    }

    public static InetSocketAddress getConnectAddress(Server server) {
        InetSocketAddress addr = server.getListenerAddress();
        if (addr.getAddress().getHostAddress().equals("0.0.0.0")) {
            addr = new InetSocketAddress("127.0.0.1", addr.getPort());
        }
        return addr;
    }

    public static InputStream getInputStream(Socket socket) throws IOException {
        return NetUtils.getInputStream(socket, socket.getSoTimeout());
    }

    public static InputStream getInputStream(Socket socket, long timeout) throws IOException {
        return socket.getChannel() == null ? socket.getInputStream() : new SocketInputStream(socket, timeout);
    }

    public static OutputStream getOutputStream(Socket socket) throws IOException {
        return NetUtils.getOutputStream(socket, 0L);
    }

    public static OutputStream getOutputStream(Socket socket, long timeout) throws IOException {
        return socket.getChannel() == null ? socket.getOutputStream() : new SocketOutputStream(socket, timeout);
    }

    public static void connect(Socket socket, SocketAddress endpoint, int timeout) throws IOException {
        if (socket == null || endpoint == null || timeout < 0) {
            throw new IllegalArgumentException("Illegal argument for connect()");
        }
        SocketChannel ch = socket.getChannel();
        if (ch == null) {
            socket.connect(endpoint, timeout);
        } else {
            SocketIOWithTimeout.connect(ch, endpoint, timeout);
        }
        if (socket.getLocalPort() == socket.getPort() && socket.getLocalAddress().equals(socket.getInetAddress())) {
            LOG.info((Object)"Detected a loopback TCP socket, disconnecting it");
            socket.close();
            throw new ConnectException("Localhost targeted connection resulted in a loopback. No daemon is listening on the target port.");
        }
    }

    public static String normalizeHostName(String name) {
        if (Character.digit(name.charAt(0), 10) != -1) {
            return name;
        }
        try {
            InetAddress ipAddress = InetAddress.getByName(name);
            return ipAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            return name;
        }
    }

    public static List<String> normalizeHostNames(Collection<String> names) {
        ArrayList<String> hostNames = new ArrayList<String>(names.size());
        for (String name : names) {
            hostNames.add(NetUtils.normalizeHostName(name));
        }
        return hostNames;
    }

    public static String getHostNameOfIP(String ip) {
        if (!ipPattern.matcher(ip).matches()) {
            return null;
        }
        String hostname = "";
        try {
            String n = ip.substring(0, ip.indexOf(58));
            hostname = InetAddress.getByName(n).getHostName();
        }
        catch (UnknownHostException e) {
            return null;
        }
        return hostname;
    }

    public static String getHostname() {
        try {
            return "" + InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            return "" + uhe;
        }
    }

    public static InetAddress getLocalInetAddress(String host) throws SocketException {
        if (host == null) {
            return null;
        }
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(host);
            if (NetworkInterface.getByInetAddress(addr) == null) {
                addr = null;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return addr;
    }
}

