/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class ChRootedFs
extends AbstractFileSystem {
    private final AbstractFileSystem myFs;
    private final URI myUri;
    private final Path chRootPathPart;
    private final String chRootPathPartString;

    protected AbstractFileSystem getMyFs() {
        return this.myFs;
    }

    protected Path fullPath(Path path) {
        super.checkPath(path);
        return new Path((this.chRootPathPart.isRoot() ? "" : this.chRootPathPartString) + path.toUri().getPath());
    }

    public ChRootedFs(AbstractFileSystem fs, Path theRoot) throws URISyntaxException {
        super(fs.getUri(), fs.getUri().getScheme(), fs.getUri().getAuthority() != null, fs.getUriDefaultPort());
        this.myFs = fs;
        this.myFs.checkPath(theRoot);
        this.chRootPathPart = new Path(this.myFs.getUriPath(theRoot));
        this.chRootPathPartString = this.chRootPathPart.toUri().getPath();
        this.myUri = new URI(this.myFs.getUri().toString() + (this.myFs.getUri().getAuthority() == null ? "" : "/") + this.chRootPathPart.toString().substring(1));
        super.checkPath(theRoot);
    }

    @Override
    public URI getUri() {
        return this.myUri;
    }

    public String stripOutRoot(Path p) {
        try {
            this.checkPath(p);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Internal Error - path " + p + " should have been with URI" + this.myUri);
        }
        String pathPart = p.toUri().getPath();
        return pathPart.length() == this.chRootPathPartString.length() ? "" : pathPart.substring(this.chRootPathPartString.length() + (this.chRootPathPart.isRoot() ? 0 : 1));
    }

    @Override
    public Path getHomeDirectory() {
        return this.myFs.getHomeDirectory();
    }

    @Override
    public Path getInitialWorkingDirectory() {
        return null;
    }

    public Path getResolvedQualifiedPath(Path f) throws FileNotFoundException {
        return this.myFs.makeQualified(new Path(this.chRootPathPartString + f.toUri().toString()));
    }

    @Override
    public FSDataOutputStream createInternal(Path f, EnumSet<CreateFlag> flag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, int bytesPerChecksum, boolean createParent) throws IOException, UnresolvedLinkException {
        return this.myFs.createInternal(this.fullPath(f), flag, absolutePermission, bufferSize, replication, blockSize, progress, bytesPerChecksum, createParent);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException, UnresolvedLinkException {
        return this.myFs.delete(this.fullPath(f), recursive);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws IOException, UnresolvedLinkException {
        return this.myFs.getFileBlockLocations(this.fullPath(f), start, len);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws IOException, UnresolvedLinkException {
        return this.myFs.getFileChecksum(this.fullPath(f));
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException, UnresolvedLinkException {
        return this.myFs.getFileStatus(this.fullPath(f));
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws IOException, UnresolvedLinkException {
        return this.myFs.getFileLinkStatus(this.fullPath(f));
    }

    @Override
    public FsStatus getFsStatus() throws IOException {
        return this.myFs.getFsStatus();
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.myFs.getServerDefaults();
    }

    @Override
    public int getUriDefaultPort() {
        return this.myFs.getUriDefaultPort();
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException, UnresolvedLinkException {
        return this.myFs.listStatus(this.fullPath(f));
    }

    @Override
    public void mkdir(Path dir, FsPermission permission, boolean createParent) throws IOException, UnresolvedLinkException {
        this.myFs.mkdir(this.fullPath(dir), permission, createParent);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException, UnresolvedLinkException {
        return this.myFs.open(this.fullPath(f), bufferSize);
    }

    @Override
    public void renameInternal(Path src, Path dst) throws IOException, UnresolvedLinkException {
        this.myFs.renameInternal(this.fullPath(src), this.fullPath(dst));
    }

    @Override
    public void renameInternal(Path src, Path dst, boolean overwrite) throws IOException, UnresolvedLinkException {
        this.myFs.renameInternal(this.fullPath(src), this.fullPath(dst), overwrite);
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws IOException, UnresolvedLinkException {
        this.myFs.setOwner(this.fullPath(f), username, groupname);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws IOException, UnresolvedLinkException {
        this.myFs.setPermission(this.fullPath(f), permission);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws IOException, UnresolvedLinkException {
        return this.myFs.setReplication(this.fullPath(f), replication);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws IOException, UnresolvedLinkException {
        this.myFs.setTimes(this.fullPath(f), mtime, atime);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) throws IOException, UnresolvedLinkException {
        this.myFs.setVerifyChecksum(verifyChecksum);
    }

    @Override
    public boolean supportsSymlinks() {
        return this.myFs.supportsSymlinks();
    }

    @Override
    public void createSymlink(Path target, Path link, boolean createParent) throws IOException, UnresolvedLinkException {
        this.myFs.createSymlink(this.fullPath(target), link, createParent);
    }

    @Override
    public Path getLinkTarget(Path f) throws IOException {
        return this.myFs.getLinkTarget(this.fullPath(f));
    }

    @Override
    public List<Token<?>> getDelegationTokens(String renewer) throws IOException {
        return this.myFs.getDelegationTokens(renewer);
    }
}

