/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.IpcException;
import org.apache.hadoop.ipc.RpcClientException;
import org.apache.hadoop.ipc.RpcServerException;
import org.apache.hadoop.ipc.Server;
import org.junit.Assert;
import org.junit.Test;

public class TestServer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBind() throws Exception {
        Configuration conf = new Configuration();
        ServerSocket socket = new ServerSocket();
        InetSocketAddress address = new InetSocketAddress("0.0.0.0", 0);
        socket.bind(address);
        try {
            int min = socket.getLocalPort();
            int max = min + 100;
            conf.set("TestRange", min + "-" + max);
            ServerSocket socket2 = new ServerSocket();
            InetSocketAddress address2 = new InetSocketAddress("0.0.0.0", 0);
            Server.bind((ServerSocket)socket2, (InetSocketAddress)address2, (int)10, (Configuration)conf, (String)"TestRange");
            try {
                Assert.assertTrue((boolean)socket2.isBound());
                Assert.assertTrue((socket2.getLocalPort() > min ? 1 : 0) != 0);
                Assert.assertTrue((socket2.getLocalPort() <= max ? 1 : 0) != 0);
            }
            finally {
                socket2.close();
            }
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindSimple() throws Exception {
        ServerSocket socket = new ServerSocket();
        InetSocketAddress address = new InetSocketAddress("0.0.0.0", 0);
        Server.bind((ServerSocket)socket, (InetSocketAddress)address, (int)10);
        try {
            Assert.assertTrue((boolean)socket.isBound());
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyConfig() throws Exception {
        Configuration conf = new Configuration();
        conf.set("TestRange", "");
        ServerSocket socket = new ServerSocket();
        InetSocketAddress address = new InetSocketAddress("0.0.0.0", 0);
        try {
            Server.bind((ServerSocket)socket, (InetSocketAddress)address, (int)10, (Configuration)conf, (String)"TestRange");
            Assert.assertTrue((boolean)socket.isBound());
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindError() throws Exception {
        Configuration conf = new Configuration();
        ServerSocket socket = new ServerSocket();
        InetSocketAddress address = new InetSocketAddress("0.0.0.0", 0);
        socket.bind(address);
        try {
            int min = socket.getLocalPort();
            conf.set("TestRange", min + "-" + min);
            ServerSocket socket2 = new ServerSocket();
            InetSocketAddress address2 = new InetSocketAddress("0.0.0.0", 0);
            boolean caught = false;
            try {
                Server.bind((ServerSocket)socket2, (InetSocketAddress)address2, (int)10, (Configuration)conf, (String)"TestRange");
            }
            catch (BindException e) {
                caught = true;
            }
            finally {
                socket2.close();
            }
            Assert.assertTrue((String)"Failed to catch the expected bind exception", (boolean)caught);
        }
        finally {
            socket.close();
        }
    }

    @Test
    public void testExceptionsHandler() {
        Server.ExceptionsHandler handler = new Server.ExceptionsHandler();
        handler.addTerseExceptions(new Class[]{IOException.class});
        handler.addTerseExceptions(new Class[]{RpcServerException.class, IpcException.class});
        Assert.assertTrue((boolean)handler.isTerse(IOException.class));
        Assert.assertTrue((boolean)handler.isTerse(RpcServerException.class));
        Assert.assertTrue((boolean)handler.isTerse(IpcException.class));
        Assert.assertFalse((boolean)handler.isTerse(RpcClientException.class));
    }
}

