/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.SymlinkBaseTest;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Shell;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class TestSymlinkLocalFS
extends SymlinkBaseTest {
    @Override
    protected String getScheme() {
        return "file";
    }

    @Override
    protected String testBaseDir1() throws IOException {
        return wrapper.getAbsoluteTestRootDir() + "/test1";
    }

    @Override
    protected String testBaseDir2() throws IOException {
        return wrapper.getAbsoluteTestRootDir() + "/test2";
    }

    @Override
    protected URI testURI() {
        try {
            return new URI("file:///");
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public void testCreateDanglingLink() throws IOException {
        Assume.assumeTrue((!Path.WINDOWS ? 1 : 0) != 0);
        super.testCreateDanglingLink();
    }

    @Override
    public void testCreateFileViaDanglingLinkParent() throws IOException {
        Assume.assumeTrue((!Path.WINDOWS ? 1 : 0) != 0);
        super.testCreateFileViaDanglingLinkParent();
    }

    @Override
    public void testOpenResolvesLinks() throws IOException {
        Assume.assumeTrue((!Path.WINDOWS ? 1 : 0) != 0);
        super.testOpenResolvesLinks();
    }

    @Override
    public void testRecursiveLinks() throws IOException {
        Assume.assumeTrue((!Path.WINDOWS ? 1 : 0) != 0);
        super.testRecursiveLinks();
    }

    @Override
    public void testRenameDirToDanglingSymlink() throws IOException {
        Assume.assumeTrue((!Path.WINDOWS ? 1 : 0) != 0);
        super.testRenameDirToDanglingSymlink();
    }

    @Override
    public void testStatDanglingLink() throws IOException {
        Assume.assumeTrue((!Path.WINDOWS ? 1 : 0) != 0);
        super.testStatDanglingLink();
    }

    @Test(timeout=10000L)
    public void testDanglingLinkFilePartQual() throws IOException {
        Path filePartQual = new Path(this.getScheme() + ":///doesNotExist");
        try {
            wrapper.getFileLinkStatus(filePartQual);
            Assert.fail((String)"Got FileStatus for non-existant file");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            wrapper.getLinkTarget(filePartQual);
            Assert.fail((String)"Got link target for non-existant file");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test(timeout=10000L)
    public void testDanglingLink() throws IOException {
        Assume.assumeTrue((!Path.WINDOWS ? 1 : 0) != 0);
        Path fileAbs = new Path(this.testBaseDir1() + "/file");
        Path fileQual = new Path(this.testURI().toString(), fileAbs);
        Path link = new Path(this.testBaseDir1() + "/linkToFile");
        Path linkQual = new Path(this.testURI().toString(), link.toString());
        wrapper.createSymlink(fileAbs, link, false);
        FileUtil.fullyDelete((File)new File(link.toUri().getPath()));
        wrapper.createSymlink(fileAbs, link, false);
        try {
            wrapper.getFileStatus(link);
            Assert.fail((String)"Got FileStatus for dangling link");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        FileStatus fsd = wrapper.getFileLinkStatus(link);
        Assert.assertEquals((Object)fileQual, (Object)fsd.getSymlink());
        Assert.assertTrue((boolean)fsd.isSymlink());
        Assert.assertFalse((boolean)fsd.isDirectory());
        Assert.assertEquals((Object)user.getUserName(), (Object)fsd.getOwner());
        Assert.assertEquals((Object)user.getGroupNames()[0], (Object)fsd.getGroup());
        Assert.assertEquals((Object)linkQual, (Object)fsd.getPath());
        try {
            TestSymlinkLocalFS.readFile(link);
            Assert.fail((String)"Got FileStatus for dangling link");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        TestSymlinkLocalFS.createAndWriteFile(fileAbs);
        wrapper.getFileStatus(link);
    }

    @Test(timeout=10000L)
    public void testGetLinkStatusPartQualTarget() throws IOException {
        Path fileAbs = new Path(this.testBaseDir1() + "/file");
        Path fileQual = new Path(this.testURI().toString(), fileAbs);
        Path dir = new Path(this.testBaseDir1());
        Path link = new Path(this.testBaseDir1() + "/linkToFile");
        Path dirNew = new Path(this.testBaseDir2());
        Path linkNew = new Path(this.testBaseDir2() + "/linkToFile");
        wrapper.delete(dirNew, true);
        TestSymlinkLocalFS.createAndWriteFile(fileQual);
        wrapper.setWorkingDirectory(dir);
        wrapper.createSymlink(fileQual, link, false);
        Assert.assertEquals((Object)fileQual, (Object)wrapper.getFileLinkStatus(link).getSymlink());
        wrapper.rename(dir, dirNew, new Options.Rename[0]);
        Assert.assertEquals((Object)fileQual, (Object)wrapper.getFileLinkStatus(linkNew).getSymlink());
        try {
            TestSymlinkLocalFS.readFile(linkNew);
            Assert.fail((String)"The link should be dangling now.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Path anotherFs = new Path("hdfs://host:1000/dir/file");
        FileUtil.fullyDelete((File)new File(linkNew.toString()));
        try {
            wrapper.createSymlink(anotherFs, linkNew, false);
            Assert.fail((String)"Created a local fs link to a non-local fs");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void testCreateLinkToDot() throws IOException {
        try {
            super.testCreateLinkToDot();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void testSetTimesSymlinkToFile() throws IOException {
        Assume.assumeTrue((!Shell.WINDOWS && !Shell.SOLARIS ? 1 : 0) != 0);
        super.testSetTimesSymlinkToFile();
    }

    @Override
    public void testSetTimesSymlinkToDir() throws IOException {
        Assume.assumeTrue((!Path.WINDOWS && !Shell.SOLARIS ? 1 : 0) != 0);
        super.testSetTimesSymlinkToDir();
    }

    @Override
    public void testSetTimesDanglingLink() throws IOException {
        Assume.assumeTrue((!Path.WINDOWS ? 1 : 0) != 0);
        super.testSetTimesDanglingLink();
    }

    static {
        RawLocalFileSystem.useStatIfAvailable();
    }
}

