/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.io.IOUtils;
import org.junit.Test;

public abstract class AbstractContractOpenTest
extends AbstractFSContractTestBase {
    private FSDataInputStream instream;

    @Override
    protected Configuration createConfiguration() {
        Configuration conf = super.createConfiguration();
        conf.setInt("io.file.buffer.size", 4096);
        return conf;
    }

    @Override
    public void teardown() throws Exception {
        IOUtils.closeStream((Closeable)this.instream);
        this.instream = null;
        super.teardown();
    }

    @Test
    public void testOpenReadZeroByteFile() throws Throwable {
        this.describe("create & read a 0 byte file");
        Path path = this.path("zero.txt");
        ContractTestUtils.touch(this.getFileSystem(), path);
        this.instream = this.getFileSystem().open(path);
        AbstractContractOpenTest.assertEquals((long)0L, (long)this.instream.getPos());
        int result = this.instream.read();
        this.assertMinusOne("initial byte read", result);
    }

    @Test
    public void testFsIsEncrypted() throws Exception {
        this.describe("create an empty file and call FileStatus.isEncrypted()");
        Path path = this.path("file");
        ContractTestUtils.createFile(this.getFileSystem(), path, false, new byte[0]);
        FileStatus stat = this.getFileSystem().getFileStatus(path);
        AbstractContractOpenTest.assertFalse((String)"Expecting false for stat.isEncrypted()", (boolean)stat.isEncrypted());
    }

    @Test
    public void testOpenReadDir() throws Throwable {
        this.describe("create & read a directory");
        Path path = this.path("zero.dir");
        this.mkdirs(path);
        try {
            this.instream = this.getFileSystem().open(path);
            AbstractContractOpenTest.fail((String)"A directory has been opened for reading");
        }
        catch (FileNotFoundException e) {
            this.handleExpectedException(e);
        }
        catch (IOException e) {
            this.handleRelaxedException("opening a directory for reading", "FileNotFoundException", e);
        }
    }

    @Test
    public void testOpenReadDirWithChild() throws Throwable {
        this.describe("create & read a directory which has a child");
        Path path = this.path("zero.dir");
        this.mkdirs(path);
        Path path2 = new Path(path, "child");
        this.mkdirs(path2);
        try {
            this.instream = this.getFileSystem().open(path);
            AbstractContractOpenTest.fail((String)"A directory has been opened for reading");
        }
        catch (FileNotFoundException e) {
            this.handleExpectedException(e);
        }
        catch (IOException e) {
            this.handleRelaxedException("opening a directory for reading", "FileNotFoundException", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenFileTwice() throws Throwable {
        this.describe("verify that two opened file streams are independent");
        Path path = this.path("testopenfiletwice.txt");
        byte[] block = ContractTestUtils.dataset(1024, 0, 255);
        ContractTestUtils.createFile(this.getFileSystem(), path, false, block);
        FSDataInputStream instream1 = this.getFileSystem().open(path);
        FSDataInputStream instream2 = null;
        try {
            int c = instream1.read();
            AbstractContractOpenTest.assertEquals((long)0L, (long)c);
            instream2 = this.getFileSystem().open(path);
            AbstractContractOpenTest.assertEquals((String)"first read of instream 2", (long)0L, (long)instream2.read());
            AbstractContractOpenTest.assertEquals((String)"second read of instream 1", (long)1L, (long)instream1.read());
            instream1.close();
            AbstractContractOpenTest.assertEquals((String)"second read of instream 2", (long)1L, (long)instream2.read());
            instream1.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeStream((Closeable)instream1);
            IOUtils.closeStream(instream2);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)instream1);
        IOUtils.closeStream((Closeable)instream2);
    }

    @Test
    public void testSequentialRead() throws Throwable {
        this.describe("verify that sequential read() operations return values");
        Path path = this.path("testsequentialread.txt");
        int len = 4;
        int base = 64;
        byte[] block = ContractTestUtils.dataset(len, base, base + len);
        ContractTestUtils.createFile(this.getFileSystem(), path, false, block);
        this.instream = this.getFileSystem().open(path);
        AbstractContractOpenTest.assertEquals((long)base, (long)this.instream.read());
        AbstractContractOpenTest.assertEquals((long)(base + 1), (long)this.instream.read());
        AbstractContractOpenTest.assertEquals((long)(base + 2), (long)this.instream.read());
        AbstractContractOpenTest.assertEquals((long)(base + 3), (long)this.instream.read());
        AbstractContractOpenTest.assertEquals((long)-1L, (long)this.instream.read());
        AbstractContractOpenTest.assertEquals((long)-1L, (long)this.instream.read());
        this.instream.close();
    }
}

