/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.TestLdapGroupsMappingBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestLdapGroupsMappingWithPosixGroup
extends TestLdapGroupsMappingBase {
    @Before
    public void setupMocks() throws NamingException {
        SearchResult mockUserResult = (SearchResult)Mockito.mock(SearchResult.class);
        Mockito.when(this.mockUserNamingEnum.nextElement()).thenReturn((Object)mockUserResult);
        Attribute mockUidNumberAttr = (Attribute)Mockito.mock(Attribute.class);
        Attribute mockGidNumberAttr = (Attribute)Mockito.mock(Attribute.class);
        Attribute mockUidAttr = (Attribute)Mockito.mock(Attribute.class);
        Attributes mockAttrs = (Attributes)Mockito.mock(Attributes.class);
        Mockito.when((Object)mockUidAttr.get()).thenReturn((Object)"some_user");
        Mockito.when((Object)mockUidNumberAttr.get()).thenReturn((Object)"700");
        Mockito.when((Object)mockGidNumberAttr.get()).thenReturn((Object)"600");
        Mockito.when((Object)mockAttrs.get((String)Mockito.eq((Object)"uid"))).thenReturn((Object)mockUidAttr);
        Mockito.when((Object)mockAttrs.get((String)Mockito.eq((Object)"uidNumber"))).thenReturn((Object)mockUidNumberAttr);
        Mockito.when((Object)mockAttrs.get((String)Mockito.eq((Object)"gidNumber"))).thenReturn((Object)mockGidNumberAttr);
        Mockito.when((Object)mockUserResult.getAttributes()).thenReturn((Object)mockAttrs);
    }

    @Test
    public void testGetGroups() throws IOException, NamingException {
        Mockito.when(this.mockContext.search(Matchers.anyString(), Mockito.contains((String)"posix"), (Object[])Mockito.any(Object[].class), (SearchControls)Mockito.any(SearchControls.class))).thenReturn((Object)this.mockUserNamingEnum, (Object[])new NamingEnumeration[]{this.mockGroupNamingEnum});
        this.doTestGetGroups(Arrays.asList(this.testGroups), 2);
    }

    private void doTestGetGroups(List<String> expectedGroups, int searchTimes) throws IOException, NamingException {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping.ldap.url", "ldap://test");
        conf.set("hadoop.security.group.mapping.ldap.search.filter.group", "(objectClass=posixGroup)(cn={0})");
        conf.set("hadoop.security.group.mapping.ldap.search.filter.user", "(objectClass=posixAccount)");
        conf.set("hadoop.security.group.mapping.ldap.search.attr.member", "memberUid");
        conf.set("hadoop.security.group.mapping.ldap.posix.attr.uid.name", "uidNumber");
        conf.set("hadoop.security.group.mapping.ldap.posix.attr.gid.name", "gidNumber");
        conf.set("hadoop.security.group.mapping.ldap.search.attr.group.name", "cn");
        this.mappingSpy.setConf(conf);
        List groups = this.mappingSpy.getGroups("some_user");
        Assert.assertEquals(expectedGroups, (Object)groups);
        this.mappingSpy.getConf().set("hadoop.security.group.mapping.ldap.posix.attr.uid.name", "uid");
        Assert.assertEquals(expectedGroups, (Object)groups);
        ((DirContext)Mockito.verify((Object)this.mockContext, (VerificationMode)Mockito.times((int)searchTimes))).search(Matchers.anyString(), Matchers.anyString(), (Object[])Mockito.any(Object[].class), (SearchControls)Mockito.any(SearchControls.class));
    }
}

