/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.source;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.metrics2.source.JvmMetricsInfo;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.util.GcTimeMonitor;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;

public class TestJvmMetrics {
    @Rule
    public Timeout timeout = new Timeout(30000);
    private JvmPauseMonitor pauseMonitor;
    private GcTimeMonitor gcTimeMonitor;

    @After
    public void teardown() {
        ServiceOperations.stop((Service)this.pauseMonitor);
        if (this.gcTimeMonitor != null) {
            this.gcTimeMonitor.shutdown();
        }
    }

    @Test
    public void testJvmPauseMonitorPresence() {
        this.pauseMonitor = new JvmPauseMonitor();
        this.pauseMonitor.init(new Configuration());
        this.pauseMonitor.start();
        JvmMetrics jvmMetrics = new JvmMetrics("test", "test");
        jvmMetrics.setPauseMonitor(this.pauseMonitor);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)jvmMetrics);
        MetricsCollector mc = rb.parent();
        ((MetricsCollector)Mockito.verify((Object)mc)).addRecord((MetricsInfo)JvmMetricsInfo.JvmMetrics);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).tag((MetricsInfo)MsInfo.ProcessName, "test");
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).tag((MetricsInfo)MsInfo.SessionId, "test");
        for (JvmMetricsInfo info : JvmMetricsInfo.values()) {
            if (info.name().startsWith("Mem")) {
                ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge((MetricsInfo)Mockito.eq((Object)info), Mockito.anyFloat());
                continue;
            }
            if (info.name().startsWith("Gc") && !info.name().equals("GcTimePercentage")) {
                ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter((MetricsInfo)Mockito.eq((Object)info), Mockito.anyLong());
                continue;
            }
            if (info.name().startsWith("Threads")) {
                ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge((MetricsInfo)Mockito.eq((Object)info), Mockito.anyInt());
                continue;
            }
            if (!info.name().startsWith("Log")) continue;
            ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addCounter((MetricsInfo)Mockito.eq((Object)info), Mockito.anyLong());
        }
    }

    @Test
    public void testGcTimeMonitorPresence() {
        this.gcTimeMonitor = new GcTimeMonitor(60000L, 1000L, 70, null);
        this.gcTimeMonitor.start();
        JvmMetrics jvmMetrics = new JvmMetrics("test", "test");
        jvmMetrics.setGcTimeMonitor(this.gcTimeMonitor);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)jvmMetrics);
        MetricsCollector mc = rb.parent();
        ((MetricsCollector)Mockito.verify((Object)mc)).addRecord((MetricsInfo)JvmMetricsInfo.JvmMetrics);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).tag((MetricsInfo)MsInfo.ProcessName, "test");
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).tag((MetricsInfo)MsInfo.SessionId, "test");
        for (JvmMetricsInfo info : JvmMetricsInfo.values()) {
            if (!info.name().equals("GcTimePercentage")) continue;
            ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge((MetricsInfo)Mockito.eq((Object)info), Mockito.anyInt());
        }
    }

    @Test
    public void testDoubleStop() throws Throwable {
        this.pauseMonitor = new JvmPauseMonitor();
        this.pauseMonitor.init(new Configuration());
        this.pauseMonitor.start();
        this.pauseMonitor.stop();
        this.pauseMonitor.stop();
    }

    @Test
    public void testDoubleStart() throws Throwable {
        this.pauseMonitor = new JvmPauseMonitor();
        this.pauseMonitor.init(new Configuration());
        this.pauseMonitor.start();
        this.pauseMonitor.start();
        this.pauseMonitor.stop();
    }

    @Test
    public void testStopBeforeStart() throws Throwable {
        this.pauseMonitor = new JvmPauseMonitor();
        try {
            this.pauseMonitor.init(new Configuration());
            this.pauseMonitor.stop();
            this.pauseMonitor.start();
            Assert.fail((String)("Expected an exception, got " + this.pauseMonitor));
        }
        catch (ServiceStateException e) {
            GenericTestUtils.assertExceptionContains("cannot enter state", e);
        }
    }

    @Test
    public void testStopBeforeInit() throws Throwable {
        this.pauseMonitor = new JvmPauseMonitor();
        try {
            this.pauseMonitor.stop();
            this.pauseMonitor.init(new Configuration());
            Assert.fail((String)("Expected an exception, got " + this.pauseMonitor));
        }
        catch (ServiceStateException e) {
            GenericTestUtils.assertExceptionContains("cannot enter state", e);
        }
    }

    @Test
    public void testGcTimeMonitor() {
        class Alerter
        implements GcTimeMonitor.GcTimeAlertHandler {
            private volatile int numAlerts;
            private volatile int maxGcTimePercentage;

            Alerter() {
            }

            public void alert(GcTimeMonitor.GcData gcData) {
                ++this.numAlerts;
                if (gcData.getGcTimePercentage() > this.maxGcTimePercentage) {
                    this.maxGcTimePercentage = gcData.getGcTimePercentage();
                }
            }
        }
        Alerter alerter = new Alerter();
        int alertGcPerc = 10;
        this.gcTimeMonitor = new GcTimeMonitor(60000L, 100L, alertGcPerc, (GcTimeMonitor.GcTimeAlertHandler)alerter);
        this.gcTimeMonitor.start();
        int maxGcTimePercentage = 0;
        long gcCount = 0L;
        ArrayList<String> garbageStrings = new ArrayList<String>();
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 1000L) {
            for (int j = 0; j < 100000; ++j) {
                garbageStrings.add("Long string prefix just to fill memory with garbage " + j);
            }
            garbageStrings.clear();
            System.gc();
            GcTimeMonitor.GcData gcData = this.gcTimeMonitor.getLatestGcData();
            int gcTimePercentage = gcData.getGcTimePercentage();
            if (gcTimePercentage > maxGcTimePercentage) {
                maxGcTimePercentage = gcTimePercentage;
            }
            gcCount = gcData.getAccumulatedGcCount();
        }
        Assert.assertTrue((maxGcTimePercentage > 0 ? 1 : 0) != 0);
        Assert.assertTrue((gcCount > 0L ? 1 : 0) != 0);
        Assert.assertTrue((alerter.numAlerts > 0 ? 1 : 0) != 0);
        Assert.assertTrue((alerter.maxGcTimePercentage >= alertGcPerc ? 1 : 0) != 0);
    }

    @Test
    public void testJvmMetricsSingletonWithSameProcessName() {
        JvmMetrics jvmMetrics1 = JvmMetrics.initSingleton((String)"test", null);
        JvmMetrics jvmMetrics2 = JvmMetrics.initSingleton((String)"test", null);
        Assert.assertEquals((String)"initSingleton should return the singleton instance", (Object)jvmMetrics1, (Object)jvmMetrics2);
    }

    @Test
    public void testJvmMetricsSingletonWithDifferentProcessNames() {
        String process1Name = "process1";
        JvmMetrics jvmMetrics1 = JvmMetrics.initSingleton((String)"process1", null);
        String process2Name = "process2";
        JvmMetrics jvmMetrics2 = JvmMetrics.initSingleton((String)"process2", null);
        Assert.assertEquals((String)"initSingleton should return the singleton instance", (Object)jvmMetrics1, (Object)jvmMetrics2);
        Assert.assertEquals((String)"unexpected process name of the singleton instance", (Object)"process1", (Object)jvmMetrics1.processName);
        Assert.assertEquals((String)"unexpected process name of the singleton instance", (Object)"process1", (Object)jvmMetrics2.processName);
    }
}

