/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathExistsException;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.MoveCommands;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestMove {
    static Configuration conf;
    static FileSystem mockFs;

    @BeforeClass
    public static void setup() throws IOException, URISyntaxException {
        mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        conf = new Configuration();
        conf.setClass("fs.mockfs.impl", MockFileSystem.class, FileSystem.class);
    }

    @Before
    public void resetMock() throws IOException {
        Mockito.reset((Object[])new FileSystem[]{mockFs});
    }

    @Test
    public void testMoveTargetExistsWithoutExplicitRename() throws Exception {
        Path srcPath = new Path("mockfs:/file");
        Path targetPath = new Path("mockfs:/fold0");
        Path dupPath = new Path("mockfs:/fold0/file");
        Path srcPath2 = new Path("mockfs://user/file");
        Path targetPath2 = new Path("mockfs://user/fold0");
        Path dupPath2 = new Path("mockfs://user/fold0/file");
        String[] cmdargs = new String[]{"mockfs:/file", "mockfs:/fold0"};
        FileStatus src_fileStat = (FileStatus)Mockito.mock(FileStatus.class);
        FileStatus target_fileStat = (FileStatus)Mockito.mock(FileStatus.class);
        FileStatus dup_fileStat = (FileStatus)Mockito.mock(FileStatus.class);
        URI myuri = new URI("mockfs://user");
        Mockito.when((Object)src_fileStat.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)target_fileStat.isDirectory()).thenReturn((Object)true);
        Mockito.when((Object)dup_fileStat.isDirectory()).thenReturn((Object)false);
        Mockito.when((Object)src_fileStat.getPath()).thenReturn((Object)srcPath2);
        Mockito.when((Object)target_fileStat.getPath()).thenReturn((Object)targetPath2);
        Mockito.when((Object)dup_fileStat.getPath()).thenReturn((Object)dupPath2);
        Mockito.when((Object)mockFs.getFileStatus((Path)Matchers.eq((Object)srcPath))).thenReturn((Object)src_fileStat);
        Mockito.when((Object)mockFs.getFileStatus((Path)Matchers.eq((Object)targetPath))).thenReturn((Object)target_fileStat);
        Mockito.when((Object)mockFs.getFileStatus((Path)Matchers.eq((Object)dupPath))).thenReturn((Object)dup_fileStat);
        Mockito.when((Object)mockFs.getFileStatus((Path)Matchers.eq((Object)srcPath2))).thenReturn((Object)src_fileStat);
        Mockito.when((Object)mockFs.getFileStatus((Path)Matchers.eq((Object)targetPath2))).thenReturn((Object)target_fileStat);
        Mockito.when((Object)mockFs.getFileStatus((Path)Matchers.eq((Object)dupPath2))).thenReturn((Object)dup_fileStat);
        Mockito.when((Object)mockFs.getUri()).thenReturn((Object)myuri);
        InstrumentedRenameCommand cmd = new InstrumentedRenameCommand();
        cmd.setConf(conf);
        cmd.setOverwrite(true);
        cmd.run(cmdargs);
        Assert.assertTrue((String)"Rename should have failed with path exists exception", (boolean)(cmd.error instanceof PathExistsException));
    }

    @Test(expected=CommandFormat.UnknownOptionException.class)
    public void testMoveFromLocalDoesNotAllowTOption() {
        new MoveCommands.MoveFromLocal().run(new String[]{"-t", "2", null, null});
    }

    private static class InstrumentedRenameCommand
    extends MoveCommands.Rename {
        public static String NAME = "InstrumentedRename";
        private Exception error = null;

        private InstrumentedRenameCommand() {
        }

        public void displayError(Exception e) {
            this.error = e;
        }
    }

    static class MockFileSystem
    extends FilterFileSystem {
        Configuration conf;

        MockFileSystem() {
            super(mockFs);
        }

        public void initialize(URI uri, Configuration conf) {
            this.conf = conf;
        }

        public Path makeQualified(Path path) {
            return path;
        }

        public Configuration getConf() {
            return this.conf;
        }
    }
}

