/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostsFileReader {
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private String includesFile;
    private String excludesFile;
    private static final Log LOG = LogFactory.getLog(HostsFileReader.class);

    public HostsFileReader(String inFile, String exFile) throws IOException {
        this.includesFile = inFile;
        this.excludesFile = exFile;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFileToSet(String filename, Set<String> set) throws IOException {
        File file = new File(filename);
        if (!file.exists()) {
            return;
        }
        FileInputStream fis = new FileInputStream(file);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(fis));
            while ((line = reader.readLine()) != null) {
                String[] nodes = line.split("[ \t\n\f\r]+");
                if (nodes == null) continue;
                for (int i = 0; i < nodes.length && !nodes[i].trim().startsWith("#"); ++i) {
                    if (nodes[i].equals("")) continue;
                    LOG.info((Object)("Adding " + nodes[i] + " to the list of hosts from " + filename));
                    set.add(nodes[i]);
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            fis.close();
        }
    }

    public synchronized void refresh() throws IOException {
        LOG.info((Object)"Refreshing hosts (include/exclude) list");
        if (!this.includesFile.equals("")) {
            HashSet<String> newIncludes = new HashSet<String>();
            this.readFileToSet(this.includesFile, newIncludes);
            this.includes = newIncludes;
        }
        if (!this.excludesFile.equals("")) {
            HashSet<String> newExcludes = new HashSet<String>();
            this.readFileToSet(this.excludesFile, newExcludes);
            this.excludes = newExcludes;
        }
    }

    public synchronized Set<String> getHosts() {
        return this.includes;
    }

    public synchronized Set<String> getExcludedHosts() {
        return this.excludes;
    }

    public synchronized void setIncludesFile(String includesFile) {
        LOG.info((Object)("Setting the includes file to " + includesFile));
        this.includesFile = includesFile;
    }

    public synchronized void setExcludesFile(String excludesFile) {
        LOG.info((Object)("Setting the excludes file to " + excludesFile));
        this.excludesFile = excludesFile;
    }

    public synchronized void updateFileNames(String includesFile, String excludesFile) throws IOException {
        this.setIncludesFile(includesFile);
        this.setExcludesFile(excludesFile);
    }
}

