/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class NativeCodeLoader {
    private static final Log LOG = LogFactory.getLog(NativeCodeLoader.class);
    private static boolean nativeCodeLoaded = false;

    public static boolean isNativeCodeLoaded() {
        return nativeCodeLoaded;
    }

    public boolean getLoadNativeLibraries(Configuration conf) {
        return conf.getBoolean("io.native.lib.available", true);
    }

    public void setLoadNativeLibraries(Configuration conf, boolean loadNativeLibraries) {
        conf.setBoolean("io.native.lib.available", loadNativeLibraries);
    }

    static {
        LOG.debug((Object)"Trying to load the custom-built native-hadoop library...");
        try {
            System.loadLibrary("hadoop");
            LOG.info((Object)"Loaded the native-hadoop library");
            nativeCodeLoaded = true;
        }
        catch (Throwable t) {
            LOG.debug((Object)("Failed to load native-hadoop with error: " + t));
            LOG.debug((Object)("java.library.path=" + System.getProperty("java.library.path")));
        }
        if (!nativeCodeLoaded) {
            LOG.warn((Object)"Unable to load native-hadoop library for your platform... using builtin-java classes where applicable");
        }
    }
}

