/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.oauth2;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.oauth2.AccessTokenProvider;
import org.apache.hadoop.hdfs.web.oauth2.AccessTokenTimer;
import org.apache.hadoop.hdfs.web.oauth2.OAuth2Constants;
import org.apache.hadoop.hdfs.web.oauth2.Utils;
import org.apache.hadoop.util.Timer;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ConfRefreshTokenBasedAccessTokenProvider
extends AccessTokenProvider {
    private static final ObjectReader READER = new ObjectMapper().reader(Map.class);
    public static final String OAUTH_REFRESH_TOKEN_KEY = "dfs.webhdfs.oauth2.refresh.token";
    public static final String OAUTH_REFRESH_TOKEN_EXPIRES_KEY = "dfs.webhdfs.oauth2.refresh.token.expires.ms.since.epoch";
    private AccessTokenTimer accessTokenTimer;
    private String accessToken;
    private String refreshToken;
    private String clientId;
    private String refreshURL;

    public ConfRefreshTokenBasedAccessTokenProvider() {
        this.accessTokenTimer = new AccessTokenTimer();
    }

    public ConfRefreshTokenBasedAccessTokenProvider(Timer timer) {
        this.accessTokenTimer = new AccessTokenTimer(timer);
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.refreshToken = Utils.notNull(conf, OAUTH_REFRESH_TOKEN_KEY);
        this.accessTokenTimer.setExpiresInMSSinceEpoch(Utils.notNull(conf, OAUTH_REFRESH_TOKEN_EXPIRES_KEY));
        this.clientId = Utils.notNull(conf, "dfs.webhdfs.oauth2.client.id");
        this.refreshURL = Utils.notNull(conf, "dfs.webhdfs.oauth2.refresh.url");
    }

    @Override
    public synchronized String getAccessToken() throws IOException {
        if (this.accessTokenTimer.shouldRefresh()) {
            this.refresh();
        }
        return this.accessToken;
    }

    void refresh() throws IOException {
        try {
            OkHttpClient client = new OkHttpClient();
            client.setConnectTimeout(60000L, TimeUnit.MILLISECONDS);
            client.setReadTimeout(60000L, TimeUnit.MILLISECONDS);
            String bodyString = Utils.postBody("grant_type", "refresh_token", "refresh_token", this.refreshToken, "client_id", this.clientId);
            RequestBody body = RequestBody.create((MediaType)OAuth2Constants.URLENCODED, (String)bodyString);
            Request request = new Request.Builder().url(this.refreshURL).post(body).build();
            Response responseBody = client.newCall(request).execute();
            if (responseBody.code() != 200) {
                throw new IllegalArgumentException("Received invalid http response: " + responseBody.code() + ", text = " + responseBody.toString());
            }
            Map response = (Map)READER.readValue(responseBody.body().string());
            String newExpiresIn = response.get("expires_in").toString();
            this.accessTokenTimer.setExpiresIn(newExpiresIn);
            this.accessToken = response.get("access_token").toString();
        }
        catch (Exception e) {
            throw new IOException("Exception while refreshing access token", e);
        }
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }
}

