/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.ByteBufferUtil;
import org.apache.hadoop.fs.CanSetDropBehind;
import org.apache.hadoop.fs.CanSetReadahead;
import org.apache.hadoop.fs.CanUnbuffer;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.HasEnhancedByteBufferAccess;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientFaultInjector;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.client.impl.BlockReaderFactory;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.datatransfer.InvalidEncryptionKeyException;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.ReplicaNotFoundException;
import org.apache.hadoop.hdfs.shortcircuit.ClientMmap;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.IdentityHashStore;
import org.apache.hadoop.util.StopWatch;
import org.apache.htrace.core.SpanId;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

@InterfaceAudience.Private
public class DFSInputStream
extends FSInputStream
implements ByteBufferReadable,
CanSetDropBehind,
CanSetReadahead,
HasEnhancedByteBufferAccess,
CanUnbuffer {
    @VisibleForTesting
    public static boolean tcpReadsDisabledForTesting = false;
    private long hedgedReadOpsLoopNumForTesting = 0L;
    protected final DFSClient dfsClient;
    protected AtomicBoolean closed = new AtomicBoolean(false);
    protected final String src;
    protected final boolean verifyChecksum;
    private DatanodeInfo currentNode = null;
    protected LocatedBlock currentLocatedBlock = null;
    protected long pos = 0L;
    protected long blockEnd = -1L;
    private BlockReader blockReader = null;
    protected LocatedBlocks locatedBlocks = null;
    private long lastBlockBeingWrittenLength = 0L;
    private FileEncryptionInfo fileEncryptionInfo = null;
    protected CachingStrategy cachingStrategy;
    protected final ReadStatistics readStatistics = new ReadStatistics();
    protected final Object infoLock = new Object();
    private IdentityHashStore<ByteBuffer, Object> extendedReadBuffers;
    protected int failures = 0;
    private final ConcurrentHashMap<DatanodeInfo, DatanodeInfo> deadNodes = new ConcurrentHashMap();
    private byte[] oneByteBuf;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocateDirect(0).asReadOnlyBuffer();

    private synchronized IdentityHashStore<ByteBuffer, Object> getExtendedReadBuffers() {
        if (this.extendedReadBuffers == null) {
            this.extendedReadBuffers = new IdentityHashStore(0);
        }
        return this.extendedReadBuffers;
    }

    void addToDeadNodes(DatanodeInfo dnInfo) {
        this.deadNodes.put(dnInfo, dnInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DFSInputStream(DFSClient dfsClient, String src, boolean verifyChecksum, LocatedBlocks locatedBlocks) throws IOException {
        this.dfsClient = dfsClient;
        this.verifyChecksum = verifyChecksum;
        this.src = src;
        Object object = this.infoLock;
        synchronized (object) {
            this.cachingStrategy = dfsClient.getDefaultReadCachingStrategy();
        }
        this.locatedBlocks = locatedBlocks;
        this.openInfo(false);
    }

    @VisibleForTesting
    public long getlastBlockBeingWrittenLengthForTesting() {
        return this.lastBlockBeingWrittenLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openInfo(boolean refreshLocatedBlocks) throws IOException {
        DfsClientConf conf = this.dfsClient.getConf();
        Object object = this.infoLock;
        synchronized (object) {
            int retriesForLastBlockLength;
            this.lastBlockBeingWrittenLength = this.fetchLocatedBlocksAndGetLastBlockLength(refreshLocatedBlocks);
            for (retriesForLastBlockLength = conf.getRetryTimesForGetLastBlockLength(); retriesForLastBlockLength > 0 && this.lastBlockBeingWrittenLength == -1L; --retriesForLastBlockLength) {
                DFSClient.LOG.warn("Last block locations not available. Datanodes might not have reported blocks completely. Will retry for " + retriesForLastBlockLength + " times");
                this.waitFor(conf.getRetryIntervalForGetLastBlockLength());
                this.lastBlockBeingWrittenLength = this.fetchLocatedBlocksAndGetLastBlockLength(true);
            }
            if (this.lastBlockBeingWrittenLength == -1L && retriesForLastBlockLength == 0) {
                throw new IOException("Could not obtain the last block locations.");
            }
        }
    }

    private void waitFor(int waitTime) throws IOException {
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while getting the last block length.");
        }
    }

    private long fetchLocatedBlocksAndGetLastBlockLength(boolean refresh) throws IOException {
        LocatedBlock last;
        LocatedBlocks newInfo = this.locatedBlocks;
        if (this.locatedBlocks == null || refresh) {
            newInfo = this.dfsClient.getLocatedBlocks(this.src, 0L);
        }
        DFSClient.LOG.debug("newInfo = {}", (Object)newInfo);
        if (newInfo == null) {
            throw new IOException("Cannot open filename " + this.src);
        }
        if (this.locatedBlocks != null) {
            Iterator<LocatedBlock> oldIter = this.locatedBlocks.getLocatedBlocks().iterator();
            Iterator<LocatedBlock> newIter = newInfo.getLocatedBlocks().iterator();
            while (oldIter.hasNext() && newIter.hasNext()) {
                if (oldIter.next().getBlock().equals(newIter.next().getBlock())) continue;
                throw new IOException("Blocklist for " + this.src + " has changed!");
            }
        }
        this.locatedBlocks = newInfo;
        long lastBlockBeingWrittenLength = 0L;
        if (!this.locatedBlocks.isLastBlockComplete() && (last = this.locatedBlocks.getLastLocatedBlock()) != null) {
            if (last.getLocations().length == 0) {
                if (last.getBlockSize() == 0L) {
                    return 0L;
                }
                return -1L;
            }
            long len = this.readBlockLength(last);
            last.getBlock().setNumBytes(len);
            lastBlockBeingWrittenLength = len;
        }
        this.fileEncryptionInfo = this.locatedBlocks.getFileEncryptionInfo();
        return lastBlockBeingWrittenLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private long readBlockLength(LocatedBlock locatedblock) throws IOException {
        if (!DFSInputStream.$assertionsDisabled && locatedblock == null) {
            throw new AssertionError((Object)"LocatedBlock cannot be null");
        }
        replicaNotFoundCount = locatedblock.getLocations().length;
        conf = this.dfsClient.getConf();
        timeout = conf.getSocketTimeout();
        nodeList = new LinkedList<DatanodeInfo>(Arrays.asList(locatedblock.getLocations()));
        retryList = new LinkedList<DatanodeInfo>();
        isRetry = false;
        sw = new StopWatch();
        while (nodeList.size() > 0) {
            block19: {
                block20: {
                    datanode = nodeList.pop();
                    cdp = null;
                    try {
                        cdp = DFSUtilClient.createClientDatanodeProtocolProxy(datanode, this.dfsClient.getConfiguration(), timeout, conf.isConnectToDnViaHostname(), locatedblock);
                        n = cdp.getReplicaVisibleLength(locatedblock.getBlock());
                        if (n < 0L) break block19;
                        var13_14 = n;
                        if (cdp == null) break block20;
                    }
                    catch (IOException ioe) {
                        try {
                            if (ioe instanceof RemoteException) {
                                if (((RemoteException)ioe).unwrapRemoteException() instanceof ReplicaNotFoundException) {
                                    --replicaNotFoundCount;
                                } else if (((RemoteException)ioe).unwrapRemoteException() instanceof RetriableException) {
                                    retryList.add(datanode);
                                }
                            }
                            DFSClient.LOG.debug("Failed to getReplicaVisibleLength from datanode {} for block {}", new Object[]{datanode, locatedblock.getBlock(), ioe});
                            ** if (cdp == null) goto lbl-1000
                        }
                        catch (Throwable var15_15) {
                            if (cdp != null) {
                                RPC.stopProxy(cdp);
                            }
                            throw var15_15;
                        }
lbl-1000:
                        // 1 sources

                        {
                            RPC.stopProxy((Object)cdp);
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                    }
                    RPC.stopProxy((Object)cdp);
                }
                return var13_14;
            }
            if (cdp != null) {
                RPC.stopProxy((Object)cdp);
            }
            if (nodeList.size() == 0 && retryList.size() > 0) {
                nodeList.addAll(retryList);
                retryList.clear();
                isRetry = true;
            }
            if (isRetry) {
                if (!sw.isRunning()) {
                    sw.start();
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new IOException("Interrupted while getting the length.");
                }
            }
            if (!sw.isRunning() || sw.now(TimeUnit.MILLISECONDS) <= (long)timeout) continue;
            break;
        }
        if (replicaNotFoundCount == 0) {
            return 0L;
        }
        throw new IOException("Cannot obtain block length for " + locatedblock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFileLength() {
        Object object = this.infoLock;
        synchronized (object) {
            return this.locatedBlocks == null ? 0L : this.locatedBlocks.getFileLength() + this.lastBlockBeingWrittenLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shortCircuitForbidden() {
        Object object = this.infoLock;
        synchronized (object) {
            return this.locatedBlocks.isUnderConstruction();
        }
    }

    public synchronized DatanodeInfo getCurrentDatanode() {
        return this.currentNode;
    }

    public synchronized ExtendedBlock getCurrentBlock() {
        if (this.currentLocatedBlock == null) {
            return null;
        }
        return this.currentLocatedBlock.getBlock();
    }

    public List<LocatedBlock> getAllBlocks() throws IOException {
        return this.getBlockRange(0L, this.getFileLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LocatedBlock getBlockAt(long offset) throws IOException {
        Object object = this.infoLock;
        synchronized (object) {
            assert (this.locatedBlocks != null) : "locatedBlocks is null";
            if (offset < 0L || offset >= this.getFileLength()) {
                throw new IOException("offset < 0 || offset >= getFileLength(), offset=" + offset + ", locatedBlocks=" + this.locatedBlocks);
            }
            LocatedBlock blk = offset >= this.locatedBlocks.getFileLength() ? this.locatedBlocks.getLastLocatedBlock() : this.fetchBlockAt(offset, 0L, true);
            return blk;
        }
    }

    protected LocatedBlock fetchBlockAt(long offset) throws IOException {
        return this.fetchBlockAt(offset, 0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocatedBlock fetchBlockAt(long offset, long length, boolean useCache) throws IOException {
        Object object = this.infoLock;
        synchronized (object) {
            int targetBlockIdx = this.locatedBlocks.findBlock(offset);
            if (targetBlockIdx < 0) {
                targetBlockIdx = LocatedBlocks.getInsertIndex(targetBlockIdx);
                useCache = false;
            }
            if (!useCache) {
                LocatedBlocks newBlocks;
                LocatedBlocks locatedBlocks = newBlocks = length == 0L ? this.dfsClient.getLocatedBlocks(this.src, offset) : this.dfsClient.getLocatedBlocks(this.src, offset, length);
                if (newBlocks == null || newBlocks.locatedBlockCount() == 0) {
                    throw new EOFException("Could not find target position " + offset);
                }
                this.locatedBlocks.insertRange(targetBlockIdx, newBlocks.getLocatedBlocks());
            }
            return this.locatedBlocks.get(targetBlockIdx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LocatedBlock> getBlockRange(long offset, long length) throws IOException {
        if (offset >= this.getFileLength()) {
            throw new IOException("Offset: " + offset + " exceeds file length: " + this.getFileLength());
        }
        Object object = this.infoLock;
        synchronized (object) {
            long lengthOfCompleteBlk = this.locatedBlocks.getFileLength();
            boolean readOffsetWithinCompleteBlk = offset < lengthOfCompleteBlk;
            boolean readLengthPastCompleteBlk = offset + length > lengthOfCompleteBlk;
            List<LocatedBlock> blocks = readOffsetWithinCompleteBlk ? this.getFinalizedBlockRange(offset, Math.min(length, lengthOfCompleteBlk - offset)) : new ArrayList<LocatedBlock>(1);
            if (readLengthPastCompleteBlk) {
                blocks.add(this.locatedBlocks.getLastLocatedBlock());
            }
            return blocks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LocatedBlock> getFinalizedBlockRange(long offset, long length) throws IOException {
        Object object = this.infoLock;
        synchronized (object) {
            assert (this.locatedBlocks != null) : "locatedBlocks is null";
            ArrayList<LocatedBlock> blockRange = new ArrayList<LocatedBlock>();
            long remaining = length;
            long curOff = offset;
            while (remaining > 0L) {
                LocatedBlock blk = this.fetchBlockAt(curOff, remaining, true);
                assert (curOff >= blk.getStartOffset()) : "Block not found";
                blockRange.add(blk);
                long bytesRead = blk.getStartOffset() + blk.getBlockSize() - curOff;
                remaining -= bytesRead;
                curOff += bytesRead;
            }
            return blockRange;
        }
    }

    private synchronized DatanodeInfo blockSeekTo(long target) throws IOException {
        if (target >= this.getFileLength()) {
            throw new IOException("Attempted to read past end of file");
        }
        this.closeCurrentBlockReaders();
        int refetchToken = 1;
        int refetchEncryptionKey = 1;
        boolean connectFailedOnce = false;
        while (true) {
            LocatedBlock targetBlock = this.getBlockAt(target);
            this.pos = target;
            this.blockEnd = targetBlock.getStartOffset() + targetBlock.getBlockSize() - 1L;
            this.currentLocatedBlock = targetBlock;
            long offsetIntoBlock = target - targetBlock.getStartOffset();
            DNAddrPair retval = this.chooseDataNode(targetBlock, null);
            DatanodeInfo chosenNode = retval.info;
            InetSocketAddress targetAddr = retval.addr;
            StorageType storageType = retval.storageType;
            targetBlock = retval.block;
            try {
                this.blockReader = this.getBlockReader(targetBlock, offsetIntoBlock, targetBlock.getBlockSize() - offsetIntoBlock, targetAddr, storageType, chosenNode);
                if (connectFailedOnce) {
                    DFSClient.LOG.info("Successfully connected to " + targetAddr + " for " + targetBlock.getBlock());
                }
                return chosenNode;
            }
            catch (IOException ex) {
                if (ex instanceof InvalidEncryptionKeyException && refetchEncryptionKey > 0) {
                    DFSClient.LOG.info("Will fetch a new encryption key and retry, encryption key was invalid when connecting to " + targetAddr + " : " + ex);
                    --refetchEncryptionKey;
                    this.dfsClient.clearDataEncryptionKey();
                    continue;
                }
                if (refetchToken > 0 && DFSInputStream.tokenRefetchNeeded(ex, targetAddr)) {
                    --refetchToken;
                    this.fetchBlockAt(target);
                    continue;
                }
                connectFailedOnce = true;
                DFSClient.LOG.warn("Failed to connect to " + targetAddr + " for block" + ", add to deadNodes and continue. " + ex, (Throwable)ex);
                this.addToDeadNodes(chosenNode);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlockReader getBlockReader(LocatedBlock targetBlock, long offsetInBlock, long length, InetSocketAddress targetAddr, StorageType storageType, DatanodeInfo datanode) throws IOException {
        boolean shortCircuitForbidden;
        CachingStrategy curCachingStrategy;
        ExtendedBlock blk = targetBlock.getBlock();
        Token<BlockTokenIdentifier> accessToken = targetBlock.getBlockToken();
        Object object = this.infoLock;
        synchronized (object) {
            curCachingStrategy = this.cachingStrategy;
            shortCircuitForbidden = this.shortCircuitForbidden();
        }
        return new BlockReaderFactory(this.dfsClient.getConf()).setInetSocketAddress(targetAddr).setRemotePeerFactory(this.dfsClient).setDatanodeInfo(datanode).setStorageType(storageType).setFileName(this.src).setBlock(blk).setBlockToken(accessToken).setStartOffset(offsetInBlock).setVerifyChecksum(this.verifyChecksum).setClientName(this.dfsClient.clientName).setLength(length).setCachingStrategy(curCachingStrategy).setAllowShortCircuitLocalReads(!shortCircuitForbidden).setClientCacheContext(this.dfsClient.getClientContext()).setUserGroupInformation(this.dfsClient.ugi).setConfiguration(this.dfsClient.getConfiguration()).setTracer(this.dfsClient.getTracer()).build();
    }

    public synchronized void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            DFSClient.LOG.debug("DFSInputStream has been closed already");
            return;
        }
        this.dfsClient.checkOpen();
        if (this.extendedReadBuffers != null && !this.extendedReadBuffers.isEmpty()) {
            final StringBuilder builder = new StringBuilder();
            this.extendedReadBuffers.visitAll((IdentityHashStore.Visitor)new IdentityHashStore.Visitor<ByteBuffer, Object>(){
                private String prefix = "";

                public void accept(ByteBuffer k, Object v) {
                    builder.append(this.prefix).append(k);
                    this.prefix = ", ";
                }
            });
            DFSClient.LOG.warn("closing file " + this.src + ", but there are still " + "unreleased ByteBuffers allocated by read().  " + "Please release " + builder.toString() + ".");
        }
        this.closeCurrentBlockReaders();
        super.close();
    }

    public synchronized int read() throws IOException {
        int ret;
        if (this.oneByteBuf == null) {
            this.oneByteBuf = new byte[1];
        }
        return (ret = this.read(this.oneByteBuf, 0, 1)) <= 0 ? -1 : this.oneByteBuf[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateReadStatistics(ReadStatistics readStatistics, int nRead, BlockReader blockReader) {
        if (nRead <= 0) {
            return;
        }
        Object object = this.infoLock;
        synchronized (object) {
            if (blockReader.isShortCircuit()) {
                readStatistics.addShortCircuitBytes(nRead);
            } else if (blockReader.isLocal()) {
                readStatistics.addLocalBytes(nRead);
            } else {
                readStatistics.addRemoteBytes(nRead);
            }
        }
    }

    private synchronized int readBuffer(ReaderStrategy reader, int off, int len, Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap) throws IOException {
        boolean retryCurrentNode = true;
        while (true) {
            boolean sourceFound;
            Throwable ioe;
            try {
                return reader.doRead(this.blockReader, off, len);
            }
            catch (ChecksumException ce) {
                DFSClient.LOG.warn("Found Checksum error for " + this.getCurrentBlock() + " from " + this.currentNode + " at " + ce.getPos());
                ioe = ce;
                retryCurrentNode = false;
                this.addIntoCorruptedBlockMap(this.getCurrentBlock(), this.currentNode, corruptedBlockMap);
            }
            catch (IOException e) {
                if (!retryCurrentNode) {
                    DFSClient.LOG.warn("Exception while reading from " + this.getCurrentBlock() + " of " + this.src + " from " + this.currentNode, (Throwable)e);
                }
                ioe = e;
            }
            if (retryCurrentNode) {
                sourceFound = this.seekToBlockSource(this.pos);
            } else {
                this.addToDeadNodes(this.currentNode);
                sourceFound = this.seekToNewSource(this.pos);
            }
            if (!sourceFound) {
                throw ioe;
            }
            retryCurrentNode = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int readWithStrategy(ReaderStrategy strategy, int off, int len) throws IOException {
        this.dfsClient.checkOpen();
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
        HashMap<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap = new HashMap<ExtendedBlock, Set<DatanodeInfo>>();
        this.failures = 0;
        if (this.pos < this.getFileLength()) {
            int retries = 2;
            while (retries > 0) {
                try {
                    if (this.pos > this.blockEnd || this.currentNode == null) {
                        this.currentNode = this.blockSeekTo(this.pos);
                    }
                    int realLen = (int)Math.min((long)len, this.blockEnd - this.pos + 1L);
                    Object object = this.infoLock;
                    synchronized (object) {
                        if (this.locatedBlocks.isLastBlockComplete()) {
                            realLen = (int)Math.min((long)realLen, this.locatedBlocks.getFileLength() - this.pos);
                        }
                    }
                    int result = this.readBuffer(strategy, off, realLen, corruptedBlockMap);
                    if (result >= 0) {
                        this.pos += (long)result;
                    } else {
                        throw new IOException("Unexpected EOS from the reader");
                    }
                    if (this.dfsClient.stats != null) {
                        this.dfsClient.stats.incrementBytesRead((long)result);
                    }
                    int n = result;
                    return n;
                }
                catch (ChecksumException ce) {
                    throw ce;
                }
                catch (IOException e) {
                    if (retries == 1) {
                        DFSClient.LOG.warn("DFS Read", (Throwable)e);
                    }
                    this.blockEnd = -1L;
                    if (this.currentNode != null) {
                        this.addToDeadNodes(this.currentNode);
                    }
                    if (--retries != 0) continue;
                    throw e;
                }
                finally {
                    this.reportCheckSumFailure(corruptedBlockMap, this.currentLocatedBlock.getLocations().length);
                }
            }
        }
        return -1;
    }

    public synchronized int read(@Nonnull byte[] buf, int off, int len) throws IOException {
        this.validatePositionedReadArgs(this.pos, buf, off, len);
        if (len == 0) {
            return 0;
        }
        ByteArrayStrategy byteArrayReader = new ByteArrayStrategy(buf);
        try (TraceScope ignored = this.dfsClient.newPathTraceScope("DFSInputStream#byteArrayRead", this.src);){
            int n = this.readWithStrategy(byteArrayReader, off, len);
            return n;
        }
    }

    public synchronized int read(ByteBuffer buf) throws IOException {
        ByteBufferStrategy byteBufferReader = new ByteBufferStrategy(buf);
        try (TraceScope ignored = this.dfsClient.newPathTraceScope("DFSInputStream#byteBufferRead", this.src);){
            int n = this.readWithStrategy(byteBufferReader, 0, buf.remaining());
            return n;
        }
    }

    protected void addIntoCorruptedBlockMap(ExtendedBlock blk, DatanodeInfo node, Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap) {
        Set<Object> dnSet = corruptedBlockMap.containsKey(blk) ? corruptedBlockMap.get(blk) : new HashSet();
        if (!dnSet.contains(node)) {
            dnSet.add(node);
            corruptedBlockMap.put(blk, dnSet);
        }
    }

    private DNAddrPair chooseDataNode(LocatedBlock block, Collection<DatanodeInfo> ignoredNodes) throws IOException {
        return this.chooseDataNode(block, ignoredNodes, true);
    }

    private DNAddrPair chooseDataNode(LocatedBlock block, Collection<DatanodeInfo> ignoredNodes, boolean refetchIfRequired) throws IOException {
        while (true) {
            DNAddrPair result;
            if ((result = this.getBestNodeDNAddrPair(block, ignoredNodes)) != null) {
                return result;
            }
            if (!refetchIfRequired) break;
            block = this.refetchLocations(block, ignoredNodes);
        }
        return null;
    }

    private LocatedBlock refetchLocations(LocatedBlock block, Collection<DatanodeInfo> ignoredNodes) throws IOException {
        String errMsg = DFSInputStream.getBestNodeDNAddrPairErrorString(block.getLocations(), this.deadNodes, ignoredNodes);
        String blockInfo = block.getBlock() + " file=" + this.src;
        if (this.failures >= this.dfsClient.getConf().getMaxBlockAcquireFailures()) {
            String description = "Could not obtain block: " + blockInfo;
            DFSClient.LOG.warn(description + errMsg + ". Throwing a BlockMissingException");
            throw new BlockMissingException(this.src, description, block.getStartOffset());
        }
        DatanodeInfo[] nodes = block.getLocations();
        if (nodes == null || nodes.length == 0) {
            DFSClient.LOG.info("No node available for " + blockInfo);
        }
        DFSClient.LOG.info("Could not obtain " + block.getBlock() + " from any node: " + errMsg + ". Will get new block locations from namenode and retry...");
        try {
            int timeWindow = this.dfsClient.getConf().getTimeWindow();
            double waitTime = (double)(timeWindow * this.failures) + (double)(timeWindow * (this.failures + 1)) * ThreadLocalRandom.current().nextDouble();
            DFSClient.LOG.warn("DFS chooseDataNode: got # " + (this.failures + 1) + " IOException, will wait for " + waitTime + " msec.");
            Thread.sleep((long)waitTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.deadNodes.clear();
        this.openInfo(true);
        block = this.refreshLocatedBlock(block);
        ++this.failures;
        return block;
    }

    protected DNAddrPair getBestNodeDNAddrPair(LocatedBlock block, Collection<DatanodeInfo> ignoredNodes) {
        Object[] nodes = block.getLocations();
        StorageType[] storageTypes = block.getStorageTypes();
        Object chosenNode = null;
        StorageType storageType = null;
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (this.deadNodes.containsKey(nodes[i]) || ignoredNodes != null && ignoredNodes.contains(nodes[i])) continue;
                chosenNode = nodes[i];
                if (storageTypes == null || i >= storageTypes.length) break;
                storageType = storageTypes[i];
                break;
            }
        }
        if (chosenNode == null) {
            DFSClient.LOG.warn("No live nodes contain block " + block.getBlock() + " after checking nodes = " + Arrays.toString(nodes) + ", ignoredNodes = " + ignoredNodes);
            return null;
        }
        String dnAddr = ((DatanodeID)chosenNode).getXferAddr(this.dfsClient.getConf().isConnectToDnViaHostname());
        DFSClient.LOG.debug("Connecting to datanode {}", (Object)dnAddr);
        InetSocketAddress targetAddr = NetUtils.createSocketAddr((String)dnAddr);
        return new DNAddrPair((DatanodeInfo)chosenNode, targetAddr, storageType, block);
    }

    private static String getBestNodeDNAddrPairErrorString(DatanodeInfo[] nodes, AbstractMap<DatanodeInfo, DatanodeInfo> deadNodes, Collection<DatanodeInfo> ignoredNodes) {
        StringBuilder errMsgr = new StringBuilder(" No live nodes contain current block ");
        errMsgr.append("Block locations:");
        for (DatanodeInfo datanode : nodes) {
            errMsgr.append(" ");
            errMsgr.append(datanode.toString());
        }
        errMsgr.append(" Dead nodes: ");
        for (DatanodeInfo datanode : deadNodes.keySet()) {
            errMsgr.append(" ");
            errMsgr.append(datanode.toString());
        }
        if (ignoredNodes != null) {
            errMsgr.append(" Ignored nodes: ");
            for (DatanodeInfo datanode : ignoredNodes) {
                errMsgr.append(" ");
                errMsgr.append(datanode.toString());
            }
        }
        return errMsgr.toString();
    }

    protected void fetchBlockByteRange(LocatedBlock block, long start, long end, byte[] buf, int offset, Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap) throws IOException {
        while (true) {
            DNAddrPair addressPair = this.chooseDataNode(block, null);
            block = addressPair.block;
            try {
                this.actualGetFromOneDataNode(addressPair, start, end, buf, offset, corruptedBlockMap);
                return;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    private Callable<ByteBuffer> getFromOneDataNode(final DNAddrPair datanode, LocatedBlock block, final long start, final long end, final ByteBuffer bb, final Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap, final int hedgedReadId) {
        final SpanId parentSpanId = Tracer.getCurrentSpanId();
        return new Callable<ByteBuffer>(){

            @Override
            public ByteBuffer call() throws Exception {
                DFSClientFaultInjector.get().sleepBeforeHedgedGet();
                byte[] buf = bb.array();
                int offset = bb.position();
                try (TraceScope ignored = DFSInputStream.this.dfsClient.getTracer().newScope("hedgedRead" + hedgedReadId, parentSpanId);){
                    DFSInputStream.this.actualGetFromOneDataNode(datanode, start, end, buf, offset, corruptedBlockMap);
                    ByteBuffer byteBuffer = bb;
                    return byteBuffer;
                }
            }
        };
    }

    private void actualGetFromOneDataNode(DNAddrPair datanode, long start, long end, byte[] buf, int offset, Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap) throws IOException {
        int length = (int)(end - start + 1L);
        this.actualGetFromOneDataNode(datanode, start, end, buf, new int[]{offset}, new int[]{length}, corruptedBlockMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void actualGetFromOneDataNode(DNAddrPair datanode, long startInBlk, long endInBlk, byte[] buf, int[] offsets, int[] lengths, Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap) throws IOException {
        DFSClientFaultInjector.get().startFetchFromDatanode();
        int refetchToken = 1;
        int refetchEncryptionKey = 1;
        int len = (int)(endInBlk - startInBlk + 1L);
        this.checkReadPortions(offsets, lengths, len);
        LocatedBlock block = datanode.block;
        while (true) {
            BlockReader reader = null;
            try {
                DFSClientFaultInjector.get().fetchFromDatanodeException();
                reader = this.getBlockReader(block, startInBlk, len, datanode.addr, datanode.storageType, datanode.info);
                for (int i = 0; i < offsets.length; ++i) {
                    int nread = reader.readAll(buf, offsets[i], lengths[i]);
                    this.updateReadStatistics(this.readStatistics, nread, reader);
                    if (nread == lengths[i]) continue;
                    throw new IOException("truncated return from reader.read(): excpected " + lengths[i] + ", got " + nread);
                }
                DFSClientFaultInjector.get().readFromDatanodeDelay();
                return;
            }
            catch (ChecksumException e) {
                String msg = "fetchBlockByteRange(). Got a checksum exception for " + this.src + " at " + block.getBlock() + ":" + e.getPos() + " from " + datanode.info;
                DFSClient.LOG.warn(msg);
                this.addIntoCorruptedBlockMap(block.getBlock(), datanode.info, corruptedBlockMap);
                this.addToDeadNodes(datanode.info);
                throw new IOException(msg);
            }
            catch (IOException e) {
                if (e instanceof InvalidEncryptionKeyException && refetchEncryptionKey > 0) {
                    DFSClient.LOG.info("Will fetch a new encryption key and retry, encryption key was invalid when connecting to " + datanode.addr + " : " + e);
                    --refetchEncryptionKey;
                    this.dfsClient.clearDataEncryptionKey();
                } else if (refetchToken > 0 && DFSInputStream.tokenRefetchNeeded(e, datanode.addr)) {
                    --refetchToken;
                    try {
                        this.fetchBlockAt(block.getStartOffset());
                    }
                    catch (IOException msg) {}
                } else {
                    String msg = "Failed to connect to " + datanode.addr + " for file " + this.src + " for block " + block.getBlock() + ":" + e;
                    DFSClient.LOG.warn("Connection failure: " + msg, (Throwable)e);
                    this.addToDeadNodes(datanode.info);
                    throw new IOException(msg);
                }
                block = this.refreshLocatedBlock(block);
                continue;
            }
            finally {
                if (reader == null) continue;
                reader.close();
                continue;
            }
            break;
        }
    }

    protected LocatedBlock refreshLocatedBlock(LocatedBlock block) throws IOException {
        return this.getBlockAt(block.getStartOffset());
    }

    private void checkReadPortions(int[] offsets, int[] lengths, int totalLen) {
        Preconditions.checkArgument((offsets.length == lengths.length && offsets.length > 0 ? 1 : 0) != 0);
        int sum = 0;
        for (int i = 0; i < lengths.length; ++i) {
            if (i > 0) {
                int gap = offsets[i] - offsets[i - 1];
                Preconditions.checkArgument((gap >= lengths[i - 1] ? 1 : 0) != 0);
            }
            sum += lengths[i];
        }
        Preconditions.checkArgument((sum == totalLen ? 1 : 0) != 0);
    }

    private void hedgedFetchBlockByteRange(LocatedBlock block, long start, long end, byte[] buf, int offset, Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap) throws IOException {
        DfsClientConf conf = this.dfsClient.getConf();
        ArrayList<Future<ByteBuffer>> futures = new ArrayList<Future<ByteBuffer>>();
        ExecutorCompletionService<ByteBuffer> hedgedService = new ExecutorCompletionService<ByteBuffer>(this.dfsClient.getHedgedReadsThreadPool());
        ArrayList<DatanodeInfo> ignored = new ArrayList<DatanodeInfo>();
        int len = (int)(end - start + 1L);
        int hedgedReadId = 0;
        while (true) {
            ByteBuffer bb;
            ++this.hedgedReadOpsLoopNumForTesting;
            DNAddrPair chosenNode = null;
            if (futures.isEmpty()) {
                chosenNode = this.chooseDataNode(block, ignored);
                block = chosenNode.block;
                bb = ByteBuffer.allocate(len);
                Callable<ByteBuffer> getFromDataNodeCallable = this.getFromOneDataNode(chosenNode, block, start, end, bb, corruptedBlockMap, hedgedReadId++);
                Future<ByteBuffer> firstRequest = hedgedService.submit(getFromDataNodeCallable);
                futures.add(firstRequest);
                try {
                    Future future = hedgedService.poll(conf.getHedgedReadThresholdMillis(), TimeUnit.MILLISECONDS);
                    if (future != null) {
                        ByteBuffer result = (ByteBuffer)future.get();
                        System.arraycopy(result.array(), result.position(), buf, offset, len);
                        return;
                    }
                    DFSClient.LOG.debug("Waited {}ms to read from {}; spawning hedged read", (Object)conf.getHedgedReadThresholdMillis(), (Object)chosenNode.info);
                    ignored.add(chosenNode.info);
                    this.dfsClient.getHedgedReadMetrics().incHedgedReadOps();
                }
                catch (InterruptedException | ExecutionException future) {}
                continue;
            }
            boolean refetch = false;
            try {
                chosenNode = this.chooseDataNode(block, ignored, false);
                if (chosenNode != null) {
                    block = chosenNode.block;
                    bb = ByteBuffer.allocate(len);
                    Callable<ByteBuffer> getFromDataNodeCallable = this.getFromOneDataNode(chosenNode, block, start, end, bb, corruptedBlockMap, hedgedReadId++);
                    Future<ByteBuffer> oneMoreRequest = hedgedService.submit(getFromDataNodeCallable);
                    futures.add(oneMoreRequest);
                } else {
                    refetch = true;
                }
            }
            catch (IOException ioe) {
                DFSClient.LOG.debug("Failed getting node for hedged read: {}", (Object)ioe.getMessage());
            }
            try {
                ByteBuffer result = this.getFirstToComplete(hedgedService, futures);
                this.cancelAll(futures);
                this.dfsClient.getHedgedReadMetrics().incHedgedReadWins();
                System.arraycopy(result.array(), result.position(), buf, offset, len);
                return;
            }
            catch (InterruptedException interruptedException) {
                if (refetch) {
                    this.refetchLocations(block, ignored);
                }
                if (chosenNode == null || chosenNode.info == null) continue;
                ignored.add(chosenNode.info);
                continue;
            }
            break;
        }
    }

    @VisibleForTesting
    public long getHedgedReadOpsLoopNumForTesting() {
        return this.hedgedReadOpsLoopNumForTesting;
    }

    private ByteBuffer getFirstToComplete(CompletionService<ByteBuffer> hedgedService, ArrayList<Future<ByteBuffer>> futures) throws InterruptedException {
        if (futures.isEmpty()) {
            throw new InterruptedException("let's retry");
        }
        Future<ByteBuffer> future = null;
        try {
            future = hedgedService.take();
            ByteBuffer bb = future.get();
            futures.remove(future);
            return bb;
        }
        catch (CancellationException | ExecutionException e) {
            futures.remove(future);
            throw new InterruptedException("let's retry");
        }
    }

    private void cancelAll(List<Future<ByteBuffer>> futures) {
        for (Future<ByteBuffer> future : futures) {
            future.cancel(false);
        }
    }

    protected static boolean tokenRefetchNeeded(IOException ex, InetSocketAddress targetAddr) {
        if (ex instanceof InvalidBlockTokenException || ex instanceof SecretManager.InvalidToken) {
            DFSClient.LOG.debug("Access token was invalid when connecting to {}: {}", (Object)targetAddr, (Object)ex);
            return true;
        }
        return false;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this.validatePositionedReadArgs(position, buffer, offset, length);
        if (length == 0) {
            return 0;
        }
        try (TraceScope ignored = this.dfsClient.newPathTraceScope("DFSInputStream#byteArrayPread", this.src);){
            int n = this.pread(position, buffer, offset, length);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pread(long position, byte[] buffer, int offset, int length) throws IOException {
        this.dfsClient.checkOpen();
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
        this.failures = 0;
        long filelen = this.getFileLength();
        if (position < 0L || position >= filelen) {
            return -1;
        }
        int realLen = length;
        if (position + (long)length > filelen) {
            realLen = (int)(filelen - position);
        }
        List<LocatedBlock> blockRange = this.getBlockRange(position, realLen);
        int remaining = realLen;
        HashMap<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap = new HashMap<ExtendedBlock, Set<DatanodeInfo>>();
        for (LocatedBlock blk : blockRange) {
            long targetStart = position - blk.getStartOffset();
            long bytesToRead = Math.min((long)remaining, blk.getBlockSize() - targetStart);
            try {
                if (this.dfsClient.isHedgedReadsEnabled()) {
                    this.hedgedFetchBlockByteRange(blk, targetStart, targetStart + bytesToRead - 1L, buffer, offset, corruptedBlockMap);
                } else {
                    this.fetchBlockByteRange(blk, targetStart, targetStart + bytesToRead - 1L, buffer, offset, corruptedBlockMap);
                }
            }
            finally {
                this.reportCheckSumFailure(corruptedBlockMap, blk.getLocations().length);
            }
            remaining = (int)((long)remaining - bytesToRead);
            position += bytesToRead;
            offset = (int)((long)offset + bytesToRead);
        }
        assert (remaining == 0) : "Wrong number of bytes read.";
        if (this.dfsClient.stats != null) {
            this.dfsClient.stats.incrementBytesRead((long)realLen);
        }
        return realLen;
    }

    protected void reportCheckSumFailure(Map<ExtendedBlock, Set<DatanodeInfo>> corruptedBlockMap, int dataNodeCount) {
        if (corruptedBlockMap.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<ExtendedBlock, Set<DatanodeInfo>>> it = corruptedBlockMap.entrySet().iterator();
        Map.Entry<ExtendedBlock, Set<DatanodeInfo>> entry = it.next();
        ExtendedBlock blk = entry.getKey();
        Set<DatanodeInfo> dnSet = entry.getValue();
        if (dnSet.size() < dataNodeCount && dnSet.size() > 0 || dataNodeCount == 1 && dnSet.size() == dataNodeCount) {
            DatanodeInfo[] locs = new DatanodeInfo[dnSet.size()];
            int i = 0;
            for (DatanodeInfo dn : dnSet) {
                locs[i++] = dn;
            }
            LocatedBlock[] lblocks = new LocatedBlock[]{new LocatedBlock(blk, locs)};
            this.dfsClient.reportChecksumFailure(this.src, lblocks);
        }
        corruptedBlockMap.clear();
    }

    public long skip(long n) throws IOException {
        if (n > 0L) {
            long fileLen;
            long curPos = this.getPos();
            if (n + curPos > (fileLen = this.getFileLength())) {
                n = fileLen - curPos;
            }
            this.seek(curPos + n);
            return n;
        }
        return n < 0L ? -1L : 0L;
    }

    public synchronized void seek(long targetPos) throws IOException {
        int diff;
        if (targetPos > this.getFileLength()) {
            throw new EOFException("Cannot seek after EOF");
        }
        if (targetPos < 0L) {
            throw new EOFException("Cannot seek to negative offset");
        }
        if (this.closed.get()) {
            throw new IOException("Stream is closed!");
        }
        boolean done = false;
        if (this.pos <= targetPos && targetPos <= this.blockEnd && (diff = (int)(targetPos - this.pos)) <= this.blockReader.available()) {
            try {
                this.pos += this.blockReader.skip(diff);
                if (this.pos != targetPos) {
                    String errMsg = "BlockReader failed to seek to " + targetPos + ". Instead, it seeked to " + this.pos + ".";
                    DFSClient.LOG.warn(errMsg);
                    throw new IOException(errMsg);
                }
                done = true;
            }
            catch (IOException e) {
                DFSClient.LOG.debug("Exception while seek to {} from {} of {} from {}", new Object[]{targetPos, this.getCurrentBlock(), this.src, this.currentNode, e});
            }
        }
        if (!done) {
            this.pos = targetPos;
            this.blockEnd = -1L;
        }
    }

    private boolean seekToBlockSource(long targetPos) throws IOException {
        this.currentNode = this.blockSeekTo(targetPos);
        return true;
    }

    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        if (this.currentNode == null) {
            return this.seekToBlockSource(targetPos);
        }
        boolean markedDead = this.deadNodes.containsKey(this.currentNode);
        this.addToDeadNodes(this.currentNode);
        DatanodeInfo oldNode = this.currentNode;
        DatanodeInfo newNode = this.blockSeekTo(targetPos);
        if (!markedDead) {
            this.deadNodes.remove(oldNode);
        }
        if (!oldNode.getDatanodeUuid().equals(newNode.getDatanodeUuid())) {
            this.currentNode = newNode;
            return true;
        }
        return false;
    }

    public synchronized long getPos() {
        return this.pos;
    }

    public synchronized int available() throws IOException {
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
        long remaining = this.getFileLength() - this.pos;
        return remaining <= Integer.MAX_VALUE ? (int)remaining : Integer.MAX_VALUE;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readLimit) {
    }

    public void reset() throws IOException {
        throw new IOException("Mark/reset not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadStatistics getReadStatistics() {
        Object object = this.infoLock;
        synchronized (object) {
            return new ReadStatistics(this.readStatistics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReadStatistics() {
        Object object = this.infoLock;
        synchronized (object) {
            this.readStatistics.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEncryptionInfo getFileEncryptionInfo() {
        Object object = this.infoLock;
        synchronized (object) {
            return this.fileEncryptionInfo;
        }
    }

    protected void closeCurrentBlockReaders() {
        if (this.blockReader == null) {
            return;
        }
        try {
            this.blockReader.close();
        }
        catch (IOException e) {
            DFSClient.LOG.error("error closing blockReader", (Throwable)e);
        }
        this.blockReader = null;
        this.blockEnd = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setReadahead(Long readahead) throws IOException {
        Object object = this.infoLock;
        synchronized (object) {
            this.cachingStrategy = new CachingStrategy.Builder(this.cachingStrategy).setReadahead(readahead).build();
        }
        this.closeCurrentBlockReaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDropBehind(Boolean dropBehind) throws IOException {
        Object object = this.infoLock;
        synchronized (object) {
            this.cachingStrategy = new CachingStrategy.Builder(this.cachingStrategy).setDropBehind(dropBehind).build();
        }
        this.closeCurrentBlockReaders();
    }

    public synchronized ByteBuffer read(ByteBufferPool bufferPool, int maxLength, EnumSet<ReadOption> opts) throws IOException, UnsupportedOperationException {
        if (maxLength == 0) {
            return EMPTY_BUFFER;
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("can't read a negative number of bytes.");
        }
        if (this.blockReader == null || this.blockEnd == -1L) {
            if (this.pos >= this.getFileLength()) {
                return null;
            }
            if (!this.seekToBlockSource(this.pos) || this.blockReader == null) {
                throw new IOException("failed to allocate new BlockReader at position " + this.pos);
            }
        }
        ByteBuffer buffer = null;
        if (this.dfsClient.getConf().getShortCircuitConf().isShortCircuitMmapEnabled()) {
            buffer = this.tryReadZeroCopy(maxLength, opts);
        }
        if (buffer != null) {
            return buffer;
        }
        buffer = ByteBufferUtil.fallbackRead((InputStream)((Object)this), (ByteBufferPool)bufferPool, (int)maxLength);
        if (buffer != null) {
            this.getExtendedReadBuffers().put((Object)buffer, (Object)bufferPool);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ByteBuffer tryReadZeroCopy(int maxLength, EnumSet<ReadOption> opts) throws IOException {
        ByteBuffer buffer;
        int length;
        long length63;
        long curPos = this.pos;
        long curEnd = this.blockEnd;
        long blockStartInFile = this.currentLocatedBlock.getStartOffset();
        long blockPos = curPos - blockStartInFile;
        if (curPos + (long)maxLength <= curEnd + 1L) {
            length63 = maxLength;
        } else {
            length63 = 1L + curEnd - curPos;
            if (length63 <= 0L) {
                DFSClient.LOG.debug("Unable to perform a zero-copy read from offset {} of {}; {} bytes left in block. blockPos={}; curPos={};curEnd={}", new Object[]{curPos, this.src, length63, blockPos, curPos, curEnd});
                return null;
            }
            DFSClient.LOG.debug("Reducing read length from {} to {} to avoid going more than one byte past the end of the block.  blockPos={};  curPos={}; curEnd={}", new Object[]{maxLength, length63, blockPos, curPos, curEnd});
        }
        if (blockPos + length63 <= Integer.MAX_VALUE) {
            length = (int)length63;
        } else {
            long length31 = Integer.MAX_VALUE - blockPos;
            if (length31 <= 0L) {
                DFSClient.LOG.debug("Unable to perform a zero-copy read from offset {}  of {}; 31-bit MappedByteBuffer limit exceeded.  blockPos={}, curEnd={}", new Object[]{curPos, this.src, blockPos, curEnd});
                return null;
            }
            length = (int)length31;
            DFSClient.LOG.debug("Reducing read length from {} to {} to avoid 31-bit limit.  blockPos={}; curPos={}; curEnd={}", new Object[]{maxLength, length, blockPos, curPos, curEnd});
        }
        ClientMmap clientMmap = this.blockReader.getClientMmap(opts);
        if (clientMmap == null) {
            DFSClient.LOG.debug("unable to perform a zero-copy read from offset {} of {}; BlockReader#getClientMmap returned null.", (Object)curPos, (Object)this.src);
            return null;
        }
        boolean success = false;
        try {
            this.seek(curPos + (long)length);
            buffer = clientMmap.getMappedByteBuffer().asReadOnlyBuffer();
            buffer.position((int)blockPos);
            buffer.limit((int)(blockPos + (long)length));
            this.getExtendedReadBuffers().put((Object)buffer, (Object)clientMmap);
            Object object = this.infoLock;
            synchronized (object) {
                this.readStatistics.addZeroCopyBytes(length);
            }
            DFSClient.LOG.debug("readZeroCopy read {} bytes from offset {} via the zero-copy read path.  blockEnd = {}", new Object[]{length, curPos, this.blockEnd});
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeQuietly((Closeable)clientMmap);
            }
        }
        return buffer;
    }

    public synchronized void releaseBuffer(ByteBuffer buffer) {
        if (buffer == EMPTY_BUFFER) {
            return;
        }
        Object val = this.getExtendedReadBuffers().remove((Object)buffer);
        if (val == null) {
            throw new IllegalArgumentException("tried to release a buffer that was not created by this stream, " + buffer);
        }
        if (val instanceof ClientMmap) {
            IOUtils.closeQuietly((Closeable)((ClientMmap)val));
        } else if (val instanceof ByteBufferPool) {
            ((ByteBufferPool)val).putBuffer(buffer);
        }
    }

    public synchronized void unbuffer() {
        this.closeCurrentBlockReaders();
    }

    static final class DNAddrPair {
        final DatanodeInfo info;
        final InetSocketAddress addr;
        final StorageType storageType;
        final LocatedBlock block;

        DNAddrPair(DatanodeInfo info, InetSocketAddress addr, StorageType storageType, LocatedBlock block) {
            this.info = info;
            this.addr = addr;
            this.storageType = storageType;
            this.block = block;
        }
    }

    protected class ByteBufferStrategy
    implements ReaderStrategy {
        final ByteBuffer buf;

        ByteBufferStrategy(ByteBuffer buf) {
            this.buf = buf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int doRead(BlockReader blockReader, int off, int len) throws IOException {
            int oldpos = this.buf.position();
            int oldlimit = this.buf.limit();
            boolean success = false;
            try {
                int ret = blockReader.read(this.buf);
                success = true;
                DFSInputStream.this.updateReadStatistics(DFSInputStream.this.readStatistics, ret, blockReader);
                if (ret == 0) {
                    DFSClient.LOG.warn("zero");
                }
                int n = ret;
                return n;
            }
            finally {
                if (!success) {
                    this.buf.position(oldpos);
                    this.buf.limit(oldlimit);
                }
            }
        }

        @Override
        public int copyFrom(ByteBuffer src, int offset, int length) {
            ByteBuffer writeSlice = src.duplicate();
            int remaining = Math.min(this.buf.remaining(), writeSlice.remaining());
            writeSlice.limit(writeSlice.position() + remaining);
            this.buf.put(writeSlice);
            return remaining;
        }
    }

    private class ByteArrayStrategy
    implements ReaderStrategy {
        final byte[] buf;

        public ByteArrayStrategy(byte[] buf) {
            this.buf = buf;
        }

        @Override
        public int doRead(BlockReader blockReader, int off, int len) throws IOException {
            int nRead = blockReader.read(this.buf, off, len);
            DFSInputStream.this.updateReadStatistics(DFSInputStream.this.readStatistics, nRead, blockReader);
            return nRead;
        }

        @Override
        public int copyFrom(ByteBuffer src, int offset, int length) {
            ByteBuffer writeSlice = src.duplicate();
            writeSlice.get(this.buf, offset, length);
            return length;
        }
    }

    static interface ReaderStrategy {
        public int doRead(BlockReader var1, int var2, int var3) throws IOException;

        public int copyFrom(ByteBuffer var1, int var2, int var3);
    }

    public static class ReadStatistics {
        private long totalBytesRead;
        private long totalLocalBytesRead;
        private long totalShortCircuitBytesRead;
        private long totalZeroCopyBytesRead;

        public ReadStatistics() {
            this.clear();
        }

        public ReadStatistics(ReadStatistics rhs) {
            this.totalBytesRead = rhs.getTotalBytesRead();
            this.totalLocalBytesRead = rhs.getTotalLocalBytesRead();
            this.totalShortCircuitBytesRead = rhs.getTotalShortCircuitBytesRead();
            this.totalZeroCopyBytesRead = rhs.getTotalZeroCopyBytesRead();
        }

        public long getTotalBytesRead() {
            return this.totalBytesRead;
        }

        public long getTotalLocalBytesRead() {
            return this.totalLocalBytesRead;
        }

        public long getTotalShortCircuitBytesRead() {
            return this.totalShortCircuitBytesRead;
        }

        public long getTotalZeroCopyBytesRead() {
            return this.totalZeroCopyBytesRead;
        }

        public long getRemoteBytesRead() {
            return this.totalBytesRead - this.totalLocalBytesRead;
        }

        void addRemoteBytes(long amt) {
            this.totalBytesRead += amt;
        }

        void addLocalBytes(long amt) {
            this.totalBytesRead += amt;
            this.totalLocalBytesRead += amt;
        }

        void addShortCircuitBytes(long amt) {
            this.totalBytesRead += amt;
            this.totalLocalBytesRead += amt;
            this.totalShortCircuitBytesRead += amt;
        }

        void addZeroCopyBytes(long amt) {
            this.totalBytesRead += amt;
            this.totalLocalBytesRead += amt;
            this.totalShortCircuitBytesRead += amt;
            this.totalZeroCopyBytesRead += amt;
        }

        void clear() {
            this.totalBytesRead = 0L;
            this.totalLocalBytesRead = 0L;
            this.totalShortCircuitBytesRead = 0L;
            this.totalZeroCopyBytesRead = 0L;
        }
    }
}

