/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Random;
import java.util.TimeZone;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.ByteRangeInputStream;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HftpFileSystem
extends FileSystem {
    protected InetSocketAddress nnAddr;
    protected UserGroupInformation ugi;
    protected final Random ran = new Random();
    public static final String HFTP_TIMEZONE = "UTC";
    public static final String HFTP_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    protected static final ThreadLocal<SimpleDateFormat> df;

    public static final SimpleDateFormat getDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat(HFTP_DATE_FORMAT);
        df.setTimeZone(TimeZone.getTimeZone(HFTP_TIMEZONE));
        return df;
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.setConf(conf);
        this.ugi = UserGroupInformation.getCurrentUser();
        this.nnAddr = NetUtils.createSocketAddr((String)name.toString());
    }

    public URI getUri() {
        try {
            return new URI("hftp", null, this.nnAddr.getHostName(), this.nnAddr.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    URL getNamenodeFileURL(Path f) throws IOException {
        return this.getNamenodeURL("/data" + f.toUri().getPath(), "ugi=" + this.ugi.getShortUserName());
    }

    URL getNamenodeURL(String path, String query) throws IOException {
        try {
            URL url = new URI("http", null, this.nnAddr.getHostName(), this.nnAddr.getPort(), path, query, null).toURL();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("url=" + url));
            }
            return url;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    protected HttpURLConnection openConnection(String path, String query) throws IOException {
        URL url = this.getNamenodeURL(path, query);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        return connection;
    }

    public FSDataInputStream open(Path f, int buffersize) throws IOException {
        URL u = this.getNamenodeURL("/data" + f.toUri().getPath(), "ugi=" + this.ugi.getShortUserName());
        return new FSDataInputStream((InputStream)((Object)new ByteRangeInputStream(u)));
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        LsParser lsparser = new LsParser();
        return lsparser.listStatus(f);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        LsParser lsparser = new LsParser();
        return lsparser.getFileStatus(f);
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        String s = this.makeQualified(f).toUri().getPath();
        return new ChecksumParser().getFileChecksum(s);
    }

    public Path getWorkingDirectory() {
        return new Path("/").makeQualified(this.getUri(), null);
    }

    public void setWorkingDirectory(Path f) {
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new IOException("Not supported");
    }

    private static ContentSummary toContentSummary(Attributes attrs) throws SAXException {
        String length = attrs.getValue("length");
        String fileCount = attrs.getValue("fileCount");
        String directoryCount = attrs.getValue("directoryCount");
        String quota = attrs.getValue("quota");
        String spaceConsumed = attrs.getValue("spaceConsumed");
        String spaceQuota = attrs.getValue("spaceQuota");
        if (length == null || fileCount == null || directoryCount == null || quota == null || spaceConsumed == null || spaceQuota == null) {
            return null;
        }
        try {
            return new ContentSummary(Long.parseLong(length), Long.parseLong(fileCount), Long.parseLong(directoryCount), Long.parseLong(quota), Long.parseLong(spaceConsumed), Long.parseLong(spaceQuota));
        }
        catch (Exception e) {
            throw new SAXException("Invalid attributes: length=" + length + ", fileCount=" + fileCount + ", directoryCount=" + directoryCount + ", quota=" + quota + ", spaceConsumed=" + spaceConsumed + ", spaceQuota=" + spaceQuota, e);
        }
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        String s = this.makeQualified(f).toUri().getPath();
        ContentSummary cs = new ContentSummaryParser().getContentSummary(s);
        return cs != null ? cs : super.getContentSummary(f);
    }

    static {
        HttpURLConnection.setFollowRedirects(true);
        df = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return HftpFileSystem.getDateFormat();
            }
        };
    }

    private class ContentSummaryParser
    extends DefaultHandler {
        private ContentSummary contentsummary;

        private ContentSummaryParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            if (!ContentSummary.class.getName().equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException((Exception)((Object)RemoteException.valueOf((Attributes)attrs)));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            this.contentsummary = HftpFileSystem.toContentSummary(attrs);
        }

        private ContentSummary getContentSummary(String path) throws IOException {
            HttpURLConnection connection = HftpFileSystem.this.openConnection("/contentSummary" + path, "ugi=" + HftpFileSystem.this.ugi);
            InputStream in = null;
            try {
                in = connection.getInputStream();
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                xr.parse(new InputSource(in));
            }
            catch (FileNotFoundException fnfe) {
                ContentSummary contentSummary = null;
                return contentSummary;
            }
            catch (SAXException saxe) {
                Exception embedded = saxe.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("Invalid xml format", saxe);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                connection.disconnect();
            }
            return this.contentsummary;
        }
    }

    private class ChecksumParser
    extends DefaultHandler {
        private FileChecksum filechecksum;

        private ChecksumParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            if (!MD5MD5CRC32FileChecksum.class.getName().equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException((Exception)((Object)RemoteException.valueOf((Attributes)attrs)));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            this.filechecksum = MD5MD5CRC32FileChecksum.valueOf((Attributes)attrs);
        }

        private FileChecksum getFileChecksum(String f) throws IOException {
            HttpURLConnection connection = HftpFileSystem.this.openConnection("/fileChecksum" + f, "ugi=" + HftpFileSystem.this.ugi.getShortUserName());
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                xr.parse(new InputSource(connection.getInputStream()));
            }
            catch (SAXException e) {
                Exception embedded = e.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("invalid xml directory content", e);
            }
            finally {
                connection.disconnect();
            }
            return this.filechecksum;
        }
    }

    class LsParser
    extends DefaultHandler {
        ArrayList<FileStatus> fslist = new ArrayList();

        LsParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            long modif;
            if ("listing".equals(qname)) {
                return;
            }
            if (!"file".equals(qname) && !"directory".equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException((Exception)((Object)RemoteException.valueOf((Attributes)attrs)));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            long atime = 0L;
            try {
                SimpleDateFormat ldf = df.get();
                modif = ldf.parse(attrs.getValue("modified")).getTime();
                String astr = attrs.getValue("accesstime");
                if (astr != null) {
                    atime = ldf.parse(astr).getTime();
                }
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
            FileStatus fs = "file".equals(qname) ? new FileStatus(Long.valueOf(attrs.getValue("size")).longValue(), false, (int)Short.valueOf(attrs.getValue("replication")).shortValue(), Long.valueOf(attrs.getValue("blocksize")).longValue(), modif, atime, FsPermission.valueOf((String)attrs.getValue("permission")), attrs.getValue("owner"), attrs.getValue("group"), new Path(HftpFileSystem.this.getUri().toString(), attrs.getValue("path")).makeQualified((FileSystem)HftpFileSystem.this)) : new FileStatus(0L, true, 0, 0L, modif, atime, FsPermission.valueOf((String)attrs.getValue("permission")), attrs.getValue("owner"), attrs.getValue("group"), new Path(HftpFileSystem.this.getUri().toString(), attrs.getValue("path")).makeQualified((FileSystem)HftpFileSystem.this));
            this.fslist.add(fs);
        }

        private void fetchList(String path, boolean recur) throws IOException {
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                HttpURLConnection connection = HftpFileSystem.this.openConnection("/listPaths" + path, "ugi=" + HftpFileSystem.this.ugi.getShortUserName() + (recur ? "&recursive=yes" : ""));
                InputStream resp = connection.getInputStream();
                xr.parse(new InputSource(resp));
            }
            catch (SAXException e) {
                Exception embedded = e.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("invalid xml directory content", e);
            }
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            this.fetchList(f.toUri().getPath(), false);
            if (this.fslist.size() == 0) {
                throw new FileNotFoundException("File does not exist: " + f);
            }
            return this.fslist.get(0);
        }

        public FileStatus[] listStatus(Path f, boolean recur) throws IOException {
            this.fetchList(f.toUri().getPath(), recur);
            if (this.fslist.size() > 0 && (this.fslist.size() != 1 || this.fslist.get(0).isDirectory())) {
                this.fslist.remove(0);
            }
            return this.fslist.toArray(new FileStatus[0]);
        }

        public FileStatus[] listStatus(Path f) throws IOException {
            return this.listStatus(f, false);
        }
    }
}

