/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.namenode.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSClusterStats;
import org.apache.hadoop.hdfs.server.namenode.FSInodeInfo;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public abstract class BlockPlacementPolicy {
    abstract DatanodeDescriptor[] chooseTarget(String var1, int var2, DatanodeDescriptor var3, List<DatanodeDescriptor> var4, long var5);

    abstract DatanodeDescriptor[] chooseTarget(String var1, int var2, DatanodeDescriptor var3, List<DatanodeDescriptor> var4, HashMap<Node, Node> var5, long var6);

    DatanodeDescriptor[] chooseTarget(FSInodeInfo srcInode, int numOfReplicas, DatanodeDescriptor writer, List<DatanodeDescriptor> chosenNodes, long blocksize) {
        return this.chooseTarget(srcInode.getFullPathName(), numOfReplicas, writer, chosenNodes, blocksize);
    }

    public abstract int verifyBlockPlacement(String var1, LocatedBlock var2, int var3);

    public abstract DatanodeDescriptor chooseReplicaToDelete(FSInodeInfo var1, Block var2, short var3, Collection<DatanodeDescriptor> var4, Collection<DatanodeDescriptor> var5);

    protected abstract void initialize(Configuration var1, FSClusterStats var2, NetworkTopology var3);

    public static BlockPlacementPolicy getInstance(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap) {
        Class replicatorClass = conf.getClass("dfs.block.replicator.classname", BlockPlacementPolicyDefault.class, BlockPlacementPolicy.class);
        BlockPlacementPolicy replicator = (BlockPlacementPolicy)ReflectionUtils.newInstance((Class)replicatorClass, (Configuration)conf);
        replicator.initialize(conf, stats, clusterMap);
        return replicator;
    }

    DatanodeDescriptor[] chooseTarget(String srcPath, int numOfReplicas, DatanodeDescriptor writer, long blocksize) {
        return this.chooseTarget(srcPath, numOfReplicas, writer, new ArrayList<DatanodeDescriptor>(), blocksize);
    }

    DatanodeDescriptor[] chooseTarget(String srcPath, int numOfReplicas, DatanodeDescriptor writer, HashMap<Node, Node> excludedNodes, long blocksize) {
        return this.chooseTarget(srcPath, numOfReplicas, writer, new ArrayList<DatanodeDescriptor>(), excludedNodes, blocksize);
    }

    @InterfaceAudience.Private
    public static class NotEnoughReplicasException
    extends Exception {
        private static final long serialVersionUID = 1L;

        NotEnoughReplicasException(String msg) {
            super(msg);
        }
    }
}

