/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public class DatanodeDescriptor
extends DatanodeInfo {
    DecommissioningStatus decommissioningStatus = new DecommissioningStatus();
    private volatile BlockInfo blockList = null;
    protected boolean isAlive = false;
    protected boolean needKeyUpdate = false;
    private BlockQueue<BlockTargetPair> replicateBlocks = new BlockQueue();
    private BlockQueue<BlockInfoUnderConstruction> recoverBlocks = new BlockQueue();
    private Set<Block> invalidateBlocks = new TreeSet<Block>();
    private int currApproxBlocksScheduled = 0;
    private int prevApproxBlocksScheduled = 0;
    private long lastBlocksScheduledRollTime = 0L;
    private static final int BLOCKS_SCHEDULED_ROLL_INTERVAL = 600000;

    public DatanodeDescriptor() {
    }

    public DatanodeDescriptor(DatanodeID nodeID) {
        this(nodeID, 0L, 0L, 0L, 0);
    }

    public DatanodeDescriptor(DatanodeID nodeID, String networkLocation) {
        this(nodeID, networkLocation, null);
    }

    public DatanodeDescriptor(DatanodeID nodeID, String networkLocation, String hostName) {
        this(nodeID, networkLocation, hostName, 0L, 0L, 0L, 0);
    }

    public DatanodeDescriptor(DatanodeID nodeID, long capacity, long dfsUsed, long remaining, int xceiverCount) {
        super(nodeID);
        this.updateHeartbeat(capacity, dfsUsed, remaining, xceiverCount);
    }

    public DatanodeDescriptor(DatanodeID nodeID, String networkLocation, String hostName, long capacity, long dfsUsed, long remaining, int xceiverCount) {
        super(nodeID, networkLocation, hostName);
        this.updateHeartbeat(capacity, dfsUsed, remaining, xceiverCount);
    }

    boolean addBlock(BlockInfo b) {
        if (!b.addNode(this)) {
            return false;
        }
        this.blockList = b.listInsert(this.blockList, this);
        return true;
    }

    boolean removeBlock(BlockInfo b) {
        this.blockList = b.listRemove(this.blockList, this);
        return b.removeNode(this);
    }

    void moveBlockToHead(BlockInfo b) {
        this.blockList = b.listRemove(this.blockList, this);
        this.blockList = b.listInsert(this.blockList, this);
    }

    BlockInfo replaceBlock(BlockInfo oldBlock, BlockInfo newBlock) {
        boolean done = this.removeBlock(oldBlock);
        assert (done) : "Old block should belong to the data-node when replacing";
        done = this.addBlock(newBlock);
        assert (done) : "New block should not belong to the data-node when replacing";
        return newBlock;
    }

    void resetBlocks() {
        this.capacity = 0L;
        this.remaining = 0L;
        this.dfsUsed = 0L;
        this.xceiverCount = 0;
        this.blockList = null;
        this.invalidateBlocks.clear();
    }

    public int numBlocks() {
        return this.blockList == null ? 0 : this.blockList.listCount(this);
    }

    void updateHeartbeat(long capacity, long dfsUsed, long remaining, int xceiverCount) {
        this.capacity = capacity;
        this.dfsUsed = dfsUsed;
        this.remaining = remaining;
        this.lastUpdate = System.currentTimeMillis();
        this.xceiverCount = xceiverCount;
        this.rollBlocksScheduled(this.lastUpdate);
    }

    Iterator<BlockInfo> getBlockIterator() {
        return new BlockIterator(this.blockList, this);
    }

    void addBlockToBeReplicated(Block block, DatanodeDescriptor[] targets) {
        assert (block != null && targets != null && targets.length > 0);
        this.replicateBlocks.offer(new BlockTargetPair(block, targets));
    }

    void addBlockToBeRecovered(BlockInfoUnderConstruction block) {
        if (this.recoverBlocks.contains(block)) {
            FSNamesystem.LOG.info((Object)("Block " + block + " is already in the recovery queue."));
            return;
        }
        this.recoverBlocks.offer(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBlocksToBeInvalidated(List<Block> blocklist) {
        assert (blocklist != null && blocklist.size() > 0);
        Set<Block> set = this.invalidateBlocks;
        synchronized (set) {
            for (Block blk : blocklist) {
                this.invalidateBlocks.add(blk);
            }
        }
    }

    int getNumberOfBlocksToBeReplicated() {
        return this.replicateBlocks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfBlocksToBeInvalidated() {
        Set<Block> set = this.invalidateBlocks;
        synchronized (set) {
            return this.invalidateBlocks.size();
        }
    }

    BlockCommand getReplicationCommand(int maxTransfers) {
        List<BlockTargetPair> blocktargetlist = this.replicateBlocks.poll(maxTransfers);
        return blocktargetlist == null ? null : new BlockCommand(1, blocktargetlist);
    }

    BlockRecoveryCommand getLeaseRecoveryCommand(int maxTransfers) {
        List<BlockInfoUnderConstruction> blocks = this.recoverBlocks.poll(maxTransfers);
        if (blocks == null) {
            return null;
        }
        BlockRecoveryCommand brCommand = new BlockRecoveryCommand(blocks.size());
        for (BlockInfoUnderConstruction b : blocks) {
            brCommand.add(new BlockRecoveryCommand.RecoveringBlock(b, b.getExpectedLocations(), b.getBlockRecoveryId()));
        }
        return brCommand;
    }

    BlockCommand getInvalidateBlocks(int maxblocks) {
        Block[] deleteList = DatanodeDescriptor.getBlockArray(this.invalidateBlocks, maxblocks);
        return deleteList == null ? null : new BlockCommand(2, deleteList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Block[] getBlockArray(Collection<Block> blocks, int max) {
        Block[] blockarray = null;
        Collection<Block> collection = blocks;
        synchronized (collection) {
            int available;
            int n = available = blocks.size();
            if (max > 0 && n > 0) {
                if (max < n) {
                    n = max;
                }
                blockarray = new Block[n];
                Iterator<Block> e = blocks.iterator();
                int blockCount = 0;
                while (blockCount < n && e.hasNext()) {
                    blockarray[blockCount++] = e.next();
                    if (n >= available) continue;
                    e.remove();
                }
                assert (blockarray.length == n);
                if (n == available) {
                    blocks.clear();
                }
            }
        }
        return blockarray;
    }

    void reportDiff(BlockManager blockManager, BlockListAsLongs newReport, Collection<Block> toAdd, Collection<Block> toRemove, Collection<Block> toInvalidate, Collection<BlockInfo> toCorrupt) {
        BlockInfo delimiter = new BlockInfo(new Block(), 1);
        boolean added = this.addBlock(delimiter);
        assert (added) : "Delimiting block cannot be present in the node";
        if (newReport == null) {
            newReport = new BlockListAsLongs();
        }
        BlockListAsLongs.BlockReportIterator itBR = newReport.getBlockReportIterator();
        while (itBR.hasNext()) {
            HdfsConstants.ReplicaState iState;
            Block iblk = itBR.next();
            BlockInfo storedBlock = this.processReportedBlock(blockManager, iblk, iState = itBR.getCurrentReplicaState(), toAdd, toInvalidate, toCorrupt);
            if (storedBlock == null || storedBlock.findDatanode(this) < 0) continue;
            this.moveBlockToHead(storedBlock);
        }
        BlockIterator it = new BlockIterator(delimiter.getNext(0), this);
        while (it.hasNext()) {
            toRemove.add((Block)it.next());
        }
        this.removeBlock(delimiter);
    }

    BlockInfo processReportedBlock(BlockManager blockManager, Block block, HdfsConstants.ReplicaState rState, Collection<Block> toAdd, Collection<Block> toInvalidate, Collection<BlockInfo> toCorrupt) {
        FSNamesystem.LOG.debug((Object)("Reported block " + block + " on " + this.getName() + " size " + block.getNumBytes() + " replicaState = " + (Object)((Object)rState)));
        BlockInfo storedBlock = blockManager.blocksMap.getStoredBlock(block);
        if (storedBlock == null) {
            toInvalidate.add(new Block(block));
            return null;
        }
        FSNamesystem.LOG.debug((Object)("In memory blockUCState = " + (Object)((Object)storedBlock.getBlockUCState())));
        boolean isCorrupt = false;
        switch (rState) {
            case FINALIZED: {
                switch (storedBlock.getBlockUCState()) {
                    case COMPLETE: 
                    case COMMITTED: {
                        if (storedBlock.getGenerationStamp() == block.getGenerationStamp() && storedBlock.getNumBytes() == block.getNumBytes()) break;
                        isCorrupt = true;
                        break;
                    }
                    case UNDER_CONSTRUCTION: 
                    case UNDER_RECOVERY: {
                        ((BlockInfoUnderConstruction)storedBlock).addReplicaIfNotPresent(this, block, rState);
                    }
                }
                if (isCorrupt || storedBlock.findDatanode(this) >= 0) break;
                if (storedBlock.getNumBytes() != block.getNumBytes()) {
                    toAdd.add(new Block(block));
                    break;
                }
                toAdd.add(storedBlock);
                break;
            }
            case RBW: 
            case RWR: {
                if (!storedBlock.isComplete()) {
                    ((BlockInfoUnderConstruction)storedBlock).addReplicaIfNotPresent(this, block, rState);
                    break;
                }
                isCorrupt = true;
                break;
            }
            default: {
                FSNamesystem.LOG.warn((Object)("Unexpected replica state " + (Object)((Object)rState) + " for block: " + storedBlock + " on " + this.getName() + " size " + storedBlock.getNumBytes()));
            }
        }
        if (isCorrupt) {
            toCorrupt.add(storedBlock);
        }
        return storedBlock;
    }

    void readFieldsFromFSEditLog(DataInput in) throws IOException {
        this.name = DeprecatedUTF8.readString(in);
        this.storageID = DeprecatedUTF8.readString(in);
        this.infoPort = in.readShort() & 0xFFFF;
        this.capacity = in.readLong();
        this.dfsUsed = in.readLong();
        this.remaining = in.readLong();
        this.lastUpdate = in.readLong();
        this.xceiverCount = in.readInt();
        this.location = Text.readString((DataInput)in);
        this.hostName = Text.readString((DataInput)in);
        this.setAdminState((DatanodeInfo.AdminStates)WritableUtils.readEnum((DataInput)in, DatanodeInfo.AdminStates.class));
    }

    public int getBlocksScheduled() {
        return this.currApproxBlocksScheduled + this.prevApproxBlocksScheduled;
    }

    void incBlocksScheduled() {
        ++this.currApproxBlocksScheduled;
    }

    void decBlocksScheduled() {
        if (this.prevApproxBlocksScheduled > 0) {
            --this.prevApproxBlocksScheduled;
        } else if (this.currApproxBlocksScheduled > 0) {
            --this.currApproxBlocksScheduled;
        }
    }

    private void rollBlocksScheduled(long now) {
        if (now - this.lastBlocksScheduledRollTime > 600000L) {
            this.prevApproxBlocksScheduled = this.currApproxBlocksScheduled;
            this.currApproxBlocksScheduled = 0;
            this.lastBlocksScheduledRollTime = now;
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    class DecommissioningStatus {
        int underReplicatedBlocks;
        int decommissionOnlyReplicas;
        int underReplicatedInOpenFiles;
        long startTime;

        DecommissioningStatus() {
        }

        synchronized void set(int underRep, int onlyRep, int underConstruction) {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return;
            }
            this.underReplicatedBlocks = underRep;
            this.decommissionOnlyReplicas = onlyRep;
            this.underReplicatedInOpenFiles = underConstruction;
        }

        synchronized int getUnderReplicatedBlocks() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0;
            }
            return this.underReplicatedBlocks;
        }

        synchronized int getDecommissionOnlyReplicas() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0;
            }
            return this.decommissionOnlyReplicas;
        }

        synchronized int getUnderReplicatedInOpenFiles() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0;
            }
            return this.underReplicatedInOpenFiles;
        }

        synchronized void setStartTime(long time) {
            this.startTime = time;
        }

        synchronized long getStartTime() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0L;
            }
            return this.startTime;
        }
    }

    private static class BlockIterator
    implements Iterator<BlockInfo> {
        private BlockInfo current;
        private DatanodeDescriptor node;

        BlockIterator(BlockInfo head, DatanodeDescriptor dn) {
            this.current = head;
            this.node = dn;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public BlockInfo next() {
            BlockInfo res = this.current;
            this.current = this.current.getNext(this.current.findDatanode(this.node));
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry. can't remove.");
        }
    }

    private static class BlockQueue<E> {
        private final Queue<E> blockq = new LinkedList();

        private BlockQueue() {
        }

        synchronized int size() {
            return this.blockq.size();
        }

        synchronized boolean offer(E e) {
            return this.blockq.offer(e);
        }

        synchronized List<E> poll(int numBlocks) {
            if (numBlocks <= 0 || this.blockq.isEmpty()) {
                return null;
            }
            ArrayList<E> results = new ArrayList<E>();
            while (!this.blockq.isEmpty() && numBlocks > 0) {
                results.add(this.blockq.poll());
                --numBlocks;
            }
            return results;
        }

        boolean contains(E e) {
            return this.blockq.contains(e);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class BlockTargetPair {
        public final Block block;
        public final DatanodeDescriptor[] targets;

        BlockTargetPair(Block block, DatanodeDescriptor[] targets) {
            this.block = block;
            this.targets = targets;
        }
    }
}

