/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.GetImageServlet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.metrics.jvm.JvmMetrics;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.StringUtils;

@Deprecated
@InterfaceAudience.Private
public class SecondaryNameNode
implements Runnable {
    public static final Log LOG = LogFactory.getLog((String)SecondaryNameNode.class.getName());
    private final long starttime = System.currentTimeMillis();
    private volatile long lastCheckpointTime = 0L;
    private String fsName;
    private CheckpointStorage checkpointImage;
    private NamenodeProtocol namenode;
    private Configuration conf;
    private InetSocketAddress nameNodeAddr;
    private volatile boolean shouldRun;
    private HttpServer infoServer;
    private int infoPort;
    private String infoBindAddress;
    private Collection<URI> checkpointDirs;
    private Collection<URI> checkpointEditsDirs;
    private long checkpointPeriod;
    private long checkpointSize;

    public String toString() {
        return this.getClass().getSimpleName() + " Status" + "\nName Node Address    : " + this.nameNodeAddr + "\nStart Time           : " + new Date(this.starttime) + "\nLast Checkpoint Time : " + (this.lastCheckpointTime == 0L ? "--" : new Date(this.lastCheckpointTime)) + "\nCheckpoint Period    : " + this.checkpointPeriod + " seconds" + "\nCheckpoint Size      : " + StringUtils.byteDesc((long)this.checkpointSize) + " (= " + this.checkpointSize + " bytes)" + "\nCheckpoint Dirs      : " + this.checkpointDirs + "\nCheckpoint Edits Dirs: " + this.checkpointEditsDirs;
    }

    FSImage getFSImage() {
        return this.checkpointImage;
    }

    public SecondaryNameNode(Configuration conf) throws IOException {
        UserGroupInformation.setConfiguration((Configuration)conf);
        DFSUtil.login(conf, "dfs.namenode.keytab.file", "dfs.namenode.user.name.key");
        try {
            this.initialize(conf);
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
    }

    private void initialize(Configuration conf) throws IOException {
        JvmMetrics.init((String)"SecondaryNameNode", (String)conf.get("dfs.metrics.session-id"));
        this.shouldRun = true;
        this.nameNodeAddr = NameNode.getAddress(conf);
        this.conf = conf;
        this.namenode = (NamenodeProtocol)RPC.waitForProxy(NamenodeProtocol.class, (long)4L, (InetSocketAddress)this.nameNodeAddr, (Configuration)conf);
        this.fsName = this.getInfoServer();
        this.checkpointDirs = FSImage.getCheckpointDirs(conf, "/tmp/hadoop/dfs/namesecondary");
        this.checkpointEditsDirs = FSImage.getCheckpointEditsDirs(conf, "/tmp/hadoop/dfs/namesecondary");
        this.checkpointImage = new CheckpointStorage();
        this.checkpointImage.recoverCreate(this.checkpointDirs, this.checkpointEditsDirs);
        this.checkpointPeriod = conf.getLong("dfs.namenode.checkpoint.period", 3600L);
        this.checkpointSize = conf.getLong("dfs.namenode.checkpoint.size", 0x400000L);
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr((String)conf.get("dfs.namenode.secondary.http-address", "0.0.0.0:50090"));
        this.infoBindAddress = infoSocAddr.getHostName();
        int tmpInfoPort = infoSocAddr.getPort();
        this.infoServer = new HttpServer("secondary", this.infoBindAddress, tmpInfoPort, tmpInfoPort == 0, conf);
        this.infoServer.setAttribute("secondary.name.node", (Object)this);
        this.infoServer.setAttribute("name.system.image", (Object)this.checkpointImage);
        this.infoServer.setAttribute("name.conf", (Object)conf);
        this.infoServer.addInternalServlet("getimage", "/getimage", GetImageServlet.class);
        this.infoServer.start();
        this.infoPort = this.infoServer.getPort();
        conf.set("dfs.namenode.secondary.http-address", this.infoBindAddress + ":" + this.infoPort);
        LOG.info((Object)("Secondary Web-server up at: " + this.infoBindAddress + ":" + this.infoPort));
        LOG.warn((Object)("Checkpoint Period   :" + this.checkpointPeriod + " secs " + "(" + this.checkpointPeriod / 60L + " min)"));
        LOG.warn((Object)("Log Size Trigger    :" + this.checkpointSize + " bytes " + "(" + this.checkpointSize / 1024L + " KB)"));
    }

    public void shutdown() {
        this.shouldRun = false;
        try {
            if (this.infoServer != null) {
                this.infoServer.stop();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception shutting down SecondaryNameNode", (Throwable)e);
        }
        try {
            if (this.checkpointImage != null) {
                this.checkpointImage.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)StringUtils.stringifyException((Throwable)e));
        }
    }

    @Override
    public void run() {
        long period = 300L;
        if (this.checkpointPeriod < period) {
            period = this.checkpointPeriod;
        }
        while (this.shouldRun) {
            try {
                Thread.sleep(1000L * period);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (!this.shouldRun) break;
            try {
                long now = System.currentTimeMillis();
                long size = this.namenode.getEditLogSize();
                if (size < this.checkpointSize && now < this.lastCheckpointTime + 1000L * this.checkpointPeriod) continue;
                this.doCheckpoint();
                this.lastCheckpointTime = now;
            }
            catch (IOException e) {
                LOG.error((Object)"Exception in doCheckpoint: ");
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                e.printStackTrace();
            }
            catch (Throwable e) {
                LOG.error((Object)"Throwable Exception in doCheckpoint: ");
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                e.printStackTrace();
                Runtime.getRuntime().exit(-1);
            }
        }
    }

    private void downloadCheckpointFiles(CheckpointSignature sig) throws IOException {
        this.checkpointImage.cTime = sig.cTime;
        this.checkpointImage.checkpointTime = sig.checkpointTime;
        String fileid = "getimage=1";
        Collection<File> list = this.checkpointImage.getFiles(FSImage.NameNodeFile.IMAGE, FSImage.NameNodeDirType.IMAGE);
        File[] srcNames = list.toArray(new File[list.size()]);
        assert (srcNames.length > 0) : "No checkpoint targets.";
        TransferFsImage.getFileClient(this.fsName, fileid, srcNames);
        LOG.info((Object)("Downloaded file " + srcNames[0].getName() + " size " + srcNames[0].length() + " bytes."));
        fileid = "getedit=1";
        list = this.getFSImage().getFiles(FSImage.NameNodeFile.EDITS, FSImage.NameNodeDirType.EDITS);
        srcNames = list.toArray(new File[list.size()]);
        assert (srcNames.length > 0) : "No checkpoint targets.";
        TransferFsImage.getFileClient(this.fsName, fileid, srcNames);
        LOG.info((Object)("Downloaded file " + srcNames[0].getName() + " size " + srcNames[0].length() + " bytes."));
        this.checkpointImage.checkpointUploadDone();
    }

    private void putFSImage(CheckpointSignature sig) throws IOException {
        String fileid = "putimage=1&port=" + this.infoPort + "&machine=" + InetAddress.getLocalHost().getHostAddress() + "&token=" + sig.toString();
        LOG.info((Object)("Posted URL " + this.fsName + fileid));
        TransferFsImage.getFileClient(this.fsName, fileid, null);
    }

    private String getInfoServer() throws IOException {
        URI fsName = FileSystem.getDefaultUri((Configuration)this.conf);
        if (!"hdfs".equalsIgnoreCase(fsName.getScheme())) {
            throw new IOException("This is not a DFS");
        }
        String configuredAddress = this.conf.get("dfs.namenode.http-address", "0.0.0.0:50070");
        InetSocketAddress sockAddr = NetUtils.createSocketAddr((String)configuredAddress);
        if (sockAddr.getAddress().isAnyLocalAddress()) {
            return fsName.getHost() + ":" + sockAddr.getPort();
        }
        return configuredAddress;
    }

    void doCheckpoint() throws IOException {
        this.startCheckpoint();
        CheckpointSignature sig = this.namenode.rollEditLog();
        if (DFSUtil.ErrorSimulator.getErrorSimulation(0)) {
            throw new IOException("Simulating error0 after creating edits.new");
        }
        this.downloadCheckpointFiles(sig);
        this.doMerge(sig);
        this.putFSImage(sig);
        if (DFSUtil.ErrorSimulator.getErrorSimulation(1)) {
            throw new IOException("Simulating error1 after uploading new image to NameNode");
        }
        this.namenode.rollFsImage();
        this.checkpointImage.endCheckpoint();
        LOG.warn((Object)("Checkpoint done. New Image Size: " + this.checkpointImage.getFsImageName().length()));
    }

    private void startCheckpoint() throws IOException {
        this.checkpointImage.unlockAll();
        this.checkpointImage.getEditLog().close();
        this.checkpointImage.recoverCreate(this.checkpointDirs, this.checkpointEditsDirs);
        this.checkpointImage.startCheckpoint();
    }

    private void doMerge(CheckpointSignature sig) throws IOException {
        FSNamesystem namesystem = new FSNamesystem(this.checkpointImage, this.conf);
        assert (namesystem.dir.fsImage == this.checkpointImage);
        this.checkpointImage.doMerge(sig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processArgs(String[] argv) throws Exception {
        int exitCode;
        block18: {
            String cmd;
            if (argv.length < 1) {
                this.printUsage("");
                return -1;
            }
            exitCode = -1;
            int i = 0;
            if ("-geteditsize".equals(cmd = argv[i++])) {
                if (argv.length != 1) {
                    this.printUsage(cmd);
                    return exitCode;
                }
            } else if ("-checkpoint".equals(cmd)) {
                if (argv.length != 1 && argv.length != 2) {
                    this.printUsage(cmd);
                    return exitCode;
                }
                if (argv.length == 2 && !"force".equals(argv[i])) {
                    this.printUsage(cmd);
                    return exitCode;
                }
            }
            exitCode = 0;
            try {
                if ("-checkpoint".equals(cmd)) {
                    long size = this.namenode.getEditLogSize();
                    if (size >= this.checkpointSize || argv.length == 2 && "force".equals(argv[i])) {
                        this.doCheckpoint();
                    } else {
                        System.err.println("EditLog size " + size + " bytes is " + "smaller than configured checkpoint " + "size " + this.checkpointSize + " bytes.");
                        System.err.println("Skipping checkpoint.");
                    }
                    break block18;
                }
                if ("-geteditsize".equals(cmd)) {
                    long size = this.namenode.getEditLogSize();
                    System.out.println("EditLog size is " + size + " bytes");
                    break block18;
                }
                exitCode = -1;
                LOG.error((Object)(cmd.substring(1) + ": Unknown command"));
                this.printUsage("");
            }
            catch (RemoteException e) {
                exitCode = -1;
                try {
                    String[] content = e.getLocalizedMessage().split("\n");
                    LOG.error((Object)(cmd.substring(1) + ": " + content[0]));
                }
                catch (Exception ex) {
                    LOG.error((Object)(cmd.substring(1) + ": " + ex.getLocalizedMessage()));
                }
            }
            catch (IOException e) {
                exitCode = -1;
                LOG.error((Object)(cmd.substring(1) + ": " + e.getLocalizedMessage()));
            }
        }
        return exitCode;
    }

    private void printUsage(String cmd) {
        if ("-geteditsize".equals(cmd)) {
            System.err.println("Usage: java SecondaryNameNode [-geteditsize]");
        } else if ("-checkpoint".equals(cmd)) {
            System.err.println("Usage: java SecondaryNameNode [-checkpoint [force]]");
        } else {
            System.err.println("Usage: java SecondaryNameNode [-checkpoint [force]] [-geteditsize] ");
        }
    }

    public static void main(String[] argv) throws Exception {
        StringUtils.startupShutdownMessage(SecondaryNameNode.class, (String[])argv, (Log)LOG);
        HdfsConfiguration tconf = new HdfsConfiguration();
        if (argv.length >= 1) {
            SecondaryNameNode secondary = new SecondaryNameNode(tconf);
            int ret = secondary.processArgs(argv);
            System.exit(ret);
        }
        Daemon checkpointThread = new Daemon((Runnable)new SecondaryNameNode(tconf));
        checkpointThread.start();
    }

    static class CheckpointStorage
    extends FSImage {
        CheckpointStorage() throws IOException {
        }

        @Override
        public boolean isConversionNeeded(Storage.StorageDirectory sd) {
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void recoverCreate(Collection<URI> dataDirs, Collection<URI> editsDirs) throws IOException {
            ArrayList<URI> tempDataDirs = new ArrayList<URI>(dataDirs);
            ArrayList<URI> tempEditsDirs = new ArrayList<URI>(editsDirs);
            this.storageDirs = new ArrayList();
            this.setStorageDirectories(tempDataDirs, tempEditsDirs);
            Iterator<Storage.StorageDirectory> it = this.dirIterator();
            block9: while (it.hasNext()) {
                Storage.StorageDirectory sd = it.next();
                boolean isAccessible = true;
                try {
                    if (sd.getRoot().mkdirs()) {
                        // empty if block
                    }
                }
                catch (SecurityException se) {
                    isAccessible = false;
                }
                if (!isAccessible) {
                    throw new InconsistentFSStateException(sd.getRoot(), "cannot access checkpoint directory.");
                }
                try {
                    Storage.StorageState curState = sd.analyzeStorage(HdfsConstants.StartupOption.REGULAR);
                    switch (curState) {
                        case NON_EXISTENT: {
                            throw new InconsistentFSStateException(sd.getRoot(), "checkpoint directory does not exist or is not accessible.");
                        }
                        case NOT_FORMATTED: {
                            continue block9;
                        }
                        case NORMAL: {
                            continue block9;
                        }
                    }
                    sd.doRecover(curState);
                }
                catch (IOException ioe) {
                    sd.unlock();
                    throw ioe;
                }
            }
            return;
        }

        void startCheckpoint() throws IOException {
            for (Storage.StorageDirectory sd : this.storageDirs) {
                this.moveCurrent(sd);
            }
        }

        void endCheckpoint() throws IOException {
            for (Storage.StorageDirectory sd : this.storageDirs) {
                this.moveLastCheckpoint(sd);
            }
        }

        private void doMerge(CheckpointSignature sig) throws IOException {
            this.getEditLog().open();
            Storage.StorageDirectory sdName = null;
            Storage.StorageDirectory sdEdits = null;
            Iterator<Storage.StorageDirectory> it = null;
            it = this.dirIterator(FSImage.NameNodeDirType.IMAGE);
            if (it.hasNext()) {
                sdName = it.next();
            }
            if ((it = this.dirIterator(FSImage.NameNodeDirType.EDITS)).hasNext()) {
                sdEdits = it.next();
            }
            if (sdName == null || sdEdits == null) {
                throw new IOException("Could not locate checkpoint directories");
            }
            this.layoutVersion = -1;
            this.loadFSImage(FSImage.getImageFile(sdName, FSImage.NameNodeFile.IMAGE));
            this.loadFSEdits(sdEdits);
            sig.validateStorageInfo(this);
            this.saveNamespace(false);
        }
    }
}

