/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlocksWithLocations
implements Writable {
    private BlockWithLocations[] blocks;
    public static final String __PARANAMER_DATA = "<init> org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations.BlockWithLocations[] blocks \nreadFields java.io.DataInput in \nwrite java.io.DataOutput out \n";

    BlocksWithLocations() {
    }

    public BlocksWithLocations(BlockWithLocations[] blocks) {
        this.blocks = blocks;
    }

    public BlockWithLocations[] getBlocks() {
        return this.blocks;
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.blocks.length);
        for (int i = 0; i < this.blocks.length; ++i) {
            this.blocks[i].write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int len = WritableUtils.readVInt((DataInput)in);
        this.blocks = new BlockWithLocations[len];
        for (int i = 0; i < len; ++i) {
            this.blocks[i] = new BlockWithLocations();
            this.blocks[i].readFields(in);
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class BlockWithLocations
    implements Writable {
        Block block;
        String[] datanodeIDs;
        public static final String __PARANAMER_DATA = "<init> org.apache.hadoop.hdfs.protocol.Block,java.lang.String[] b,datanodes \nreadFields java.io.DataInput in \nwrite java.io.DataOutput out \n";

        public BlockWithLocations() {
            this.block = new Block();
            this.datanodeIDs = null;
        }

        public BlockWithLocations(Block b, String[] datanodes) {
            this.block = b;
            this.datanodeIDs = datanodes;
        }

        public Block getBlock() {
            return this.block;
        }

        public String[] getDatanodes() {
            return this.datanodeIDs;
        }

        public void readFields(DataInput in) throws IOException {
            this.block.readFields(in);
            int len = WritableUtils.readVInt((DataInput)in);
            this.datanodeIDs = new String[len];
            for (int i = 0; i < len; ++i) {
                this.datanodeIDs[i] = Text.readString((DataInput)in);
            }
        }

        public void write(DataOutput out) throws IOException {
            this.block.write(out);
            WritableUtils.writeVInt((DataOutput)out, (int)this.datanodeIDs.length);
            for (String id : this.datanodeIDs) {
                Text.writeString((DataOutput)out, (String)id);
            }
        }
    }
}

