/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.TokenStorage;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class DelegationTokenFetcher {
    private static final String USAGE = "fetchdt retrieves delegation tokens (optionally over http)\nand writes them to specified file.\nUsage: fetchdt [--webservice <namenode http addr>] <output filename>";
    private final DistributedFileSystem dfs;
    private final UserGroupInformation ugi;
    private final DataOutputStream out;

    public static void main(final String[] args) throws Exception {
        UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                if (args.length == 3 && "--webservice".equals(args[0])) {
                    DelegationTokenFetcher.getDTfromRemote(args[1], args[2]);
                    return null;
                }
                if (args.length == 1 && "--webservice".equals(args[0])) {
                    System.out.println(DelegationTokenFetcher.USAGE);
                    return null;
                }
                if (args.length != 1 || args[0].isEmpty()) {
                    System.out.println(DelegationTokenFetcher.USAGE);
                    return null;
                }
                FilterOutputStream out = null;
                try {
                    HdfsConfiguration conf = new HdfsConfiguration();
                    DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.get((Configuration)conf);
                    out = new DataOutputStream(new FileOutputStream(args[0]));
                    UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                    new DelegationTokenFetcher(dfs, (DataOutputStream)out, ugi).go();
                    ((DataOutputStream)out).flush();
                    System.out.println("Succesfully wrote token of size " + ((DataOutputStream)out).size() + " bytes to " + args[0]);
                }
                catch (IOException ioe) {
                    System.out.println("Exception encountered:\n" + StringUtils.stringifyException((Throwable)ioe));
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
                return null;
            }
        });
    }

    public DelegationTokenFetcher(DistributedFileSystem dfs, DataOutputStream out, UserGroupInformation ugi) {
        this.checkNotNull("dfs", (Object)dfs);
        this.dfs = dfs;
        this.checkNotNull("out", out);
        this.out = out;
        this.checkNotNull("ugi", ugi);
        this.ugi = ugi;
    }

    private void checkNotNull(String s, Object o) {
        if (o == null) {
            throw new IllegalArgumentException(s + " cannot be null.");
        }
    }

    public void go() throws IOException {
        String fullName = this.ugi.getUserName();
        String shortName = this.ugi.getShortUserName();
        Token<DelegationTokenIdentifier> token = this.dfs.getDelegationToken(new Text(fullName));
        String nnAddress = InetAddress.getByName(this.dfs.getUri().getHost()).getHostAddress() + ":" + this.dfs.getUri().getPort();
        token.setService(new Text(nnAddress));
        TokenStorage ts = new TokenStorage();
        ts.addToken(new Text(shortName), token);
        ts.write((DataOutput)this.out);
    }

    private static void getDTfromRemote(String nnAddr, String filename) throws IOException {
        System.setProperty("https.cipherSuites", "TLS_KRB5_WITH_3DES_EDE_CBC_SHA");
        String ugiPostfix = "";
        FilterOutputStream file = null;
        FilterInputStream dis = null;
        if (nnAddr.startsWith("http:")) {
            ugiPostfix = "?ugi=" + UserGroupInformation.getCurrentUser().getShortUserName();
        }
        try {
            System.out.println("Retrieving token from: " + nnAddr + "/getDelegationToken" + ugiPostfix);
            URL remoteURL = new URL(nnAddr + "/getDelegationToken" + ugiPostfix);
            URLConnection connection = remoteURL.openConnection();
            InputStream in = connection.getInputStream();
            TokenStorage ts = new TokenStorage();
            dis = new DataInputStream(in);
            ts.readFields((DataInput)((Object)dis));
            file = new DataOutputStream(new FileOutputStream(filename));
            ts.write((DataOutput)((Object)file));
            ((DataOutputStream)file).flush();
            System.out.println("Successfully wrote token of " + ((DataOutputStream)file).size() + " bytes  to " + filename);
        }
        catch (Exception e) {
            throw new IOException("Unable to obtain remote token", e);
        }
        finally {
            if (dis != null) {
                dis.close();
            }
            if (file != null) {
                file.close();
            }
        }
    }
}

