/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class LocatedBlocks {
    private long fileLength;
    private List<LocatedBlock> blocks;
    private boolean underConstruction;
    private LocatedBlock lastLocatedBlock = null;
    private boolean isLastBlockComplete = false;

    public LocatedBlocks() {
        this.fileLength = 0L;
        this.blocks = null;
        this.underConstruction = false;
    }

    public LocatedBlocks(long flength, boolean isUnderConstuction, List<LocatedBlock> blks, LocatedBlock lastBlock, boolean isLastBlockCompleted) {
        this.fileLength = flength;
        this.blocks = blks;
        this.underConstruction = isUnderConstuction;
        this.lastLocatedBlock = lastBlock;
        this.isLastBlockComplete = isLastBlockCompleted;
    }

    public List<LocatedBlock> getLocatedBlocks() {
        return this.blocks;
    }

    public LocatedBlock getLastLocatedBlock() {
        return this.lastLocatedBlock;
    }

    public boolean isLastBlockComplete() {
        return this.isLastBlockComplete;
    }

    public LocatedBlock get(int index) {
        return this.blocks.get(index);
    }

    public int locatedBlockCount() {
        return this.blocks == null ? 0 : this.blocks.size();
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public boolean isUnderConstruction() {
        return this.underConstruction;
    }

    public int findBlock(long offset) {
        LocatedBlock key = new LocatedBlock();
        key.setStartOffset(offset);
        key.getBlock().setNumBytes(1L);
        Comparator<LocatedBlock> comp = new Comparator<LocatedBlock>(){

            @Override
            public int compare(LocatedBlock a, LocatedBlock b) {
                long aBeg = a.getStartOffset();
                long bBeg = b.getStartOffset();
                long aEnd = aBeg + a.getBlockSize();
                long bEnd = bBeg + b.getBlockSize();
                if (aBeg <= bBeg && bEnd <= aEnd || bBeg <= aBeg && aEnd <= bEnd) {
                    return 0;
                }
                if (aBeg < bBeg) {
                    return -1;
                }
                return 1;
            }
        };
        return Collections.binarySearch(this.blocks, key, comp);
    }

    public void insertRange(int blockIdx, List<LocatedBlock> newBlocks) {
        int oldIdx = blockIdx;
        int insStart = 0;
        int insEnd = 0;
        for (int newIdx = 0; newIdx < newBlocks.size() && oldIdx < this.blocks.size(); ++newIdx) {
            long oldOff;
            long newOff = newBlocks.get(newIdx).getStartOffset();
            if (newOff < (oldOff = this.blocks.get(oldIdx).getStartOffset())) {
                ++insEnd;
                continue;
            }
            if (newOff == oldOff) {
                this.blocks.set(oldIdx, newBlocks.get(newIdx));
                if (insStart < insEnd) {
                    this.blocks.addAll(oldIdx, newBlocks.subList(insStart, insEnd));
                    oldIdx += insEnd - insStart;
                }
                insStart = insEnd = newIdx + 1;
                ++oldIdx;
                continue;
            }
            assert (false) : "List of LocatedBlock must be sorted by startOffset";
        }
        insEnd = newBlocks.size();
        if (insStart < insEnd) {
            this.blocks.addAll(oldIdx, newBlocks.subList(insStart, insEnd));
        }
    }

    public static int getInsertIndex(int binSearchResult) {
        return binSearchResult >= 0 ? binSearchResult : -(binSearchResult + 1);
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName());
        b.append("{").append("\n  fileLength=").append(this.fileLength).append("\n  underConstruction=").append(this.underConstruction).append("\n  blocks=").append(this.blocks).append("\n  lastLocatedBlock=").append(this.lastLocatedBlock).append("\n  isLastBlockComplete=").append(this.isLastBlockComplete).append("}");
        return b.toString();
    }
}

