/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.util.LightWeightHashSet;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeDescriptor
extends DatanodeInfo {
    public DecommissioningStatus decommissioningStatus = new DecommissioningStatus();
    private volatile BlockInfo blockList = null;
    private int numBlocks = 0;
    public boolean isAlive = false;
    public boolean needKeyUpdate = false;
    private boolean heartbeatedSinceFailover = false;
    private boolean blockContentsStale = true;
    private long bandwidth;
    private BlockQueue<BlockTargetPair> replicateBlocks = new BlockQueue();
    private BlockQueue<BlockInfoUnderConstruction> recoverBlocks = new BlockQueue();
    private LightWeightHashSet<Block> invalidateBlocks = new LightWeightHashSet();
    private int currApproxBlocksScheduled = 0;
    private int prevApproxBlocksScheduled = 0;
    private long lastBlocksScheduledRollTime = 0L;
    private static final int BLOCKS_SCHEDULED_ROLL_INTERVAL = 600000;
    private int volumeFailures = 0;
    private boolean firstBlockReport = true;
    private boolean disallowed = false;

    public DatanodeDescriptor(DatanodeID nodeID) {
        this(nodeID, 0L, 0L, 0L, 0L, 0, 0);
    }

    public DatanodeDescriptor(DatanodeID nodeID, String networkLocation) {
        this(nodeID, networkLocation, 0L, 0L, 0L, 0L, 0, 0);
    }

    public DatanodeDescriptor(DatanodeID nodeID, long capacity, long dfsUsed, long remaining, long bpused, int xceiverCount, int failedVolumes) {
        super(nodeID);
        this.updateHeartbeat(capacity, dfsUsed, remaining, bpused, xceiverCount, failedVolumes);
    }

    public DatanodeDescriptor(DatanodeID nodeID, String networkLocation, long capacity, long dfsUsed, long remaining, long bpused, int xceiverCount, int failedVolumes) {
        super(nodeID, networkLocation);
        this.updateHeartbeat(capacity, dfsUsed, remaining, bpused, xceiverCount, failedVolumes);
    }

    public boolean addBlock(BlockInfo b) {
        if (!b.addNode(this)) {
            return false;
        }
        this.blockList = b.listInsert(this.blockList, this);
        ++this.numBlocks;
        return true;
    }

    public boolean removeBlock(BlockInfo b) {
        this.blockList = b.listRemove(this.blockList, this);
        if (b.removeNode(this)) {
            --this.numBlocks;
            return true;
        }
        return false;
    }

    int moveBlockToHead(BlockInfo b, int curIndex, int headIndex) {
        this.blockList = b.moveBlockToHead(this.blockList, this, curIndex, headIndex);
        return curIndex;
    }

    protected BlockInfo getHead() {
        return this.blockList;
    }

    public BlockInfo replaceBlock(BlockInfo oldBlock, BlockInfo newBlock) {
        boolean done = this.removeBlock(oldBlock);
        assert (done) : "Old block should belong to the data-node when replacing";
        done = this.addBlock(newBlock);
        assert (done) : "New block should not belong to the data-node when replacing";
        return newBlock;
    }

    public void resetBlocks() {
        this.capacity = 0L;
        this.remaining = 0L;
        this.blockPoolUsed = 0L;
        this.dfsUsed = 0L;
        this.xceiverCount = 0;
        this.blockList = null;
        this.invalidateBlocks.clear();
        this.volumeFailures = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBlockQueues() {
        LightWeightHashSet<Block> lightWeightHashSet = this.invalidateBlocks;
        synchronized (lightWeightHashSet) {
            this.invalidateBlocks.clear();
            this.recoverBlocks.clear();
            this.replicateBlocks.clear();
        }
    }

    public int numBlocks() {
        return this.numBlocks;
    }

    public void updateHeartbeat(long capacity, long dfsUsed, long remaining, long blockPoolUsed, int xceiverCount, int volFailures) {
        this.capacity = capacity;
        this.dfsUsed = dfsUsed;
        this.remaining = remaining;
        this.blockPoolUsed = blockPoolUsed;
        this.lastUpdate = System.currentTimeMillis();
        this.xceiverCount = xceiverCount;
        this.volumeFailures = volFailures;
        this.heartbeatedSinceFailover = true;
        this.rollBlocksScheduled(this.lastUpdate);
    }

    public Iterator<BlockInfo> getBlockIterator() {
        return new BlockIterator(this.blockList, this);
    }

    void addBlockToBeReplicated(Block block, DatanodeDescriptor[] targets) {
        assert (block != null && targets != null && targets.length > 0);
        this.replicateBlocks.offer(new BlockTargetPair(block, targets));
    }

    void addBlockToBeRecovered(BlockInfoUnderConstruction block) {
        if (this.recoverBlocks.contains(block)) {
            BlockManager.LOG.info((Object)("Block " + block + " is already in the recovery queue."));
            return;
        }
        this.recoverBlocks.offer(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBlocksToBeInvalidated(List<Block> blocklist) {
        assert (blocklist != null && blocklist.size() > 0);
        LightWeightHashSet<Block> lightWeightHashSet = this.invalidateBlocks;
        synchronized (lightWeightHashSet) {
            for (Block blk : blocklist) {
                this.invalidateBlocks.add(blk);
            }
        }
    }

    int getNumberOfBlocksToBeReplicated() {
        return this.replicateBlocks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfBlocksToBeInvalidated() {
        LightWeightHashSet<Block> lightWeightHashSet = this.invalidateBlocks;
        synchronized (lightWeightHashSet) {
            return this.invalidateBlocks.size();
        }
    }

    public List<BlockTargetPair> getReplicationCommand(int maxTransfers) {
        return this.replicateBlocks.poll(maxTransfers);
    }

    public BlockInfoUnderConstruction[] getLeaseRecoveryCommand(int maxTransfers) {
        List<BlockInfoUnderConstruction> blocks = this.recoverBlocks.poll(maxTransfers);
        if (blocks == null) {
            return null;
        }
        return blocks.toArray(new BlockInfoUnderConstruction[blocks.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block[] getInvalidateBlocks(int maxblocks) {
        LightWeightHashSet<Block> lightWeightHashSet = this.invalidateBlocks;
        synchronized (lightWeightHashSet) {
            Block[] deleteList = this.invalidateBlocks.pollToArray((Block[])new Block[Math.min(this.invalidateBlocks.size(), maxblocks)]);
            return deleteList.length == 0 ? null : deleteList;
        }
    }

    public int getBlocksScheduled() {
        return this.currApproxBlocksScheduled + this.prevApproxBlocksScheduled;
    }

    public void incBlocksScheduled() {
        ++this.currApproxBlocksScheduled;
    }

    void decBlocksScheduled() {
        if (this.prevApproxBlocksScheduled > 0) {
            --this.prevApproxBlocksScheduled;
        } else if (this.currApproxBlocksScheduled > 0) {
            --this.currApproxBlocksScheduled;
        }
    }

    private void rollBlocksScheduled(long now) {
        if (now - this.lastBlocksScheduledRollTime > 600000L) {
            this.prevApproxBlocksScheduled = this.currApproxBlocksScheduled;
            this.currApproxBlocksScheduled = 0;
            this.lastBlocksScheduledRollTime = now;
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    public void setDisallowed(boolean flag) {
        this.disallowed = flag;
    }

    public boolean isDisallowed() {
        return this.disallowed;
    }

    public int getVolumeFailures() {
        return this.volumeFailures;
    }

    @Override
    public void updateRegInfo(DatanodeID nodeReg) {
        super.updateRegInfo(nodeReg);
    }

    public long getBalancerBandwidth() {
        return this.bandwidth;
    }

    public void setBalancerBandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
    }

    public boolean areBlockContentsStale() {
        return this.blockContentsStale;
    }

    public void markStaleAfterFailover() {
        this.heartbeatedSinceFailover = false;
        this.blockContentsStale = true;
    }

    public void receivedBlockReport() {
        if (this.heartbeatedSinceFailover) {
            this.blockContentsStale = false;
        }
        this.firstBlockReport = false;
    }

    boolean isFirstBlockReport() {
        return this.firstBlockReport;
    }

    @Override
    public String dumpDatanode() {
        int recover;
        int inval;
        StringBuilder sb = new StringBuilder(super.dumpDatanode());
        int repl = this.replicateBlocks.size();
        if (repl > 0) {
            sb.append(" ").append(repl).append(" blocks to be replicated;");
        }
        if ((inval = this.invalidateBlocks.size()) > 0) {
            sb.append(" ").append(inval).append(" blocks to be invalidated;");
        }
        if ((recover = this.recoverBlocks.size()) > 0) {
            sb.append(" ").append(recover).append(" blocks to be recovered;");
        }
        return sb.toString();
    }

    public class DecommissioningStatus {
        private int underReplicatedBlocks;
        private int decommissionOnlyReplicas;
        private int underReplicatedInOpenFiles;
        private long startTime;

        synchronized void set(int underRep, int onlyRep, int underConstruction) {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return;
            }
            this.underReplicatedBlocks = underRep;
            this.decommissionOnlyReplicas = onlyRep;
            this.underReplicatedInOpenFiles = underConstruction;
        }

        public synchronized int getUnderReplicatedBlocks() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0;
            }
            return this.underReplicatedBlocks;
        }

        public synchronized int getDecommissionOnlyReplicas() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0;
            }
            return this.decommissionOnlyReplicas;
        }

        public synchronized int getUnderReplicatedInOpenFiles() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0;
            }
            return this.underReplicatedInOpenFiles;
        }

        public synchronized void setStartTime(long time) {
            this.startTime = time;
        }

        public synchronized long getStartTime() {
            if (!DatanodeDescriptor.this.isDecommissionInProgress()) {
                return 0L;
            }
            return this.startTime;
        }
    }

    public static class BlockIterator
    implements Iterator<BlockInfo> {
        private BlockInfo current;
        private DatanodeDescriptor node;

        BlockIterator(BlockInfo head, DatanodeDescriptor dn) {
            this.current = head;
            this.node = dn;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public BlockInfo next() {
            BlockInfo res = this.current;
            this.current = this.current.getNext(this.current.findDatanode(this.node));
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Sorry. can't remove.");
        }
    }

    private static class BlockQueue<E> {
        private final Queue<E> blockq = new LinkedList();

        private BlockQueue() {
        }

        synchronized int size() {
            return this.blockq.size();
        }

        synchronized boolean offer(E e) {
            return this.blockq.offer(e);
        }

        synchronized List<E> poll(int numBlocks) {
            if (numBlocks <= 0 || this.blockq.isEmpty()) {
                return null;
            }
            ArrayList<E> results = new ArrayList<E>();
            while (!this.blockq.isEmpty() && numBlocks > 0) {
                results.add(this.blockq.poll());
                --numBlocks;
            }
            return results;
        }

        boolean contains(E e) {
            return this.blockq.contains(e);
        }

        synchronized void clear() {
            this.blockq.clear();
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public static class BlockTargetPair {
        public final Block block;
        public final DatanodeDescriptor[] targets;

        BlockTargetPair(Block block, DatanodeDescriptor[] targets) {
            this.block = block;
            this.targets = targets;
        }
    }
}

