/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogLoader;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.io.IOUtils;

public class EditLogFileInputStream
extends EditLogInputStream {
    private final File file;
    private final FileInputStream fStream;
    private final long firstTxId;
    private final long lastTxId;
    private final int logVersion;
    private final FSEditLogOp.Reader reader;
    private final FSEditLogLoader.PositionTrackingInputStream tracker;
    private final boolean isInProgress;

    EditLogFileInputStream(File name) throws LogHeaderCorruptException, IOException {
        this(name, -12345L, -12345L, false);
    }

    public EditLogFileInputStream(File name, long firstTxId, long lastTxId, boolean isInProgress) throws LogHeaderCorruptException, IOException {
        this.file = name;
        this.fStream = new FileInputStream(name);
        BufferedInputStream bin = new BufferedInputStream(this.fStream);
        this.tracker = new FSEditLogLoader.PositionTrackingInputStream(bin);
        DataInputStream in = new DataInputStream(this.tracker);
        try {
            this.logVersion = EditLogFileInputStream.readLogVersion(in);
        }
        catch (EOFException eofe) {
            throw new LogHeaderCorruptException("No header found in log");
        }
        this.reader = new FSEditLogOp.Reader(in, this.logVersion);
        this.firstTxId = firstTxId;
        this.lastTxId = lastTxId;
        this.isInProgress = isInProgress;
    }

    @Override
    public long getFirstTxId() throws IOException {
        return this.firstTxId;
    }

    @Override
    public long getLastTxId() throws IOException {
        return this.lastTxId;
    }

    @Override
    public String getName() {
        return this.file.getPath();
    }

    @Override
    protected FSEditLogOp nextOp() throws IOException {
        return this.reader.readOp(false);
    }

    @Override
    protected FSEditLogOp nextValidOp() {
        try {
            return this.reader.readOp(true);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public int getVersion() throws IOException {
        return this.logVersion;
    }

    @Override
    public long getPosition() {
        return this.tracker.getPos();
    }

    @Override
    public void close() throws IOException {
        this.fStream.close();
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public boolean isInProgress() {
        return this.isInProgress;
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FSEditLogLoader.EditLogValidation validateEditLog(File file) throws IOException {
        EditLogFileInputStream in;
        try {
            in = new EditLogFileInputStream(file);
        }
        catch (LogHeaderCorruptException corrupt) {
            FSImage.LOG.warn((Object)("Log at " + file + " has no valid header"), (Throwable)corrupt);
            return new FSEditLogLoader.EditLogValidation(0L, -12345L, -12345L, true);
        }
        try {
            FSEditLogLoader.EditLogValidation editLogValidation = FSEditLogLoader.validateEditLog(in);
            return editLogValidation;
        }
        finally {
            IOUtils.closeStream((Closeable)in);
        }
    }

    @VisibleForTesting
    static int readLogVersion(DataInputStream in) throws IOException, LogHeaderCorruptException {
        int logVersion;
        try {
            logVersion = in.readInt();
        }
        catch (EOFException eofe) {
            throw new LogHeaderCorruptException("Reached EOF when reading log header");
        }
        if (logVersion < HdfsConstants.LAYOUT_VERSION || logVersion > -16) {
            throw new LogHeaderCorruptException("Unexpected version of the file system log file: " + logVersion + ". Current version = " + HdfsConstants.LAYOUT_VERSION + ".");
        }
        return logVersion;
    }

    static class LogHeaderCorruptException
    extends IOException {
        private static final long serialVersionUID = 1L;

        private LogHeaderCorruptException(String msg) {
            super(msg);
        }
    }
}

