/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DeprecatedUTF8;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FSImageSerialization {
    private static final ThreadLocal<TLData> TL_DATA = new ThreadLocal<TLData>(){

        @Override
        protected TLData initialValue() {
            return new TLData();
        }
    };

    private FSImageSerialization() {
    }

    static INodeFileUnderConstruction readINodeUnderConstruction(DataInputStream in) throws IOException {
        byte[] name = FSImageSerialization.readBytes(in);
        short blockReplication = in.readShort();
        long modificationTime = in.readLong();
        long preferredBlockSize = in.readLong();
        int numBlocks = in.readInt();
        BlockInfo[] blocks = new BlockInfo[numBlocks];
        Block blk = new Block();
        for (int i = 0; i < numBlocks - 1; ++i) {
            blk.readFields(in);
            blocks[i] = new BlockInfo(blk, blockReplication);
        }
        if (numBlocks > 0) {
            blk.readFields(in);
            blocks[i] = new BlockInfoUnderConstruction(blk, blockReplication, HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, null);
        }
        PermissionStatus perm = PermissionStatus.read((DataInput)in);
        String clientName = FSImageSerialization.readString(in);
        String clientMachine = FSImageSerialization.readString(in);
        int numLocs = in.readInt();
        assert (numLocs == 0) : "Unexpected block locations";
        return new INodeFileUnderConstruction(name, blockReplication, modificationTime, preferredBlockSize, blocks, perm, clientName, clientMachine, null);
    }

    static void writeINodeUnderConstruction(DataOutputStream out, INodeFileUnderConstruction cons, String path) throws IOException {
        FSImageSerialization.writeString(path, out);
        out.writeShort(cons.getReplication());
        out.writeLong(cons.getModificationTime());
        out.writeLong(cons.getPreferredBlockSize());
        int nrBlocks = cons.getBlocks().length;
        out.writeInt(nrBlocks);
        for (int i = 0; i < nrBlocks; ++i) {
            cons.getBlocks()[i].write(out);
        }
        cons.getPermissionStatus().write((DataOutput)out);
        FSImageSerialization.writeString(cons.getClientName(), out);
        FSImageSerialization.writeString(cons.getClientMachine(), out);
        out.writeInt(0);
    }

    static void saveINode2Image(INode node, DataOutputStream out) throws IOException {
        byte[] name = node.getLocalNameBytes();
        out.writeShort(name.length);
        out.write(name);
        FsPermission filePerm = FSImageSerialization.TL_DATA.get().FILE_PERM;
        if (node.isDirectory()) {
            out.writeShort(0);
            out.writeLong(node.getModificationTime());
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeInt(-1);
            out.writeLong(node.getNsQuota());
            out.writeLong(node.getDsQuota());
            filePerm.fromShort(node.getFsPermissionShort());
            PermissionStatus.write((DataOutput)out, (String)node.getUserName(), (String)node.getGroupName(), (FsPermission)filePerm);
        } else if (node.isLink()) {
            out.writeShort(0);
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeInt(-2);
            Text.writeString((DataOutput)out, (String)((INodeSymlink)node).getLinkValue());
            filePerm.fromShort(node.getFsPermissionShort());
            PermissionStatus.write((DataOutput)out, (String)node.getUserName(), (String)node.getGroupName(), (FsPermission)filePerm);
        } else {
            INodeFile fileINode = (INodeFile)node;
            out.writeShort(fileINode.getReplication());
            out.writeLong(fileINode.getModificationTime());
            out.writeLong(fileINode.getAccessTime());
            out.writeLong(fileINode.getPreferredBlockSize());
            BlockInfo[] blocks = fileINode.getBlocks();
            out.writeInt(blocks.length);
            for (BlockInfo blk : blocks) {
                blk.write(out);
            }
            filePerm.fromShort(fileINode.getFsPermissionShort());
            PermissionStatus.write((DataOutput)out, (String)fileINode.getUserName(), (String)fileINode.getGroupName(), (FsPermission)filePerm);
        }
    }

    public static String readString(DataInputStream in) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.readFields(in);
        return ustr.toString();
    }

    static String readString_EmptyAsNull(DataInputStream in) throws IOException {
        String s = FSImageSerialization.readString(in);
        return s.isEmpty() ? null : s;
    }

    static void writeString(String str, DataOutputStream out) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.set(str);
        ustr.write(out);
    }

    static long readLong(DataInputStream in) throws IOException {
        LongWritable ustr = FSImageSerialization.TL_DATA.get().U_LONG;
        ustr.readFields((DataInput)in);
        return ustr.get();
    }

    static void writeLong(long value, DataOutputStream out) throws IOException {
        LongWritable uLong = FSImageSerialization.TL_DATA.get().U_LONG;
        uLong.set(value);
        uLong.write((DataOutput)out);
    }

    static short readShort(DataInputStream in) throws IOException {
        ShortWritable uShort = FSImageSerialization.TL_DATA.get().U_SHORT;
        uShort.readFields((DataInput)in);
        return uShort.get();
    }

    static void writeShort(short value, DataOutputStream out) throws IOException {
        ShortWritable uShort = FSImageSerialization.TL_DATA.get().U_SHORT;
        uShort.set(value);
        uShort.write((DataOutput)out);
    }

    public static byte[] readBytes(DataInputStream in) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.readFields(in);
        int len = ustr.getLength();
        byte[] bytes = new byte[len];
        System.arraycopy(ustr.getBytes(), 0, bytes, 0, len);
        return bytes;
    }

    public static byte[][] readPathComponents(DataInputStream in) throws IOException {
        DeprecatedUTF8 ustr = FSImageSerialization.TL_DATA.get().U_STR;
        ustr.readFields(in);
        return DFSUtil.bytes2byteArray(ustr.getBytes(), ustr.getLength(), (byte)47);
    }

    public static void writeCompactBlockArray(Block[] blocks, DataOutputStream out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)blocks.length);
        Block prev = null;
        for (Block b : blocks) {
            long szDelta = b.getNumBytes() - (prev != null ? prev.getNumBytes() : 0L);
            long gsDelta = b.getGenerationStamp() - (prev != null ? prev.getGenerationStamp() : 0L);
            out.writeLong(b.getBlockId());
            WritableUtils.writeVLong((DataOutput)out, (long)szDelta);
            WritableUtils.writeVLong((DataOutput)out, (long)gsDelta);
            prev = b;
        }
    }

    public static Block[] readCompactBlockArray(DataInputStream in, int logVersion) throws IOException {
        int num = WritableUtils.readVInt((DataInput)in);
        if (num < 0) {
            throw new IOException("Invalid block array length: " + num);
        }
        Block prev = null;
        Block[] ret = new Block[num];
        for (int i = 0; i < num; ++i) {
            long id = in.readLong();
            long sz = WritableUtils.readVLong((DataInput)in) + (prev != null ? prev.getNumBytes() : 0L);
            long gs = WritableUtils.readVLong((DataInput)in) + (prev != null ? prev.getGenerationStamp() : 0L);
            ret[i] = new Block(id, sz, gs);
            prev = ret[i];
        }
        return ret;
    }

    private static final class TLData {
        final DeprecatedUTF8 U_STR = new DeprecatedUTF8();
        final ShortWritable U_SHORT = new ShortWritable();
        final LongWritable U_LONG = new LongWritable();
        final FsPermission FILE_PERM = new FsPermission(0);

        private TLData() {
        }
    }
}

