/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.BackupNode;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.hadoop.hdfs.server.namenode.MetaRecoveryContext;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.hdfs.server.namenode.ha.ActiveState;
import org.apache.hadoop.hdfs.server.namenode.ha.BootstrapStandby;
import org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.hadoop.hdfs.server.namenode.ha.HAState;
import org.apache.hadoop.hdfs.server.namenode.ha.StandbyState;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.util.AtomicFileOutputStream;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.RefreshUserMappingsProtocol;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.RefreshAuthorizationPolicyProtocol;
import org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.apache.hadoop.util.ServicePlugin;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class NameNode {
    public static final String[] NAMESERVICE_SPECIFIC_KEYS;
    public static final int DEFAULT_PORT = 8020;
    public static final Log LOG;
    public static final Log stateChangeLog;
    public static final HAState ACTIVE_STATE;
    public static final HAState STANDBY_STATE;
    protected FSNamesystem namesystem;
    protected final Configuration conf;
    protected HdfsServerConstants.NamenodeRole role;
    private volatile HAState state;
    private final boolean haEnabled;
    private final HAContext haContext;
    protected boolean allowStaleStandbyReads;
    protected NameNodeHttpServer httpServer;
    private Thread emptier;
    protected boolean stopRequested = false;
    protected NamenodeRegistration nodeRegistration;
    private List<ServicePlugin> plugins;
    private NameNodeRpcServer rpcServer;
    static NameNodeMetrics metrics;

    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(ClientProtocol.class.getName())) {
            return 69L;
        }
        if (protocol.equals(DatanodeProtocol.class.getName())) {
            return 28L;
        }
        if (protocol.equals(NamenodeProtocol.class.getName())) {
            return 6L;
        }
        if (protocol.equals(RefreshAuthorizationPolicyProtocol.class.getName())) {
            return 1L;
        }
        if (protocol.equals(RefreshUserMappingsProtocol.class.getName())) {
            return 1L;
        }
        if (protocol.equals(GetUserMappingsProtocol.class.getName())) {
            return 1L;
        }
        throw new IOException("Unknown protocol to name node: " + protocol);
    }

    public static void format(Configuration conf) throws IOException {
        NameNode.format(conf, true, true);
    }

    public FSNamesystem getNamesystem() {
        return this.namesystem;
    }

    public NamenodeProtocols getRpcServer() {
        return this.rpcServer;
    }

    static void initMetrics(Configuration conf, HdfsServerConstants.NamenodeRole role) {
        metrics = NameNodeMetrics.create(conf, role);
    }

    public static NameNodeMetrics getNameNodeMetrics() {
        return metrics;
    }

    public static InetSocketAddress getAddress(String address) {
        return NetUtils.createSocketAddr((String)address, (int)8020);
    }

    public static void setServiceAddress(Configuration conf, String address) {
        LOG.info((Object)("Setting ADDRESS " + address));
        conf.set("dfs.namenode.servicerpc-address", address);
    }

    public static InetSocketAddress getServiceAddress(Configuration conf, boolean fallback) {
        String addr = conf.get("dfs.namenode.servicerpc-address");
        if (addr == null || addr.isEmpty()) {
            return fallback ? NameNode.getAddress(conf) : null;
        }
        return NameNode.getAddress(addr);
    }

    public static InetSocketAddress getAddress(Configuration conf) {
        URI filesystemURI = FileSystem.getDefaultUri((Configuration)conf);
        return NameNode.getAddress(filesystemURI);
    }

    public static InetSocketAddress getAddress(URI filesystemURI) {
        String authority = filesystemURI.getAuthority();
        if (authority == null) {
            throw new IllegalArgumentException(String.format("Invalid URI for NameNode address (check %s): %s has no authority.", "fs.defaultFS", filesystemURI.toString()));
        }
        if (!"hdfs".equalsIgnoreCase(filesystemURI.getScheme())) {
            throw new IllegalArgumentException(String.format("Invalid URI for NameNode address (check %s): %s is not of scheme '%s'.", "fs.defaultFS", filesystemURI.toString(), "hdfs"));
        }
        return NameNode.getAddress(authority);
    }

    public static URI getUri(InetSocketAddress namenode) {
        int port = namenode.getPort();
        String portString = port == 8020 ? "" : ":" + port;
        return URI.create("hdfs://" + namenode.getHostName() + portString);
    }

    public HdfsServerConstants.NamenodeRole getRole() {
        return this.role;
    }

    boolean isRole(HdfsServerConstants.NamenodeRole that) {
        return this.role.equals((Object)that);
    }

    protected InetSocketAddress getServiceRpcServerAddress(Configuration conf) {
        return NameNode.getServiceAddress(conf, false);
    }

    protected InetSocketAddress getRpcServerAddress(Configuration conf) {
        return NameNode.getAddress(conf);
    }

    protected void setRpcServiceServerAddress(Configuration conf, InetSocketAddress serviceRPCAddress) {
        NameNode.setServiceAddress(conf, NetUtils.getHostPortString((InetSocketAddress)serviceRPCAddress));
    }

    protected void setRpcServerAddress(Configuration conf, InetSocketAddress rpcAddress) {
        FileSystem.setDefaultUri((Configuration)conf, (URI)NameNode.getUri(rpcAddress));
    }

    protected InetSocketAddress getHttpServerAddress(Configuration conf) {
        return NameNode.getHttpAddress(conf);
    }

    public static InetSocketAddress getHttpAddress(Configuration conf) {
        return NetUtils.createSocketAddr((String)conf.get("dfs.namenode.http-address", "0.0.0.0:50070"));
    }

    protected void setHttpServerAddress(Configuration conf) {
        conf.set("dfs.namenode.http-address", NetUtils.getHostPortString((InetSocketAddress)this.getHttpAddress()));
    }

    protected void loadNamesystem(Configuration conf) throws IOException {
        this.namesystem = FSNamesystem.loadFromDisk(conf);
    }

    NamenodeRegistration getRegistration() {
        return this.nodeRegistration;
    }

    NamenodeRegistration setRegistration() {
        this.nodeRegistration = new NamenodeRegistration(NetUtils.getHostPortString((InetSocketAddress)this.rpcServer.getRpcAddress()), NetUtils.getHostPortString((InetSocketAddress)this.getHttpAddress()), this.getFSImage().getStorage(), this.getRole());
        return this.nodeRegistration;
    }

    void loginAsNameNodeUser(Configuration conf) throws IOException {
        InetSocketAddress socAddr = this.getRpcServerAddress(conf);
        SecurityUtil.login((Configuration)conf, (String)"dfs.namenode.keytab.file", (String)"dfs.namenode.kerberos.principal", (String)socAddr.getHostName());
    }

    protected void initialize(Configuration conf) throws IOException {
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.loginAsNameNodeUser(conf);
        NameNode.initMetrics(conf, this.getRole());
        this.loadNamesystem(conf);
        this.rpcServer = this.createRpcServer(conf);
        try {
            this.validateConfigurationSettings(conf);
        }
        catch (IOException e) {
            LOG.fatal((Object)e.toString());
            throw e;
        }
        this.startCommonServices(conf);
    }

    protected NameNodeRpcServer createRpcServer(Configuration conf) throws IOException {
        return new NameNodeRpcServer(conf, this);
    }

    protected void validateConfigurationSettings(Configuration conf) throws IOException {
        if (this.getHttpServerAddress(conf).getPort() == this.getRpcServerAddress(conf).getPort()) {
            String errMsg = "dfs.namenode.rpc-address (" + this.getRpcServerAddress(conf) + ") and " + "dfs.namenode.http-address (" + this.getHttpServerAddress(conf) + ") " + "configuration keys are bound to the same port, unable to start " + "NameNode. Port: " + this.getRpcServerAddress(conf).getPort();
            throw new IOException(errMsg);
        }
    }

    private void startCommonServices(Configuration conf) throws IOException {
        this.namesystem.startCommonServices(conf, this.haContext);
        this.startHttpServer(conf);
        this.rpcServer.start();
        this.plugins = conf.getInstances("dfs.namenode.plugins", ServicePlugin.class);
        for (ServicePlugin p : this.plugins) {
            try {
                p.start((Object)this);
            }
            catch (Throwable t) {
                LOG.warn((Object)("ServicePlugin " + p + " could not be started"), t);
            }
        }
        LOG.info((Object)((Object)((Object)this.getRole()) + " up at: " + this.rpcServer.getRpcAddress()));
        if (this.rpcServer.getServiceRpcAddress() != null) {
            LOG.info((Object)((Object)((Object)this.getRole()) + " service server is up at: " + this.rpcServer.getServiceRpcAddress()));
        }
    }

    private void stopCommonServices() {
        if (this.namesystem != null) {
            this.namesystem.close();
        }
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
        if (this.plugins != null) {
            for (ServicePlugin p : this.plugins) {
                try {
                    p.stop();
                }
                catch (Throwable t) {
                    LOG.warn((Object)("ServicePlugin " + p + " could not be stopped"), t);
                }
            }
        }
        this.stopHttpServer();
    }

    private void startTrashEmptier(Configuration conf) throws IOException {
        long trashInterval = conf.getLong("fs.trash.interval", 0L);
        if (trashInterval == 0L) {
            return;
        }
        this.emptier = new Thread(new Trash(conf).getEmptier(), "Trash Emptier");
        this.emptier.setDaemon(true);
        this.emptier.start();
    }

    private void stopTrashEmptier() {
        if (this.emptier != null) {
            this.emptier.interrupt();
            this.emptier = null;
        }
    }

    private void startHttpServer(Configuration conf) throws IOException {
        this.httpServer = new NameNodeHttpServer(conf, this, this.getHttpServerAddress(conf));
        this.httpServer.start();
        this.setHttpServerAddress(conf);
    }

    private void stopHttpServer() {
        try {
            if (this.httpServer != null) {
                this.httpServer.stop();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while stopping httpserver", (Throwable)e);
        }
    }

    public NameNode(Configuration conf) throws IOException {
        this(conf, HdfsServerConstants.NamenodeRole.NAMENODE);
    }

    protected NameNode(Configuration conf, HdfsServerConstants.NamenodeRole role) throws IOException {
        this.conf = conf;
        this.role = role;
        String nsId = this.getNameServiceId(conf);
        String namenodeId = HAUtil.getNameNodeId(conf, nsId);
        this.haEnabled = HAUtil.isHAEnabled(conf, nsId);
        this.state = !this.haEnabled ? ACTIVE_STATE : STANDBY_STATE;
        this.allowStaleStandbyReads = HAUtil.shouldAllowStandbyReads(conf);
        this.haContext = this.createHAContext();
        try {
            NameNode.initializeGenericKeys(conf, nsId, namenodeId);
            this.initialize(conf);
            this.state.prepareToEnterState(this.haContext);
            this.state.enterState(this.haContext);
        }
        catch (IOException e) {
            this.stop();
            throw e;
        }
        catch (HadoopIllegalArgumentException e) {
            this.stop();
            throw e;
        }
    }

    protected HAContext createHAContext() {
        return new NameNodeHAContext();
    }

    public void join() {
        try {
            this.rpcServer.join();
        }
        catch (InterruptedException ie) {
            LOG.info((Object)"Caught interrupted exception ", (Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        NameNode nameNode = this;
        synchronized (nameNode) {
            if (this.stopRequested) {
                return;
            }
            this.stopRequested = true;
        }
        try {
            if (this.state != null) {
                this.state.exitState(this.haContext);
            }
        }
        catch (ServiceFailedException e) {
            LOG.warn((Object)"Encountered exception while exiting state ", (Throwable)e);
        }
        this.stopCommonServices();
        if (metrics != null) {
            metrics.shutdown();
        }
        if (this.namesystem != null) {
            this.namesystem.shutdown();
        }
    }

    synchronized boolean isStopRequested() {
        return this.stopRequested;
    }

    public boolean isInSafeMode() {
        return this.namesystem.isInSafeMode();
    }

    FSImage getFSImage() {
        return this.namesystem.dir.fsImage;
    }

    public InetSocketAddress getNameNodeAddress() {
        return this.rpcServer.getRpcAddress();
    }

    public InetSocketAddress getServiceRpcAddress() {
        return this.rpcServer.getServiceRpcAddress() != null ? this.rpcServer.getServiceRpcAddress() : this.rpcServer.getRpcAddress();
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpServer.getHttpAddress();
    }

    private static boolean format(Configuration conf, boolean force, boolean isInteractive) throws IOException {
        String nsId = DFSUtil.getNamenodeNameServiceId(conf);
        String namenodeId = HAUtil.getNameNodeId(conf, nsId);
        NameNode.initializeGenericKeys(conf, nsId, namenodeId);
        NameNode.checkAllowFormat(conf);
        Collection<URI> dirsToFormat = FSNamesystem.getNamespaceDirs(conf);
        List<URI> editDirsToFormat = FSNamesystem.getNamespaceEditsDirs(conf);
        if (!NameNode.confirmFormat(dirsToFormat, force, isInteractive)) {
            return true;
        }
        String clusterId = HdfsServerConstants.StartupOption.FORMAT.getClusterId();
        if (clusterId == null || clusterId.equals("")) {
            clusterId = NNStorage.newClusterID();
        }
        System.out.println("Formatting using clusterid: " + clusterId);
        FSImage fsImage = new FSImage(conf, dirsToFormat, editDirsToFormat);
        FSNamesystem fsn = new FSNamesystem(conf, fsImage);
        fsImage.format(fsn, clusterId);
        return false;
    }

    public static boolean confirmFormat(Collection<URI> dirsToFormat, boolean force, boolean interactive) throws IOException {
        Iterator<URI> it = dirsToFormat.iterator();
        while (it.hasNext()) {
            File curDir = new File(it.next().getPath());
            if (!curDir.exists() || curDir.isDirectory() && FileUtil.listFiles((File)curDir).length == 0) continue;
            if (force) {
                System.err.println("Storage directory exists in " + curDir + ". Formatting anyway.");
                continue;
            }
            if (!interactive) {
                System.err.println("Running in non-interactive mode, and image appears to exist in " + curDir + ". Not formatting.");
                return false;
            }
            if (ToolRunner.confirmPrompt((String)("Re-format filesystem in " + curDir + " ?"))) continue;
            System.err.println("Format aborted in " + curDir);
            return false;
        }
        return true;
    }

    public static void checkAllowFormat(Configuration conf) throws IOException {
        if (!conf.getBoolean("dfs.namenode.support.allow.format", true)) {
            throw new IOException("The option dfs.namenode.support.allow.format is set to false for this filesystem, so it cannot be formatted. You will need to set dfs.namenode.support.allow.format parameter to true in order to format this filesystem");
        }
    }

    @VisibleForTesting
    public static boolean initializeSharedEdits(Configuration conf) {
        return NameNode.initializeSharedEdits(conf, true);
    }

    @VisibleForTesting
    public static boolean initializeSharedEdits(Configuration conf, boolean force) {
        return NameNode.initializeSharedEdits(conf, force, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean initializeSharedEdits(Configuration conf, boolean force, boolean interactive) {
        String nsId = DFSUtil.getNamenodeNameServiceId(conf);
        String namenodeId = HAUtil.getNameNodeId(conf, nsId);
        NameNode.initializeGenericKeys(conf, nsId, namenodeId);
        Storage existingStorage = null;
        try {
            FSNamesystem fsns = FSNamesystem.loadFromDisk(conf, FSNamesystem.getNamespaceDirs(conf), FSNamesystem.getNamespaceEditsDirs(conf, false));
            existingStorage = fsns.getFSImage().getStorage();
            List<URI> sharedEditsDirs = FSNamesystem.getSharedEditsDirs(conf);
            if (!NameNode.confirmFormat(sharedEditsDirs, force, interactive)) {
                boolean bl = true;
                return bl;
            }
            NNStorage newSharedStorage = new NNStorage(conf, Lists.newArrayList(), sharedEditsDirs);
            newSharedStorage.format(new NamespaceInfo(existingStorage.getNamespaceID(), existingStorage.getClusterID(), ((NNStorage)existingStorage).getBlockPoolID(), existingStorage.getCTime(), ((NNStorage)existingStorage).getDistributedUpgradeVersion()));
            fsns.getFSImage().getEditLog().close();
            fsns.getFSImage().getEditLog().initJournalsForWrite();
            fsns.getFSImage().getEditLog().recoverUnclosedStreams();
            if (NameNode.copyEditLogSegmentsToSharedDir(fsns, sharedEditsDirs, newSharedStorage, conf)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)"Could not initialize shared edits dir", (Throwable)ioe);
            boolean bl = true;
            return bl;
        }
        finally {
            if (existingStorage != null) {
                try {
                    existingStorage.unlockAll();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Could not unlock storage directories", (Throwable)ioe);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyEditLogSegmentsToSharedDir(FSNamesystem fsns, Collection<URI> sharedEditsDirs, NNStorage newSharedStorage, Configuration conf) throws FileNotFoundException, IOException {
        for (JournalSet.JournalAndStream jas : fsns.getFSImage().getEditLog().getJournals()) {
            FileJournalManager fjm = null;
            if (!(jas.getManager() instanceof FileJournalManager)) {
                LOG.error((Object)("Cannot populate shared edits dir from non-file journal manager: " + jas.getManager()));
                return true;
            }
            fjm = (FileJournalManager)jas.getManager();
            for (FileJournalManager.EditLogFile elf : fjm.getLogFiles(fsns.getFSImage().getMostRecentCheckpointTxId())) {
                File editLogSegment = elf.getFile();
                for (URI sharedEditsUri : sharedEditsDirs) {
                    Storage.StorageDirectory sharedEditsDir = newSharedStorage.getStorageDirectory(sharedEditsUri);
                    File targetFile = new File(sharedEditsDir.getCurrentDir(), editLogSegment.getName());
                    if (targetFile.exists()) continue;
                    FileInputStream in = null;
                    AtomicFileOutputStream out = null;
                    try {
                        in = new FileInputStream(editLogSegment);
                        out = new AtomicFileOutputStream(targetFile);
                        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)conf);
                    }
                    catch (Throwable throwable) {
                        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in, out});
                        throw throwable;
                    }
                    IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in, out});
                }
            }
        }
        return false;
    }

    private static boolean finalize(Configuration conf, boolean isConfirmationNeeded) throws IOException {
        String nsId = DFSUtil.getNamenodeNameServiceId(conf);
        String namenodeId = HAUtil.getNameNodeId(conf, nsId);
        NameNode.initializeGenericKeys(conf, nsId, namenodeId);
        FSNamesystem nsys = new FSNamesystem(conf, new FSImage(conf));
        System.err.print("\"finalize\" will remove the previous state of the files system.\nRecent upgrade will become permanent.\nRollback option will not be available anymore.\n");
        if (isConfirmationNeeded && !ToolRunner.confirmPrompt((String)"Finalize filesystem state?")) {
            System.err.println("Finalize aborted.");
            return true;
        }
        nsys.dir.fsImage.finalizeUpgrade();
        return false;
    }

    private static void printUsage() {
        System.err.println("Usage: java NameNode [" + HdfsServerConstants.StartupOption.BACKUP.getName() + "] | [" + HdfsServerConstants.StartupOption.CHECKPOINT.getName() + "] | [" + HdfsServerConstants.StartupOption.FORMAT.getName() + " [" + HdfsServerConstants.StartupOption.CLUSTERID.getName() + " cid ] [" + HdfsServerConstants.StartupOption.FORCE.getName() + "] [" + HdfsServerConstants.StartupOption.NONINTERACTIVE.getName() + "] ] | [" + HdfsServerConstants.StartupOption.UPGRADE.getName() + "] | [" + HdfsServerConstants.StartupOption.ROLLBACK.getName() + "] | [" + HdfsServerConstants.StartupOption.FINALIZE.getName() + "] | [" + HdfsServerConstants.StartupOption.IMPORT.getName() + "] | [" + HdfsServerConstants.StartupOption.INITIALIZESHAREDEDITS.getName() + "] | [" + HdfsServerConstants.StartupOption.BOOTSTRAPSTANDBY.getName() + "] | [" + HdfsServerConstants.StartupOption.RECOVER.getName() + " [ " + HdfsServerConstants.StartupOption.FORCE.getName() + " ] ]");
    }

    private static HdfsServerConstants.StartupOption parseArguments(String[] args) {
        int argsLen = args == null ? 0 : args.length;
        HdfsServerConstants.StartupOption startOpt = HdfsServerConstants.StartupOption.REGULAR;
        for (int i = 0; i < argsLen; ++i) {
            String cmd = args[i];
            if (HdfsServerConstants.StartupOption.FORMAT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.FORMAT;
                ++i;
                while (i < argsLen) {
                    if (args[i].equalsIgnoreCase(HdfsServerConstants.StartupOption.CLUSTERID.getName())) {
                        if (++i >= argsLen) {
                            LOG.fatal((Object)("Must specify a valid cluster ID after the " + HdfsServerConstants.StartupOption.CLUSTERID.getName() + " flag"));
                            return null;
                        }
                        String clusterId = args[i];
                        if (clusterId.isEmpty() || clusterId.equalsIgnoreCase(HdfsServerConstants.StartupOption.FORCE.getName()) || clusterId.equalsIgnoreCase(HdfsServerConstants.StartupOption.NONINTERACTIVE.getName())) {
                            LOG.fatal((Object)("Must specify a valid cluster ID after the " + HdfsServerConstants.StartupOption.CLUSTERID.getName() + " flag"));
                            return null;
                        }
                        startOpt.setClusterId(clusterId);
                    }
                    if (args[i].equalsIgnoreCase(HdfsServerConstants.StartupOption.FORCE.getName())) {
                        startOpt.setForceFormat(true);
                    }
                    if (args[i].equalsIgnoreCase(HdfsServerConstants.StartupOption.NONINTERACTIVE.getName())) {
                        startOpt.setInteractiveFormat(false);
                    }
                    ++i;
                }
                continue;
            }
            if (HdfsServerConstants.StartupOption.GENCLUSTERID.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.GENCLUSTERID;
                continue;
            }
            if (HdfsServerConstants.StartupOption.REGULAR.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.REGULAR;
                continue;
            }
            if (HdfsServerConstants.StartupOption.BACKUP.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.BACKUP;
                continue;
            }
            if (HdfsServerConstants.StartupOption.CHECKPOINT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.CHECKPOINT;
                continue;
            }
            if (HdfsServerConstants.StartupOption.UPGRADE.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.UPGRADE;
                if (i + 2 >= argsLen || !args[i + 1].equalsIgnoreCase(HdfsServerConstants.StartupOption.CLUSTERID.getName())) continue;
                startOpt.setClusterId(args[i += 2]);
                continue;
            }
            if (HdfsServerConstants.StartupOption.ROLLBACK.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.ROLLBACK;
                continue;
            }
            if (HdfsServerConstants.StartupOption.FINALIZE.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.FINALIZE;
                continue;
            }
            if (HdfsServerConstants.StartupOption.IMPORT.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.IMPORT;
                continue;
            }
            if (HdfsServerConstants.StartupOption.BOOTSTRAPSTANDBY.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.BOOTSTRAPSTANDBY;
                return startOpt;
            }
            if (HdfsServerConstants.StartupOption.INITIALIZESHAREDEDITS.getName().equalsIgnoreCase(cmd)) {
                startOpt = HdfsServerConstants.StartupOption.INITIALIZESHAREDEDITS;
                return startOpt;
            }
            if (HdfsServerConstants.StartupOption.RECOVER.getName().equalsIgnoreCase(cmd)) {
                if (startOpt != HdfsServerConstants.StartupOption.REGULAR) {
                    throw new RuntimeException("Can't combine -recover with other startup options.");
                }
                startOpt = HdfsServerConstants.StartupOption.RECOVER;
                while (++i < argsLen) {
                    if (args[i].equalsIgnoreCase(HdfsServerConstants.StartupOption.FORCE.getName())) {
                        startOpt.setForce(1);
                        continue;
                    }
                    throw new RuntimeException("Error parsing recovery options: can't understand option \"" + args[i] + "\"");
                }
                continue;
            }
            return null;
        }
        return startOpt;
    }

    private static void setStartupOption(Configuration conf, HdfsServerConstants.StartupOption opt) {
        conf.set("dfs.namenode.startup", opt.toString());
    }

    static HdfsServerConstants.StartupOption getStartupOption(Configuration conf) {
        return HdfsServerConstants.StartupOption.valueOf(conf.get("dfs.namenode.startup", HdfsServerConstants.StartupOption.REGULAR.toString()));
    }

    private static void doRecovery(HdfsServerConstants.StartupOption startOpt, Configuration conf) throws IOException {
        if (startOpt.getForce() < 2 && !ToolRunner.confirmPrompt((String)"You have selected Metadata Recovery mode.  This mode is intended to recover lost metadata on a corrupt filesystem.  Metadata recovery mode often permanently deletes data from your HDFS filesystem.  Please back up your edit log and fsimage before trying this!\n\nAre you ready to proceed? (Y/N)\n")) {
            System.err.println("Recovery aborted at user request.\n");
            return;
        }
        MetaRecoveryContext.LOG.info((Object)"starting recovery...");
        UserGroupInformation.setConfiguration((Configuration)conf);
        NameNode.initMetrics(conf, startOpt.toNodeRole());
        FSNamesystem fsn = null;
        try {
            fsn = FSNamesystem.loadFromDisk(conf);
            fsn.saveNamespace();
            MetaRecoveryContext.LOG.info((Object)"RECOVERY COMPLETE");
        }
        catch (IOException e) {
            MetaRecoveryContext.LOG.info((Object)"RECOVERY FAILED: caught exception", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            MetaRecoveryContext.LOG.info((Object)"RECOVERY FAILED: caught exception", (Throwable)e);
            throw e;
        }
        finally {
            if (fsn != null) {
                fsn.close();
            }
        }
    }

    public static NameNode createNameNode(String[] argv, Configuration conf) throws IOException {
        HdfsServerConstants.StartupOption startOpt;
        if (conf == null) {
            conf = new HdfsConfiguration();
        }
        if ((startOpt = NameNode.parseArguments(argv)) == null) {
            NameNode.printUsage();
            return null;
        }
        NameNode.setStartupOption(conf, startOpt);
        if (HAUtil.isHAEnabled(conf, DFSUtil.getNamenodeNameServiceId(conf)) && (startOpt == HdfsServerConstants.StartupOption.UPGRADE || startOpt == HdfsServerConstants.StartupOption.ROLLBACK || startOpt == HdfsServerConstants.StartupOption.FINALIZE)) {
            throw new HadoopIllegalArgumentException("Invalid startup option. Cannot perform DFS upgrade with HA enabled.");
        }
        switch (startOpt) {
            case FORMAT: {
                boolean aborted = NameNode.format(conf, startOpt.getForceFormat(), startOpt.getInteractiveFormat());
                System.exit(aborted ? 1 : 0);
                return null;
            }
            case GENCLUSTERID: {
                System.err.println("Generating new cluster id:");
                System.out.println(NNStorage.newClusterID());
                System.exit(0);
                return null;
            }
            case FINALIZE: {
                boolean aborted = NameNode.finalize(conf, true);
                System.exit(aborted ? 1 : 0);
                return null;
            }
            case BOOTSTRAPSTANDBY: {
                String[] toolArgs = Arrays.copyOfRange(argv, 1, argv.length);
                int rc = BootstrapStandby.run(toolArgs, conf);
                System.exit(rc);
                return null;
            }
            case INITIALIZESHAREDEDITS: {
                boolean aborted = NameNode.initializeSharedEdits(conf, false, true);
                System.exit(aborted ? 1 : 0);
                return null;
            }
            case BACKUP: 
            case CHECKPOINT: {
                HdfsServerConstants.NamenodeRole role = startOpt.toNodeRole();
                DefaultMetricsSystem.initialize((String)role.toString().replace(" ", ""));
                return new BackupNode(conf, role);
            }
            case RECOVER: {
                NameNode.doRecovery(startOpt, conf);
                return null;
            }
        }
        DefaultMetricsSystem.initialize((String)"NameNode");
        return new NameNode(conf);
    }

    public static void initializeGenericKeys(Configuration conf, String nameserviceId, String namenodeId) {
        if ((nameserviceId == null || nameserviceId.isEmpty()) && (namenodeId == null || namenodeId.isEmpty())) {
            return;
        }
        if (nameserviceId != null) {
            conf.set("dfs.federation.nameservice.id", nameserviceId);
        }
        if (namenodeId != null) {
            conf.set("dfs.ha.namenode.id", namenodeId);
        }
        DFSUtil.setGenericConf(conf, nameserviceId, namenodeId, NAMESERVICE_SPECIFIC_KEYS);
        if (conf.get("dfs.namenode.rpc-address") != null) {
            URI defaultUri = URI.create("hdfs://" + conf.get("dfs.namenode.rpc-address"));
            conf.set("fs.defaultFS", defaultUri.toString());
        }
    }

    protected String getNameServiceId(Configuration conf) {
        return DFSUtil.getNamenodeNameServiceId(conf);
    }

    public static void main(String[] argv) throws Exception {
        try {
            StringUtils.startupShutdownMessage(NameNode.class, (String[])argv, (Log)LOG);
            NameNode namenode = NameNode.createNameNode(argv, null);
            if (namenode != null) {
                namenode.join();
            }
        }
        catch (Throwable e) {
            LOG.error((Object)"Exception in namenode join", e);
            System.exit(-1);
        }
    }

    synchronized void monitorHealth() throws HealthCheckFailedException, AccessControlException {
        this.namesystem.checkSuperuserPrivilege();
        if (!this.haEnabled) {
            return;
        }
        this.getNamesystem().checkAvailableResources();
        if (!this.getNamesystem().nameNodeHasResourcesAvailable()) {
            throw new HealthCheckFailedException("The NameNode has no resources available");
        }
    }

    synchronized void transitionToActive() throws ServiceFailedException, AccessControlException {
        this.namesystem.checkSuperuserPrivilege();
        if (!this.haEnabled) {
            throw new ServiceFailedException("HA for namenode is not enabled");
        }
        this.state.setState(this.haContext, ACTIVE_STATE);
    }

    synchronized void transitionToStandby() throws ServiceFailedException, AccessControlException {
        this.namesystem.checkSuperuserPrivilege();
        if (!this.haEnabled) {
            throw new ServiceFailedException("HA for namenode is not enabled");
        }
        this.state.setState(this.haContext, STANDBY_STATE);
    }

    synchronized HAServiceStatus getServiceStatus() throws ServiceFailedException, AccessControlException {
        this.namesystem.checkSuperuserPrivilege();
        if (!this.haEnabled) {
            throw new ServiceFailedException("HA for namenode is not enabled");
        }
        if (this.state == null) {
            return new HAServiceStatus(HAServiceProtocol.HAServiceState.INITIALIZING);
        }
        HAServiceProtocol.HAServiceState retState = this.state.getServiceState();
        HAServiceStatus ret = new HAServiceStatus(retState);
        if (retState == HAServiceProtocol.HAServiceState.STANDBY) {
            String safemodeTip = this.namesystem.getSafeModeTip();
            if (!safemodeTip.isEmpty()) {
                ret.setNotReadyToBecomeActive("The NameNode is in safemode. " + safemodeTip);
            } else {
                ret.setReadyToBecomeActive();
            }
        } else if (retState == HAServiceProtocol.HAServiceState.ACTIVE) {
            ret.setReadyToBecomeActive();
        } else {
            ret.setNotReadyToBecomeActive("State is " + this.state);
        }
        return ret;
    }

    synchronized HAServiceProtocol.HAServiceState getServiceState() {
        if (this.state == null) {
            return HAServiceProtocol.HAServiceState.INITIALIZING;
        }
        return this.state.getServiceState();
    }

    public boolean isStandbyState() {
        return this.state.equals(STANDBY_STATE);
    }

    static {
        HdfsConfiguration.init();
        NAMESERVICE_SPECIFIC_KEYS = new String[]{"dfs.namenode.rpc-address", "dfs.namenode.name.dir", "dfs.namenode.edits.dir", "dfs.namenode.shared.edits.dir", "dfs.namenode.checkpoint.dir", "dfs.namenode.checkpoint.edits.dir", "dfs.namenode.servicerpc-address", "dfs.namenode.http-address", "dfs.namenode.https-address", "dfs.namenode.keytab.file", "dfs.namenode.secondary.http-address", "dfs.namenode.secondary.https-port", "dfs.secondary.namenode.keytab.file", "dfs.namenode.backup.address", "dfs.namenode.backup.http-address", "dfs.namenode.backup.dnrpc-address", "dfs.ha.fencing.methods", "dfs.namenode.kerberos.principal"};
        LOG = LogFactory.getLog((String)NameNode.class.getName());
        stateChangeLog = LogFactory.getLog((String)"org.apache.hadoop.hdfs.StateChange");
        ACTIVE_STATE = new ActiveState();
        STANDBY_STATE = new StandbyState();
    }

    protected class NameNodeHAContext
    implements HAContext {
        protected NameNodeHAContext() {
        }

        @Override
        public void setState(HAState s) {
            NameNode.this.state = s;
        }

        @Override
        public HAState getState() {
            return NameNode.this.state;
        }

        @Override
        public void startActiveServices() throws IOException {
            NameNode.this.namesystem.startActiveServices();
            NameNode.this.startTrashEmptier(NameNode.this.conf);
        }

        @Override
        public void stopActiveServices() throws IOException {
            if (NameNode.this.namesystem != null) {
                NameNode.this.namesystem.stopActiveServices();
            }
            NameNode.this.stopTrashEmptier();
        }

        @Override
        public void startStandbyServices() throws IOException {
            NameNode.this.namesystem.startStandbyServices(NameNode.this.conf);
        }

        @Override
        public void prepareToStopStandbyServices() throws ServiceFailedException {
            NameNode.this.namesystem.prepareToStopStandbyServices();
        }

        @Override
        public void stopStandbyServices() throws IOException {
            if (NameNode.this.namesystem != null) {
                NameNode.this.namesystem.stopStandbyServices();
            }
        }

        @Override
        public void writeLock() {
            NameNode.this.namesystem.writeLock();
        }

        @Override
        public void writeUnlock() {
            NameNode.this.namesystem.writeUnlock();
        }

        @Override
        public void checkOperation(OperationCategory op) throws StandbyException {
            NameNode.this.state.checkOperation(NameNode.this.haContext, op);
        }

        @Override
        public boolean allowStaleReads() {
            return NameNode.this.allowStaleStandbyReads;
        }
    }

    public static enum OperationCategory {
        UNCHECKED,
        READ,
        WRITE,
        CHECKPOINT,
        JOURNAL;

    }
}

