/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceStatus;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.tools.DFSHAAdmin;
import org.apache.hadoop.hdfs.tools.NNHAServiceTarget;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class BootstrapStandby
implements Tool,
Configurable {
    private static final Log LOG = LogFactory.getLog(BootstrapStandby.class);
    private String nsId;
    private String nnId;
    private String otherNNId;
    private String otherHttpAddr;
    private InetSocketAddress otherIpcAddr;
    private Collection<URI> dirsToFormat;
    private List<URI> editUrisToFormat;
    private List<URI> sharedEditsUris;
    private Configuration conf;
    private boolean force = false;
    private boolean interactive = true;
    static final int ERR_CODE_FAILED_CONNECT = 2;
    static final int ERR_CODE_INVALID_VERSION = 3;
    static final int ERR_CODE_OTHER_NN_NOT_ACTIVE = 4;
    static final int ERR_CODE_ALREADY_FORMATTED = 5;
    static final int ERR_CODE_LOGS_UNAVAILABLE = 6;

    public int run(String[] args) throws Exception {
        SecurityUtil.initKrb5CipherSuites();
        this.parseArgs(args);
        this.parseConfAndFindOtherNN();
        NameNode.checkAllowFormat(this.conf);
        InetSocketAddress myAddr = NameNode.getAddress(this.conf);
        SecurityUtil.login((Configuration)this.conf, (String)"dfs.namenode.keytab.file", (String)"dfs.namenode.kerberos.principal", (String)myAddr.getHostName());
        return (Integer)SecurityUtil.doAsLoginUserOrFatal((PrivilegedAction)new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                try {
                    return BootstrapStandby.this.doRun();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void parseArgs(String[] args) {
        for (String arg : args) {
            if ("-force".equals(arg)) {
                this.force = true;
                continue;
            }
            if ("-nonInteractive".equals(arg)) {
                this.interactive = false;
                continue;
            }
            this.printUsage();
            throw new HadoopIllegalArgumentException("Illegal argument: " + arg);
        }
    }

    private void printUsage() {
        System.err.println("Usage: " + this.getClass().getSimpleName() + "[-force] [-nonInteractive]");
    }

    private NamenodeProtocol createNNProtocolProxy() throws IOException {
        return NameNodeProxies.createNonHAProxy(this.getConf(), this.otherIpcAddr, NamenodeProtocol.class, UserGroupInformation.getLoginUser(), true).getProxy();
    }

    private HAServiceProtocol createHAProtocolProxy() throws IOException {
        return new NNHAServiceTarget(new HdfsConfiguration(this.conf), this.nsId, this.otherNNId).getProxy(this.conf, 15000);
    }

    private int doRun() throws IOException {
        NamespaceInfo nsInfo;
        NamenodeProtocol proxy = this.createNNProtocolProxy();
        try {
            nsInfo = proxy.versionRequest();
        }
        catch (IOException ioe) {
            LOG.fatal((Object)("Unable to fetch namespace information from active NN at " + this.otherIpcAddr + ": " + ioe.getMessage()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Full exception trace", (Throwable)ioe);
            }
            return 2;
        }
        if (!this.checkLayoutVersion(nsInfo)) {
            LOG.fatal((Object)("Layout version on remote node (" + nsInfo.getLayoutVersion() + ") does not match " + "this node's layout version (" + HdfsConstants.LAYOUT_VERSION + ")"));
            return 3;
        }
        System.out.println("=====================================================\nAbout to bootstrap Standby ID " + this.nnId + " from:\n" + "           Nameservice ID: " + this.nsId + "\n" + "        Other Namenode ID: " + this.otherNNId + "\n" + "  Other NN's HTTP address: " + this.otherHttpAddr + "\n" + "  Other NN's IPC  address: " + this.otherIpcAddr + "\n" + "             Namespace ID: " + nsInfo.getNamespaceID() + "\n" + "            Block pool ID: " + nsInfo.getBlockPoolID() + "\n" + "               Cluster ID: " + nsInfo.getClusterID() + "\n" + "           Layout version: " + nsInfo.getLayoutVersion() + "\n" + "=====================================================");
        if (!this.isOtherNNActive()) {
            String err = "NameNode " + this.nsId + "." + this.nnId + " at " + this.otherIpcAddr + " is not currently in ACTIVE state.";
            if (!this.interactive) {
                LOG.fatal((Object)(err + " Please transition it to " + "active before attempting to bootstrap a standby node."));
                return 4;
            }
            System.err.println(err);
            if (ToolRunner.confirmPrompt((String)"Do you want to automatically transition it to active now?")) {
                this.transitionOtherNNActive();
            } else {
                LOG.fatal((Object)"User aborted. Exiting without bootstrapping standby.");
                return 4;
            }
        }
        if (!NameNode.confirmFormat((Collection<URI>)Sets.union((Set)Sets.newHashSet(this.dirsToFormat), (Set)Sets.newHashSet(this.editUrisToFormat)), this.force, this.interactive)) {
            return 5;
        }
        CheckpointSignature csig = proxy.rollEditLog();
        long imageTxId = csig.getMostRecentCheckpointTxId();
        long rollTxId = csig.getCurSegmentTxId();
        NNStorage storage = new NNStorage(this.conf, this.dirsToFormat, this.editUrisToFormat);
        storage.format(nsInfo);
        FSImage image = new FSImage(this.conf);
        assert (image.getEditLog().isOpenForRead()) : "Expected edit log to be open for read";
        if (!this.checkLogsAvailableForRead(image, imageTxId, rollTxId)) {
            return 6;
        }
        image.getStorage().writeTransactionIdFileToStorage(rollTxId);
        MD5Hash hash = TransferFsImage.downloadImageToStorage(this.otherHttpAddr.toString(), imageTxId, storage, true);
        image.saveDigestAndRenameCheckpointImage(imageTxId, hash);
        return 0;
    }

    private void transitionOtherNNActive() throws AccessControlException, ServiceFailedException, IOException {
        LOG.info((Object)"Transitioning the running namenode to active...");
        this.createHAProtocolProxy().transitionToActive();
        LOG.info((Object)"Successful");
    }

    private boolean checkLogsAvailableForRead(FSImage image, long imageTxId, long rollTxId) {
        long firstTxIdInLogs = imageTxId + 1L;
        long lastTxIdInLogs = rollTxId - 1L;
        assert (lastTxIdInLogs >= firstTxIdInLogs);
        try {
            Collection<EditLogInputStream> streams = image.getEditLog().selectInputStreams(firstTxIdInLogs, lastTxIdInLogs, false);
            for (EditLogInputStream stream : streams) {
                IOUtils.closeStream((Closeable)stream);
            }
            return true;
        }
        catch (IOException e) {
            String msg = "Unable to read transaction ids " + firstTxIdInLogs + "-" + lastTxIdInLogs + " from the configured shared edits storage " + Joiner.on((String)",").join(this.sharedEditsUris) + ". " + "Please copy these logs into the shared edits storage " + "or call saveNamespace on the active node.\n" + "Error: " + e.getLocalizedMessage();
            if (LOG.isDebugEnabled()) {
                LOG.fatal((Object)msg, (Throwable)e);
            } else {
                LOG.fatal((Object)msg);
            }
            return false;
        }
    }

    private boolean checkLayoutVersion(NamespaceInfo nsInfo) throws IOException {
        return nsInfo.getLayoutVersion() == HdfsConstants.LAYOUT_VERSION;
    }

    private boolean isOtherNNActive() throws AccessControlException, IOException {
        HAServiceStatus status = this.createHAProtocolProxy().getServiceStatus();
        return status.getState() == HAServiceProtocol.HAServiceState.ACTIVE;
    }

    private void parseConfAndFindOtherNN() throws IOException {
        Configuration conf = this.getConf();
        this.nsId = DFSUtil.getNamenodeNameServiceId(conf);
        if (!HAUtil.isHAEnabled(conf, this.nsId)) {
            throw new HadoopIllegalArgumentException("HA is not enabled for this namenode.");
        }
        this.nnId = HAUtil.getNameNodeId(conf, this.nsId);
        NameNode.initializeGenericKeys(conf, this.nsId, this.nnId);
        if (!HAUtil.usesSharedEditsDir(conf)) {
            throw new HadoopIllegalArgumentException("Shared edits storage is not enabled for this namenode.");
        }
        Configuration otherNode = HAUtil.getConfForOtherNode(conf);
        this.otherNNId = HAUtil.getNameNodeId(otherNode, this.nsId);
        this.otherIpcAddr = NameNode.getServiceAddress(otherNode, true);
        Preconditions.checkArgument((this.otherIpcAddr.getPort() != 0 && !this.otherIpcAddr.getAddress().isAnyLocalAddress() ? 1 : 0) != 0, (String)"Could not determine valid IPC address for other NameNode (%s), got: %s", (Object[])new Object[]{this.otherNNId, this.otherIpcAddr});
        this.otherHttpAddr = DFSUtil.getInfoServer(null, otherNode, true);
        this.otherHttpAddr = DFSUtil.substituteForWildcardAddress(this.otherHttpAddr, this.otherIpcAddr.getHostName());
        this.dirsToFormat = FSNamesystem.getNamespaceDirs(conf);
        this.editUrisToFormat = FSNamesystem.getNamespaceEditsDirs(conf, false);
        this.sharedEditsUris = FSNamesystem.getSharedEditsDirs(conf);
    }

    public void setConf(Configuration conf) {
        this.conf = DFSHAAdmin.addSecurityConfiguration(conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public static int run(String[] argv, Configuration conf) throws IOException {
        BootstrapStandby bs = new BootstrapStandby();
        bs.setConf(conf);
        try {
            return ToolRunner.run((Tool)bs, (String[])argv);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }
}

