/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.BlockingService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public class DFSUtil {
    public static final Log LOG = LogFactory.getLog((String)DFSUtil.class.getName());
    private static final ThreadLocal<Random> RANDOM = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    private static final ThreadLocal<SecureRandom> SECURE_RANDOM = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return new SecureRandom();
        }
    };
    public static final Comparator<DatanodeInfo> DECOM_COMPARATOR = new Comparator<DatanodeInfo>(){

        @Override
        public int compare(DatanodeInfo a, DatanodeInfo b) {
            return a.isDecommissioned() == b.isDecommissioned() ? 0 : (a.isDecommissioned() ? 1 : -1);
        }
    };
    static final AddressMatcher LOCAL_ADDRESS_MATCHER = new AddressMatcher(){

        @Override
        public boolean match(InetSocketAddress s) {
            return NetUtils.isLocalAddress((InetAddress)s.getAddress());
        }
    };

    private DFSUtil() {
    }

    public static Random getRandom() {
        return RANDOM.get();
    }

    public static SecureRandom getSecureRandom() {
        return SECURE_RANDOM.get();
    }

    public static boolean isValidName(String src) {
        if (!src.startsWith("/")) {
            return false;
        }
        StringTokenizer tokens = new StringTokenizer(src, "/");
        while (tokens.hasMoreTokens()) {
            String element = tokens.nextToken();
            if (!element.equals("..") && !element.equals(".") && element.indexOf(":") < 0 && element.indexOf("/") < 0) continue;
            return false;
        }
        return true;
    }

    public static String bytes2String(byte[] bytes) {
        try {
            return new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    public static byte[] string2Bytes(String str) {
        try {
            return str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    public static String byteArray2String(byte[][] pathComponents) {
        if (pathComponents.length == 0) {
            return "";
        }
        if (pathComponents.length == 1 && pathComponents[0].length == 0) {
            return "/";
        }
        try {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < pathComponents.length; ++i) {
                result.append(new String(pathComponents[i], "UTF-8"));
                if (i >= pathComponents.length - 1) continue;
                result.append('/');
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException ex) {
            assert (false) : "UTF8 encoding is not supported ";
            return null;
        }
    }

    public static byte[][] bytes2byteArray(byte[] bytes, byte separator) {
        return DFSUtil.bytes2byteArray(bytes, bytes.length, separator);
    }

    public static byte[][] bytes2byteArray(byte[] bytes, int len, byte separator) {
        assert (len <= bytes.length);
        int splits = 0;
        if (len == 0) {
            return new byte[][]{null};
        }
        for (int i = 0; i < len; ++i) {
            if (bytes[i] != separator) continue;
            ++splits;
        }
        int last = len - 1;
        while (last > -1 && bytes[last--] == separator) {
            --splits;
        }
        if (splits == 0 && bytes[0] == separator) {
            return new byte[][]{null};
        }
        byte[][] result = new byte[++splits][];
        int startIndex = 0;
        int nextIndex = 0;
        for (int index = 0; index < splits; ++index) {
            while (nextIndex < len && bytes[nextIndex] != separator) {
                ++nextIndex;
            }
            result[index] = new byte[nextIndex - startIndex];
            System.arraycopy(bytes, startIndex, result[index], 0, nextIndex - startIndex);
            nextIndex = startIndex = nextIndex + 1;
        }
        return result;
    }

    public static BlockLocation[] locatedBlocks2Locations(LocatedBlocks blocks) {
        if (blocks == null) {
            return new BlockLocation[0];
        }
        int nrBlocks = blocks.locatedBlockCount();
        BlockLocation[] blkLocations = new BlockLocation[nrBlocks];
        if (nrBlocks == 0) {
            return blkLocations;
        }
        int idx = 0;
        for (LocatedBlock blk : blocks.getLocatedBlocks()) {
            assert (idx < nrBlocks) : "Incorrect index";
            DatanodeInfo[] locations = blk.getLocations();
            String[] hosts = new String[locations.length];
            String[] xferAddrs = new String[locations.length];
            String[] racks = new String[locations.length];
            for (int hCnt = 0; hCnt < locations.length; ++hCnt) {
                hosts[hCnt] = locations[hCnt].getHostName();
                xferAddrs[hCnt] = locations[hCnt].getXferAddr();
                NodeBase node = new NodeBase(xferAddrs[hCnt], locations[hCnt].getNetworkLocation());
                racks[hCnt] = node.toString();
            }
            blkLocations[idx] = new BlockLocation(xferAddrs, hosts, racks, blk.getStartOffset(), blk.getBlockSize(), blk.isCorrupt());
            ++idx;
        }
        return blkLocations;
    }

    public static Collection<String> getNameServiceIds(Configuration conf) {
        return conf.getTrimmedStringCollection("dfs.federation.nameservices");
    }

    private static Collection<String> emptyAsSingletonNull(Collection<String> coll) {
        if (coll == null || coll.isEmpty()) {
            return Collections.singletonList(null);
        }
        return coll;
    }

    public static Collection<String> getNameNodeIds(Configuration conf, String nsId) {
        String key = DFSUtil.addSuffix("dfs.ha.namenodes", nsId);
        return conf.getTrimmedStringCollection(key);
    }

    private static String getConfValue(String defaultValue, String keySuffix, Configuration conf, String ... keys) {
        String value = null;
        for (String key : keys) {
            value = conf.get(key = DFSUtil.addSuffix(key, keySuffix));
            if (value != null) break;
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private static String addSuffix(String key, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return key;
        }
        assert (!suffix.startsWith(".")) : "suffix '" + suffix + "' should not already have '.' prepended.";
        return key + "." + suffix;
    }

    private static String concatSuffixes(String ... suffixes) {
        if (suffixes == null) {
            return null;
        }
        return Joiner.on((String)".").skipNulls().join((Object[])suffixes);
    }

    public static String addKeySuffixes(String key, String ... suffixes) {
        String keySuffix = DFSUtil.concatSuffixes(suffixes);
        return DFSUtil.addSuffix(key, keySuffix);
    }

    private static Map<String, Map<String, InetSocketAddress>> getAddresses(Configuration conf, String defaultAddress, String ... keys) {
        Collection<String> nameserviceIds = DFSUtil.getNameServiceIds(conf);
        HashMap ret = Maps.newHashMap();
        for (String nsId : DFSUtil.emptyAsSingletonNull(nameserviceIds)) {
            Map<String, InetSocketAddress> isas = DFSUtil.getAddressesForNameserviceId(conf, nsId, defaultAddress, keys);
            if (isas.isEmpty()) continue;
            ret.put(nsId, isas);
        }
        return ret;
    }

    private static Map<String, InetSocketAddress> getAddressesForNameserviceId(Configuration conf, String nsId, String defaultValue, String[] keys) {
        Collection<String> nnIds = DFSUtil.getNameNodeIds(conf, nsId);
        HashMap ret = Maps.newHashMap();
        for (String nnId : DFSUtil.emptyAsSingletonNull(nnIds)) {
            String suffix = DFSUtil.concatSuffixes(nsId, nnId);
            String address = DFSUtil.getConfValue(defaultValue, suffix, conf, keys);
            if (address == null) continue;
            InetSocketAddress isa = NetUtils.createSocketAddr((String)address);
            ret.put(nnId, isa);
        }
        return ret;
    }

    public static Map<String, Map<String, InetSocketAddress>> getHaNnRpcAddresses(Configuration conf) {
        return DFSUtil.getAddresses(conf, null, "dfs.namenode.rpc-address");
    }

    public static Map<String, Map<String, InetSocketAddress>> getBackupNodeAddresses(Configuration conf) throws IOException {
        Map<String, Map<String, InetSocketAddress>> addressList = DFSUtil.getAddresses(conf, null, "dfs.namenode.backup.address");
        if (addressList.isEmpty()) {
            throw new IOException("Incorrect configuration: backup node address dfs.namenode.backup.address is not configured.");
        }
        return addressList;
    }

    public static Map<String, Map<String, InetSocketAddress>> getSecondaryNameNodeAddresses(Configuration conf) throws IOException {
        Map<String, Map<String, InetSocketAddress>> addressList = DFSUtil.getAddresses(conf, null, "dfs.namenode.secondary.http-address");
        if (addressList.isEmpty()) {
            throw new IOException("Incorrect configuration: secondary namenode address dfs.namenode.secondary.http-address is not configured.");
        }
        return addressList;
    }

    public static Map<String, Map<String, InetSocketAddress>> getNNServiceRpcAddresses(Configuration conf) throws IOException {
        String defaultAddress;
        try {
            defaultAddress = NetUtils.getHostPortString((InetSocketAddress)NameNode.getAddress(conf));
        }
        catch (IllegalArgumentException e) {
            defaultAddress = null;
        }
        Map<String, Map<String, InetSocketAddress>> addressList = DFSUtil.getAddresses(conf, defaultAddress, "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
        if (addressList.isEmpty()) {
            throw new IOException("Incorrect configuration: namenode address dfs.namenode.servicerpc-address or dfs.namenode.rpc-address is not configured.");
        }
        return addressList;
    }

    public static List<ConfiguredNNAddress> flattenAddressMap(Map<String, Map<String, InetSocketAddress>> map) {
        ArrayList ret = Lists.newArrayList();
        for (Map.Entry<String, Map<String, InetSocketAddress>> entry : map.entrySet()) {
            String nsId = entry.getKey();
            Map<String, InetSocketAddress> nnMap = entry.getValue();
            for (Map.Entry<String, InetSocketAddress> e2 : nnMap.entrySet()) {
                String nnId = e2.getKey();
                InetSocketAddress addr = e2.getValue();
                ret.add(new ConfiguredNNAddress(nsId, nnId, addr));
            }
        }
        return ret;
    }

    public static String addressMapToString(Map<String, Map<String, InetSocketAddress>> map) {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, Map<String, InetSocketAddress>> entry : map.entrySet()) {
            String nsId = entry.getKey();
            Map<String, InetSocketAddress> nnMap = entry.getValue();
            b.append("Nameservice <").append(nsId).append(">:").append("\n");
            for (Map.Entry<String, InetSocketAddress> e2 : nnMap.entrySet()) {
                b.append("  NN ID ").append(e2.getKey()).append(" => ").append(e2.getValue()).append("\n");
            }
        }
        return b.toString();
    }

    public static String nnAddressesAsString(Configuration conf) {
        Map<String, Map<String, InetSocketAddress>> addresses = DFSUtil.getHaNnRpcAddresses(conf);
        return DFSUtil.addressMapToString(addresses);
    }

    public static Collection<URI> getNsServiceRpcUris(Configuration conf) {
        return DFSUtil.getNameServiceUris(conf, "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address");
    }

    public static Collection<URI> getNameServiceUris(Configuration conf, String ... keys) {
        HashSet<URI> ret = new HashSet<URI>();
        HashSet<URI> nonPreferredUris = new HashSet<URI>();
        for (String nsId : DFSUtil.getNameServiceIds(conf)) {
            if (HAUtil.isHAEnabled(conf, nsId)) {
                try {
                    ret.add(new URI("hdfs://" + nsId));
                    continue;
                }
                catch (URISyntaxException ue) {
                    throw new IllegalArgumentException(ue);
                }
            }
            boolean uriFound = false;
            for (String key : keys) {
                String addr = conf.get(DFSUtil.concatSuffixes(key, nsId));
                if (addr == null) continue;
                URI uri = DFSUtil.createUri("hdfs", NetUtils.createSocketAddr((String)addr));
                if (!uriFound) {
                    uriFound = true;
                    ret.add(uri);
                    continue;
                }
                nonPreferredUris.add(uri);
            }
        }
        boolean uriFound = false;
        for (String key : keys) {
            String addr = conf.get(key);
            if (addr == null) continue;
            URI uri = DFSUtil.createUri("hdfs", NetUtils.createSocketAddr((String)addr));
            if (!uriFound) {
                uriFound = true;
                ret.add(uri);
                continue;
            }
            nonPreferredUris.add(uri);
        }
        URI defaultUri = FileSystem.getDefaultUri((Configuration)conf);
        if (defaultUri != null && "hdfs".equals(defaultUri.getScheme()) && !nonPreferredUris.contains(defaultUri)) {
            ret.add(defaultUri);
        }
        return ret;
    }

    public static String getNameServiceIdFromAddress(Configuration conf, InetSocketAddress address, String ... keys) {
        String[] ids = DFSUtil.getSuffixIDs(conf, address, keys);
        return ids != null ? ids[0] : null;
    }

    public static String getInfoServer(InetSocketAddress namenodeAddr, Configuration conf, boolean httpsAddress) {
        boolean securityOn = UserGroupInformation.isSecurityEnabled();
        String httpAddressKey = securityOn && httpsAddress ? "dfs.namenode.https-address" : "dfs.namenode.http-address";
        String httpAddressDefault = securityOn && httpsAddress ? "0.0.0.0:50470" : "0.0.0.0:50070";
        String[] suffixes = namenodeAddr != null ? DFSUtil.getSuffixIDs(conf, namenodeAddr, "dfs.namenode.servicerpc-address", "dfs.namenode.rpc-address") : new String[2];
        return DFSUtil.getSuffixedConf(conf, httpAddressKey, httpAddressDefault, suffixes);
    }

    public static String substituteForWildcardAddress(String configuredAddress, String defaultHost) throws IOException {
        InetSocketAddress sockAddr = NetUtils.createSocketAddr((String)configuredAddress);
        InetSocketAddress defaultSockAddr = NetUtils.createSocketAddr((String)(defaultHost + ":0"));
        if (sockAddr.getAddress().isAnyLocalAddress()) {
            if (UserGroupInformation.isSecurityEnabled() && defaultSockAddr.getAddress().isAnyLocalAddress()) {
                throw new IOException("Cannot use a wildcard address with security. Must explicitly set bind address for Kerberos");
            }
            return defaultHost + ":" + sockAddr.getPort();
        }
        return configuredAddress;
    }

    private static String getSuffixedConf(Configuration conf, String key, String defaultVal, String[] suffixes) {
        String ret = conf.get(DFSUtil.addKeySuffixes(key, suffixes));
        if (ret != null) {
            return ret;
        }
        return conf.get(key, defaultVal);
    }

    public static void setGenericConf(Configuration conf, String nameserviceId, String nnId, String ... keys) {
        for (String key : keys) {
            String value = conf.get(DFSUtil.addKeySuffixes(key, nameserviceId, nnId));
            if (value != null) {
                conf.set(key, value);
                continue;
            }
            value = conf.get(DFSUtil.addKeySuffixes(key, nameserviceId));
            if (value == null) continue;
            conf.set(key, value);
        }
    }

    public static float getPercentUsed(long used, long capacity) {
        return capacity <= 0L ? 100.0f : (float)used * 100.0f / (float)capacity;
    }

    public static float getPercentRemaining(long remaining, long capacity) {
        return capacity <= 0L ? 0.0f : (float)remaining * 100.0f / (float)capacity;
    }

    public static int roundBytesToGB(long bytes) {
        return Math.round((float)bytes / 1024.0f / 1024.0f / 1024.0f);
    }

    public static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf, int socketTimeout, LocatedBlock locatedBlock) throws IOException {
        return new ClientDatanodeProtocolTranslatorPB(datanodeid, conf, socketTimeout, locatedBlock);
    }

    static ClientDatanodeProtocol createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf, int socketTimeout) throws IOException {
        return new ClientDatanodeProtocolTranslatorPB(datanodeid, conf, socketTimeout);
    }

    public static ClientDatanodeProtocol createClientDatanodeProtocolProxy(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        return new ClientDatanodeProtocolTranslatorPB(addr, ticket, conf, factory);
    }

    public static String getNamenodeNameServiceId(Configuration conf) {
        return DFSUtil.getNameServiceId(conf, "dfs.namenode.rpc-address");
    }

    public static String getBackupNameServiceId(Configuration conf) {
        return DFSUtil.getNameServiceId(conf, "dfs.namenode.backup.address");
    }

    public static String getSecondaryNameServiceId(Configuration conf) {
        return DFSUtil.getNameServiceId(conf, "dfs.namenode.secondary.http-address");
    }

    private static String getNameServiceId(Configuration conf, String addressKey) {
        String nameserviceId = conf.get("dfs.federation.nameservice.id");
        if (nameserviceId != null) {
            return nameserviceId;
        }
        Collection<String> nsIds = DFSUtil.getNameServiceIds(conf);
        if (1 == nsIds.size()) {
            return nsIds.toArray(new String[1])[0];
        }
        String nnId = conf.get("dfs.ha.namenode.id");
        return DFSUtil.getSuffixIDs(conf, addressKey, null, nnId, LOCAL_ADDRESS_MATCHER)[0];
    }

    static String[] getSuffixIDs(Configuration conf, String addressKey, String knownNsId, String knownNNId, AddressMatcher matcher) {
        String nameserviceId = null;
        String namenodeId = null;
        int found = 0;
        Collection<String> nsIds = DFSUtil.getNameServiceIds(conf);
        for (String nsId : DFSUtil.emptyAsSingletonNull(nsIds)) {
            if (knownNsId != null && !knownNsId.equals(nsId)) continue;
            Collection<String> nnIds = DFSUtil.getNameNodeIds(conf, nsId);
            for (String nnId : DFSUtil.emptyAsSingletonNull(nnIds)) {
                String key;
                String addr;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)String.format("addressKey: %s nsId: %s nnId: %s", addressKey, nsId, nnId));
                }
                if (knownNNId != null && !knownNNId.equals(nnId) || (addr = conf.get(key = DFSUtil.addKeySuffixes(addressKey, nsId, nnId))) == null) continue;
                InetSocketAddress s = null;
                try {
                    s = NetUtils.createSocketAddr((String)addr);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Exception in creating socket address " + addr), (Throwable)e);
                    continue;
                }
                if (s.isUnresolved() || !matcher.match(s)) continue;
                nameserviceId = nsId;
                namenodeId = nnId;
                ++found;
            }
        }
        if (found > 1) {
            String msg = "Configuration has multiple addresses that match local node's address. Please configure the system with dfs.federation.nameservice.id and dfs.ha.namenode.id";
            throw new HadoopIllegalArgumentException(msg);
        }
        return new String[]{nameserviceId, namenodeId};
    }

    static String[] getSuffixIDs(Configuration conf, final InetSocketAddress address, String ... keys) {
        AddressMatcher matcher = new AddressMatcher(){

            @Override
            public boolean match(InetSocketAddress s) {
                return address.equals(s);
            }
        };
        for (String key : keys) {
            String[] ids = DFSUtil.getSuffixIDs(conf, key, null, null, matcher);
            if (ids == null || ids[0] == null && ids[1] == null) continue;
            return ids;
        }
        return null;
    }

    public static URI createUri(String scheme, InetSocketAddress address) {
        try {
            return new URI(scheme, null, address.getHostName(), address.getPort(), null, null, null);
        }
        catch (URISyntaxException ue) {
            throw new IllegalArgumentException(ue);
        }
    }

    public static void addPBProtocol(Configuration conf, Class<?> protocol, BlockingService service, RPC.Server server) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, protocol, ProtobufRpcEngine.class);
        server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, protocol, (Object)service);
    }

    public static String getNamenodeServiceAddr(Configuration conf, String nsId, String nnId) {
        if (nsId == null) {
            nsId = DFSUtil.getOnlyNameServiceIdOrNull(conf);
        }
        String serviceAddrKey = DFSUtil.concatSuffixes("dfs.namenode.servicerpc-address", nsId, nnId);
        String addrKey = DFSUtil.concatSuffixes("dfs.namenode.rpc-address", nsId, nnId);
        String serviceRpcAddr = conf.get(serviceAddrKey);
        if (serviceRpcAddr == null) {
            serviceRpcAddr = conf.get(addrKey);
        }
        return serviceRpcAddr;
    }

    public static String getOnlyNameServiceIdOrNull(Configuration conf) {
        Collection<String> nsIds = DFSUtil.getNameServiceIds(conf);
        if (1 == nsIds.size()) {
            return nsIds.toArray(new String[1])[0];
        }
        return null;
    }

    private static interface AddressMatcher {
        public boolean match(InetSocketAddress var1);
    }

    public static class ConfiguredNNAddress {
        private final String nameserviceId;
        private final String namenodeId;
        private final InetSocketAddress addr;

        private ConfiguredNNAddress(String nameserviceId, String namenodeId, InetSocketAddress addr) {
            this.nameserviceId = nameserviceId;
            this.namenodeId = namenodeId;
            this.addr = addr;
        }

        public String getNameserviceId() {
            return this.nameserviceId;
        }

        public String getNamenodeId() {
            return this.namenodeId;
        }

        public InetSocketAddress getAddress() {
            return this.addr;
        }

        public String toString() {
            return "ConfiguredNNAddress[nsId=" + this.nameserviceId + ";" + "nnId=" + this.namenodeId + ";addr=" + this.addr + "]";
        }
    }
}

