/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.NamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class NamenodeProtocolTranslatorPB
implements NamenodeProtocol,
ProtocolMetaInterface,
Closeable {
    private static final RpcController NULL_CONTROLLER = null;
    private static final NamenodeProtocolProtos.GetBlockKeysRequestProto GET_BLOCKKEYS = NamenodeProtocolProtos.GetBlockKeysRequestProto.newBuilder().build();
    private static final NamenodeProtocolProtos.GetTransactionIdRequestProto GET_TRANSACTIONID = NamenodeProtocolProtos.GetTransactionIdRequestProto.newBuilder().build();
    private static final NamenodeProtocolProtos.RollEditLogRequestProto ROLL_EDITLOG = NamenodeProtocolProtos.RollEditLogRequestProto.newBuilder().build();
    private static final HdfsProtos.VersionRequestProto VERSION_REQUEST = HdfsProtos.VersionRequestProto.newBuilder().build();
    private final NamenodeProtocolPB rpcProxy;

    public NamenodeProtocolTranslatorPB(NamenodeProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    @Override
    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size) throws IOException {
        NamenodeProtocolProtos.GetBlocksRequestProto req = NamenodeProtocolProtos.GetBlocksRequestProto.newBuilder().setDatanode(PBHelper.convert((DatanodeID)datanode)).setSize(size).build();
        try {
            return PBHelper.convert(this.rpcProxy.getBlocks(NULL_CONTROLLER, req).getBlocks());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public ExportedBlockKeys getBlockKeys() throws IOException {
        try {
            return PBHelper.convert(this.rpcProxy.getBlockKeys(NULL_CONTROLLER, GET_BLOCKKEYS).getKeys());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public long getTransactionID() throws IOException {
        try {
            return this.rpcProxy.getTransactionId(NULL_CONTROLLER, GET_TRANSACTIONID).getTxId();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public CheckpointSignature rollEditLog() throws IOException {
        try {
            return PBHelper.convert(this.rpcProxy.rollEditLog(NULL_CONTROLLER, ROLL_EDITLOG).getSignature());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public NamespaceInfo versionRequest() throws IOException {
        try {
            return PBHelper.convert(this.rpcProxy.versionRequest(NULL_CONTROLLER, VERSION_REQUEST).getInfo());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void errorReport(NamenodeRegistration registration, int errorCode, String msg) throws IOException {
        NamenodeProtocolProtos.ErrorReportRequestProto req = NamenodeProtocolProtos.ErrorReportRequestProto.newBuilder().setErrorCode(errorCode).setMsg(msg).setRegistration(PBHelper.convert(registration)).build();
        try {
            this.rpcProxy.errorReport(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public NamenodeRegistration register(NamenodeRegistration registration) throws IOException {
        NamenodeProtocolProtos.RegisterRequestProto req = NamenodeProtocolProtos.RegisterRequestProto.newBuilder().setRegistration(PBHelper.convert(registration)).build();
        try {
            return PBHelper.convert(this.rpcProxy.register(NULL_CONTROLLER, req).getRegistration());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public NamenodeCommand startCheckpoint(NamenodeRegistration registration) throws IOException {
        HdfsProtos.NamenodeCommandProto cmd;
        NamenodeProtocolProtos.StartCheckpointRequestProto req = NamenodeProtocolProtos.StartCheckpointRequestProto.newBuilder().setRegistration(PBHelper.convert(registration)).build();
        try {
            cmd = this.rpcProxy.startCheckpoint(NULL_CONTROLLER, req).getCommand();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
        return PBHelper.convert(cmd);
    }

    @Override
    public void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        NamenodeProtocolProtos.EndCheckpointRequestProto req = NamenodeProtocolProtos.EndCheckpointRequestProto.newBuilder().setRegistration(PBHelper.convert(registration)).setSignature(PBHelper.convert(sig)).build();
        try {
            this.rpcProxy.endCheckpoint(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public RemoteEditLogManifest getEditLogManifest(long sinceTxId) throws IOException {
        NamenodeProtocolProtos.GetEditLogManifestRequestProto req = NamenodeProtocolProtos.GetEditLogManifestRequestProto.newBuilder().setSinceTxId(sinceTxId).build();
        try {
            return PBHelper.convert(this.rpcProxy.getEditLogManifest(NULL_CONTROLLER, req).getManifest());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported((Object)this.rpcProxy, NamenodeProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(NamenodeProtocolPB.class), (String)methodName);
    }
}

