/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormat;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.snapshot.AbstractINodeDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.AbstractINodeDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectoryWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.util.Diff;
import org.apache.hadoop.hdfs.util.ReadOnlyList;

public class SnapshotFSImageFormat {
    public static void saveSnapshots(INodeDirectorySnapshottable current, DataOutput out) throws IOException {
        ReadOnlyList<Snapshot> snapshots = current.getSnapshotsByNames();
        out.writeInt(snapshots.size());
        for (Snapshot s : snapshots) {
            out.writeInt(s.getId());
        }
        out.writeInt(current.getSnapshotQuota());
    }

    private static <N extends INode, D extends AbstractINodeDiff<N, D>> void saveINodeDiffs(AbstractINodeDiffList<N, D> diffs, DataOutput out, ReferenceMap referenceMap) throws IOException {
        if (diffs == null) {
            out.writeInt(-1);
        } else {
            List<D> list = diffs.asList();
            int size = list.size();
            out.writeInt(size);
            for (int i = size - 1; i >= 0; --i) {
                ((AbstractINodeDiff)list.get(i)).write(out, referenceMap);
            }
        }
    }

    public static void saveDirectoryDiffList(INodeDirectory dir, DataOutput out, ReferenceMap referenceMap) throws IOException {
        SnapshotFSImageFormat.saveINodeDiffs(dir instanceof INodeDirectoryWithSnapshot ? ((INodeDirectoryWithSnapshot)dir).getDiffs() : null, out, referenceMap);
    }

    public static void saveFileDiffList(INodeFile file, DataOutput out) throws IOException {
        SnapshotFSImageFormat.saveINodeDiffs(file instanceof FileWithSnapshot ? ((FileWithSnapshot)((Object)file)).getDiffs() : null, out, null);
    }

    public static FileWithSnapshot.FileDiffList loadFileDiffList(DataInput in, FSImageFormat.Loader loader) throws IOException {
        int size = in.readInt();
        if (size == -1) {
            return null;
        }
        FileWithSnapshot.FileDiffList diffs = new FileWithSnapshot.FileDiffList();
        FileWithSnapshot.FileDiff posterior = null;
        for (int i = 0; i < size; ++i) {
            FileWithSnapshot.FileDiff d = SnapshotFSImageFormat.loadFileDiff(posterior, in, loader);
            diffs.addFirst(d);
            posterior = d;
        }
        return diffs;
    }

    private static FileWithSnapshot.FileDiff loadFileDiff(FileWithSnapshot.FileDiff posterior, DataInput in, FSImageFormat.Loader loader) throws IOException {
        Snapshot snapshot = loader.getSnapshot(in);
        long fileSize = in.readLong();
        INodeFile snapshotINode = in.readBoolean() ? loader.loadINodeWithLocalName(true, in, false).asFile() : null;
        return new FileWithSnapshot.FileDiff(snapshot, snapshotINode, posterior, fileSize);
    }

    private static INode loadCreated(byte[] createdNodeName, INodeDirectoryWithSnapshot parent) throws IOException {
        for (INodeDirectoryWithSnapshot.DirectoryDiff postDiff : parent.getDiffs()) {
            INode d = (INode)postDiff.getChildrenDiff().search(Diff.ListType.DELETED, createdNodeName);
            if (d == null) continue;
            return d;
        }
        INode currentChild = parent.getChild(createdNodeName, null);
        if (currentChild == null) {
            throw new IOException("Cannot find an INode associated with the INode " + DFSUtil.bytes2String(createdNodeName) + " in created list while loading FSImage.");
        }
        return currentChild;
    }

    private static List<INode> loadCreatedList(INodeDirectoryWithSnapshot parent, DataInput in) throws IOException {
        int createdSize = in.readInt();
        ArrayList<INode> createdList = new ArrayList<INode>(createdSize);
        for (int i = 0; i < createdSize; ++i) {
            byte[] createdNodeName = FSImageSerialization.readLocalName(in);
            INode created = SnapshotFSImageFormat.loadCreated(createdNodeName, parent);
            createdList.add(created);
        }
        return createdList;
    }

    private static List<INode> loadDeletedList(INodeDirectoryWithSnapshot parent, List<INode> createdList, DataInput in, FSImageFormat.Loader loader) throws IOException {
        int deletedSize = in.readInt();
        ArrayList<INode> deletedList = new ArrayList<INode>(deletedSize);
        for (int i = 0; i < deletedSize; ++i) {
            INode deleted = loader.loadINodeWithLocalName(true, in, true);
            deletedList.add(deleted);
            deleted.setParent(parent);
        }
        return deletedList;
    }

    public static void loadSnapshotList(INodeDirectorySnapshottable snapshottableParent, int numSnapshots, DataInput in, FSImageFormat.Loader loader) throws IOException {
        for (int i = 0; i < numSnapshots; ++i) {
            Snapshot s = loader.getSnapshot(in);
            s.getRoot().setParent(snapshottableParent);
            snapshottableParent.addSnapshot(s);
        }
        int snapshotQuota = in.readInt();
        snapshottableParent.setSnapshotQuota(snapshotQuota);
    }

    public static void loadDirectoryDiffList(INodeDirectory dir, DataInput in, FSImageFormat.Loader loader) throws IOException {
        int size = in.readInt();
        if (dir instanceof INodeDirectoryWithSnapshot) {
            INodeDirectoryWithSnapshot withSnapshot = (INodeDirectoryWithSnapshot)dir;
            INodeDirectoryWithSnapshot.DirectoryDiffList diffs = withSnapshot.getDiffs();
            for (int i = 0; i < size; ++i) {
                diffs.addFirst(SnapshotFSImageFormat.loadDirectoryDiff(withSnapshot, in, loader));
            }
        }
    }

    private static INodeDirectory loadSnapshotINodeInDirectoryDiff(Snapshot snapshot, DataInput in, FSImageFormat.Loader loader) throws IOException {
        boolean useRoot = in.readBoolean();
        if (useRoot) {
            return snapshot.getRoot();
        }
        return in.readBoolean() ? loader.loadINodeWithLocalName(true, in, false).asDirectory() : null;
    }

    private static INodeDirectoryWithSnapshot.DirectoryDiff loadDirectoryDiff(INodeDirectoryWithSnapshot parent, DataInput in, FSImageFormat.Loader loader) throws IOException {
        Snapshot snapshot = loader.getSnapshot(in);
        int childrenSize = in.readInt();
        INodeDirectory snapshotINode = SnapshotFSImageFormat.loadSnapshotINodeInDirectoryDiff(snapshot, in, loader);
        List<INode> createdList = SnapshotFSImageFormat.loadCreatedList(parent, in);
        List<INode> deletedList = SnapshotFSImageFormat.loadDeletedList(parent, createdList, in, loader);
        List diffs = parent.getDiffs().asList();
        INodeDirectoryWithSnapshot.DirectoryDiff sdiff = new INodeDirectoryWithSnapshot.DirectoryDiff(snapshot, snapshotINode, diffs.isEmpty() ? null : (INodeDirectoryWithSnapshot.DirectoryDiff)diffs.get(0), childrenSize, createdList, deletedList);
        return sdiff;
    }

    public static class ReferenceMap {
        private final Map<Long, INodeReference.WithCount> referenceMap = new HashMap<Long, INodeReference.WithCount>();
        private final Map<Long, Long> dirMap = new HashMap<Long, Long>();

        public void writeINodeReferenceWithCount(INodeReference.WithCount withCount, DataOutput out, boolean writeUnderConstruction) throws IOException {
            INode referred = withCount.getReferredINode();
            long id = withCount.getId();
            boolean firstReferred = !this.referenceMap.containsKey(id);
            out.writeBoolean(firstReferred);
            if (firstReferred) {
                FSImageSerialization.saveINode2Image(referred, out, writeUnderConstruction, this);
                this.referenceMap.put(id, withCount);
            } else {
                out.writeLong(id);
            }
        }

        public boolean toProcessSubtree(long id) {
            if (this.dirMap.containsKey(id)) {
                return false;
            }
            this.dirMap.put(id, id);
            return true;
        }

        public INodeReference.WithCount loadINodeReferenceWithCount(boolean isSnapshotINode, DataInput in, FSImageFormat.Loader loader) throws IOException {
            INodeReference.WithCount withCount;
            boolean firstReferred = in.readBoolean();
            if (firstReferred) {
                INode referred = loader.loadINodeWithLocalName(isSnapshotINode, in, true);
                withCount = new INodeReference.WithCount(null, referred);
                this.referenceMap.put(withCount.getId(), withCount);
            } else {
                long id = in.readLong();
                withCount = this.referenceMap.get(id);
            }
            return withCount;
        }
    }
}

