/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientFaultInjector;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestClientProtocolForPipelineRecovery {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetNewStamp() throws IOException {
        int numDataNodes = 1;
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(numDataNodes).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            NamenodeProtocols namenode = cluster.getNameNodeRpc();
            Path file = new Path("dataprotocol.dat");
            DFSTestUtil.createFile((FileSystem)fileSys, file, 1L, (short)numDataNodes, 0L);
            ExtendedBlock firstBlock = DFSTestUtil.getFirstBlock((FileSystem)fileSys, file);
            try {
                namenode.updateBlockForPipeline(firstBlock, "");
                Assert.fail((String)"Can not get a new GS from a finalized block");
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("is not under Construction"));
            }
            try {
                long newBlockId = firstBlock.getBlockId() + 1L;
                ExtendedBlock newBlock = new ExtendedBlock(firstBlock.getBlockPoolId(), newBlockId, 0L, firstBlock.getGenerationStamp());
                namenode.updateBlockForPipeline(newBlock, "");
                Assert.fail((String)"Cannot get a new GS from a non-existent block");
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("does not exist"));
            }
            DFSOutputStream out = null;
            try {
                out = (DFSOutputStream)fileSys.append(file).getWrappedStream();
                out.write(1);
                out.hflush();
                FSDataInputStream in = null;
                try {
                    in = fileSys.open(file);
                    firstBlock = DFSTestUtil.getAllBlocks(in).get(0).getBlock();
                }
                finally {
                    IOUtils.closeStream((Closeable)in);
                }
                DFSClient dfs = fileSys.dfs;
                try {
                    namenode.updateBlockForPipeline(firstBlock, "test" + dfs.clientName);
                    Assert.fail((String)"Cannot get a new GS for a non lease holder");
                }
                catch (LeaseExpiredException e) {
                    Assert.assertTrue((boolean)e.getMessage().startsWith("Lease mismatch"));
                }
                try {
                    namenode.updateBlockForPipeline(firstBlock, null);
                    Assert.fail((String)"Cannot get a new GS for a null lease holder");
                }
                catch (LeaseExpiredException e) {
                    Assert.assertTrue((boolean)e.getMessage().startsWith("Lease mismatch"));
                }
                namenode.updateBlockForPipeline(firstBlock, dfs.clientName);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(out);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)out);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPipelineRecoveryForLastBlock() throws IOException {
        DFSClientFaultInjector faultInjector = (DFSClientFaultInjector)Mockito.mock(DFSClientFaultInjector.class);
        DFSClientFaultInjector oldInjector = DFSClientFaultInjector.instance;
        DFSClientFaultInjector.instance = faultInjector;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.client.block.write.locateFollowingBlock.retries", 3);
        MiniDFSCluster cluster = null;
        try {
            int numDataNodes = 3;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(numDataNodes).build();
            cluster.waitActive();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            Path file = new Path("dataprotocol1.dat");
            Mockito.when((Object)faultInjector.failPacket()).thenReturn((Object)true);
            DFSTestUtil.createFile((FileSystem)fileSys, file, 68000000L, (short)numDataNodes, 0L);
            FSDataInputStream in = fileSys.open(file);
            try {
                int c = in.read();
            }
            catch (BlockMissingException bme) {
                Assert.fail((String)"Block is missing because the file was closed with corrupt replicas.");
            }
        }
        finally {
            DFSClientFaultInjector.instance = oldInjector;
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPacketTransmissionDelay() throws Exception {
        DataNodeFaultInjector dnFaultInjector = new DataNodeFaultInjector(){

            public boolean dropHeartbeatPacket() {
                return true;
            }
        };
        DataNodeFaultInjector oldDnInjector = DataNodeFaultInjector.get();
        DataNodeFaultInjector.set((DataNodeFaultInjector)dnFaultInjector);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.client.socket-timeout", "3000");
        MiniDFSCluster cluster = null;
        try {
            int numDataNodes = 2;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(numDataNodes).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            FSDataOutputStream out = fs.create(new Path("noheartbeat.dat"), (short)2);
            out.write(49);
            out.hflush();
            DFSOutputStream dfsOut = (DFSOutputStream)out.getWrappedStream();
            DatanodeInfo[] orgNodes = dfsOut.getPipeline();
            Thread.sleep(3500L);
            out.write(50);
            out.hflush();
            DatanodeInfo[] newNodes = dfsOut.getPipeline();
            out.close();
            boolean contains = false;
            for (int i = 0; i < newNodes.length; ++i) {
                if (orgNodes[0].getXferAddr().equals(newNodes[i].getXferAddr())) {
                    throw new IOException("The first datanode should have been replaced.");
                }
                if (!orgNodes[1].getXferAddr().equals(newNodes[i].getXferAddr())) continue;
                contains = true;
            }
            Assert.assertTrue((boolean)contains);
        }
        finally {
            DataNodeFaultInjector.set((DataNodeFaultInjector)oldDnInjector);
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPipelineRecoveryOnOOB() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.client.datanode-restart.timeout", "15");
        MiniDFSCluster cluster = null;
        try {
            int numDataNodes = 1;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(numDataNodes).build();
            cluster.waitActive();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            Path file = new Path("dataprotocol2.dat");
            DFSTestUtil.createFile((FileSystem)fileSys, file, 10240L, (short)1, 0L);
            DFSOutputStream out = (DFSOutputStream)fileSys.append(file).getWrappedStream();
            out.write(1);
            out.hflush();
            DFSAdmin dfsadmin = new DFSAdmin((Configuration)conf);
            DataNode dn = cluster.getDataNodes().get(0);
            String dnAddr = dn.getDatanodeId().getIpcAddr(false);
            String[] args1 = new String[]{"-shutdownDatanode", dnAddr, "upgrade"};
            Assert.assertEquals((long)0L, (long)dfsadmin.run(args1));
            Thread.sleep(4000L);
            cluster.restartDataNode(0, true);
            out.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPipelineRecoveryOnRestartFailure() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.client.datanode-restart.timeout", "5");
        MiniDFSCluster cluster = null;
        try {
            int numDataNodes = 2;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(numDataNodes).build();
            cluster.waitActive();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            Path file = new Path("dataprotocol3.dat");
            DFSTestUtil.createFile((FileSystem)fileSys, file, 10240L, (short)2, 0L);
            DFSOutputStream out = (DFSOutputStream)fileSys.append(file).getWrappedStream();
            out.write(1);
            out.hflush();
            DFSAdmin dfsadmin = new DFSAdmin((Configuration)conf);
            DataNode dn = cluster.getDataNodes().get(0);
            String dnAddr1 = dn.getDatanodeId().getIpcAddr(false);
            String[] args1 = new String[]{"-shutdownDatanode", dnAddr1, "upgrade"};
            Assert.assertEquals((long)0L, (long)dfsadmin.run(args1));
            Thread.sleep(4000L);
            out.close();
            out = (DFSOutputStream)fileSys.append(file).getWrappedStream();
            out.write(1);
            out.hflush();
            dn = cluster.getDataNodes().get(1);
            String dnAddr2 = dn.getDatanodeId().getIpcAddr(false);
            String[] args2 = new String[]{"-shutdownDatanode", dnAddr2, "upgrade"};
            Assert.assertEquals((long)0L, (long)dfsadmin.run(args2));
            Thread.sleep(4000L);
            try {
                out.close();
                assert (false);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

