/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataBlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ShortCircuitRegistry;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.BlockPoolSlice;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetTestUtil;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeList;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaLruTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.RamDiskReplicaTracker;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.DiskChecker;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestFsDatasetImpl {
    private static final String BASE_DIR = new FileSystemTestHelper().getTestRootDir();
    private static final int NUM_INIT_VOLUMES = 2;
    private static final String CLUSTER_ID = "cluser-id";
    private static final String[] BLOCK_POOL_IDS = new String[]{"bpid-0", "bpid-1"};
    private static final DataStorage dsForStorageUuid = new DataStorage(new StorageInfo(HdfsServerConstants.NodeType.DATA_NODE));
    private Configuration conf;
    private DataNode datanode;
    private DataStorage storage;
    private DataBlockScanner scanner;
    private FsDatasetImpl dataset;

    private static Storage.StorageDirectory createStorageDirectory(File root) {
        Storage.StorageDirectory sd = new Storage.StorageDirectory(root);
        dsForStorageUuid.createStorageID(sd, false);
        return sd;
    }

    private static void createStorageDirs(DataStorage storage, Configuration conf, int numDirs) throws IOException {
        ArrayList<Storage.StorageDirectory> dirs = new ArrayList<Storage.StorageDirectory>();
        ArrayList<String> dirStrings = new ArrayList<String>();
        for (int i = 0; i < numDirs; ++i) {
            File loc = new File(BASE_DIR + "/data" + i);
            dirStrings.add(loc.toString());
            loc.mkdirs();
            dirs.add(TestFsDatasetImpl.createStorageDirectory(loc));
            Mockito.when((Object)storage.getStorageDir(i)).thenReturn(dirs.get(i));
        }
        String dataDir = StringUtils.join((CharSequence)",", dirStrings);
        conf.set("dfs.datanode.data.dir", dataDir);
        Mockito.when((Object)storage.getNumStorageDirs()).thenReturn((Object)numDirs);
    }

    @Before
    public void setUp() throws IOException {
        this.datanode = (DataNode)Mockito.mock(DataNode.class);
        this.storage = (DataStorage)Mockito.mock(DataStorage.class);
        this.scanner = (DataBlockScanner)Mockito.mock(DataBlockScanner.class);
        this.conf = new Configuration();
        DNConf dnConf = new DNConf(this.conf);
        Mockito.when((Object)this.datanode.getConf()).thenReturn((Object)this.conf);
        Mockito.when((Object)this.datanode.getDnConf()).thenReturn((Object)dnConf);
        Mockito.when((Object)this.datanode.getBlockScanner()).thenReturn((Object)this.scanner);
        ShortCircuitRegistry shortCircuitRegistry = new ShortCircuitRegistry(this.conf);
        Mockito.when((Object)this.datanode.getShortCircuitRegistry()).thenReturn((Object)shortCircuitRegistry);
        TestFsDatasetImpl.createStorageDirs(this.storage, this.conf, 2);
        this.dataset = new FsDatasetImpl(this.datanode, this.storage, this.conf);
        for (String bpid : BLOCK_POOL_IDS) {
            this.dataset.addBlockPool(bpid, this.conf);
        }
        Assert.assertEquals((long)2L, (long)this.dataset.getVolumes().size());
        Assert.assertEquals((long)0L, (long)this.dataset.getNumFailedVolumes());
    }

    @Test
    public void testAddVolumes() throws IOException {
        int numNewVolumes = 3;
        int numExistingVolumes = this.dataset.getVolumes().size();
        int totalVolumes = 3 + numExistingVolumes;
        HashSet<String> expectedVolumes = new HashSet<String>();
        ArrayList nsInfos = Lists.newArrayList();
        for (String bpid : BLOCK_POOL_IDS) {
            nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, bpid, 1L));
        }
        for (int i = 0; i < 3; ++i) {
            String path = BASE_DIR + "/newData" + i;
            expectedVolumes.add(path);
            StorageLocation loc = StorageLocation.parse((String)path);
            Storage.StorageDirectory sd = TestFsDatasetImpl.createStorageDirectory(new File(path));
            DataStorage.VolumeBuilder builder = new DataStorage.VolumeBuilder(this.storage, sd);
            Mockito.when((Object)this.storage.prepareVolume((DataNode)Matchers.eq((Object)this.datanode), (File)Matchers.eq((Object)loc.getFile()), Matchers.anyListOf(NamespaceInfo.class))).thenReturn((Object)builder);
            this.dataset.addVolume(loc, (List)nsInfos);
        }
        Assert.assertEquals((long)totalVolumes, (long)this.dataset.getVolumes().size());
        Assert.assertEquals((long)totalVolumes, (long)this.dataset.storageMap.size());
        HashSet<String> actualVolumes = new HashSet<String>();
        for (int i = 0; i < 3; ++i) {
            actualVolumes.add(((FsVolumeImpl)this.dataset.getVolumes().get(numExistingVolumes + i)).getBasePath());
        }
        Assert.assertEquals(actualVolumes, expectedVolumes);
    }

    @Test
    public void testRemoveVolumes() throws IOException {
        int NUM_BLOCKS = 100;
        for (int i = 0; i < 100; ++i) {
            String bpid = BLOCK_POOL_IDS[100 % BLOCK_POOL_IDS.length];
            ExtendedBlock eb = new ExtendedBlock(bpid, (long)i);
            this.dataset.createRbw(StorageType.DEFAULT, eb, false);
        }
        String[] dataDirs = this.conf.get("dfs.datanode.data.dir").split(",");
        String volumePathToRemove = dataDirs[0];
        ArrayList<StorageLocation> volumesToRemove = new ArrayList<StorageLocation>();
        volumesToRemove.add(StorageLocation.parse((String)volumePathToRemove));
        this.dataset.removeVolumes(volumesToRemove);
        int expectedNumVolumes = dataDirs.length - 1;
        Assert.assertEquals((String)"The volume has been removed from the volumeList.", (long)expectedNumVolumes, (long)this.dataset.getVolumes().size());
        Assert.assertEquals((String)"The volume has been removed from the storageMap.", (long)expectedNumVolumes, (long)this.dataset.storageMap.size());
        try {
            this.dataset.asyncDiskService.execute(((StorageLocation)volumesToRemove.get(0)).getFile(), new Runnable(){

                @Override
                public void run() {
                }
            });
            Assert.fail((String)"Expect RuntimeException: the volume has been removed from the AsyncDiskService.");
        }
        catch (RuntimeException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot find root", (Throwable)e);
        }
        int totalNumReplicas = 0;
        for (String bpid : this.dataset.volumeMap.getBlockPoolList()) {
            totalNumReplicas += this.dataset.volumeMap.size(bpid);
        }
        Assert.assertEquals((String)"The replica infos on this volume has been removed from the volumeMap.", (long)50L, (long)totalNumReplicas);
        ((DataBlockScanner)Mockito.verify((Object)this.scanner, (VerificationMode)Mockito.times((int)BLOCK_POOL_IDS.length))).deleteBlocks(Matchers.anyString(), (Block[])Matchers.any(Block[].class));
    }

    @Test
    public void testDuplicateReplicaResolution() throws IOException {
        FsVolumeImpl fsv1 = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
        FsVolumeImpl fsv2 = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
        File f1 = new File("d1/block");
        File f2 = new File("d2/block");
        FinalizedReplica replicaOlder = new FinalizedReplica(1L, 1L, 1L, (FsVolumeSpi)fsv1, f1);
        FinalizedReplica replica = new FinalizedReplica(1L, 2L, 2L, (FsVolumeSpi)fsv1, f1);
        FinalizedReplica replicaSame = new FinalizedReplica(1L, 2L, 2L, (FsVolumeSpi)fsv1, f1);
        FinalizedReplica replicaNewer = new FinalizedReplica(1L, 3L, 3L, (FsVolumeSpi)fsv1, f1);
        FinalizedReplica replicaOtherOlder = new FinalizedReplica(1L, 1L, 1L, (FsVolumeSpi)fsv2, f2);
        FinalizedReplica replicaOtherSame = new FinalizedReplica(1L, 2L, 2L, (FsVolumeSpi)fsv2, f2);
        FinalizedReplica replicaOtherNewer = new FinalizedReplica(1L, 3L, 3L, (FsVolumeSpi)fsv2, f2);
        Assert.assertNull((Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaSame, (ReplicaInfo)replica));
        Assert.assertNull((Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaOlder, (ReplicaInfo)replica));
        Assert.assertNull((Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaNewer, (ReplicaInfo)replica));
        Assert.assertSame((Object)replica, (Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaOtherSame, (ReplicaInfo)replica));
        Assert.assertSame((Object)replicaOtherOlder, (Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaOtherOlder, (ReplicaInfo)replica));
        Assert.assertSame((Object)replica, (Object)BlockPoolSlice.selectReplicaToDelete((ReplicaInfo)replicaOtherNewer, (ReplicaInfo)replica));
    }

    @Test(timeout=5000L)
    public void testRemoveNewlyAddedVolume() throws IOException {
        int numExistingVolumes = this.dataset.getVolumes().size();
        ArrayList<NamespaceInfo> nsInfos = new ArrayList<NamespaceInfo>();
        for (String bpid : BLOCK_POOL_IDS) {
            nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, bpid, 1L));
        }
        String newVolumePath = BASE_DIR + "/newVolumeToRemoveLater";
        StorageLocation loc = StorageLocation.parse((String)newVolumePath);
        Storage.StorageDirectory sd = TestFsDatasetImpl.createStorageDirectory(new File(newVolumePath));
        DataStorage.VolumeBuilder builder = new DataStorage.VolumeBuilder(this.storage, sd);
        Mockito.when((Object)this.storage.prepareVolume((DataNode)Matchers.eq((Object)this.datanode), (File)Matchers.eq((Object)loc.getFile()), Matchers.anyListOf(NamespaceInfo.class))).thenReturn((Object)builder);
        this.dataset.addVolume(loc, nsInfos);
        Assert.assertEquals((long)(numExistingVolumes + 1), (long)this.dataset.getVolumes().size());
        Mockito.when((Object)this.storage.getNumStorageDirs()).thenReturn((Object)(numExistingVolumes + 1));
        Mockito.when((Object)this.storage.getStorageDir(numExistingVolumes)).thenReturn((Object)sd);
        List<StorageLocation> volumesToRemove = Arrays.asList(loc);
        this.dataset.removeVolumes(volumesToRemove);
        Assert.assertEquals((long)numExistingVolumes, (long)this.dataset.getVolumes().size());
    }

    @Test(timeout=5000L)
    public void testChangeVolumeWithRunningCheckDirs() throws IOException {
        RoundRobinVolumeChoosingPolicy blockChooser = new RoundRobinVolumeChoosingPolicy();
        final FsVolumeList volumeList = new FsVolumeList(0, (VolumeChoosingPolicy)blockChooser);
        ArrayList<FsVolumeImpl> oldVolumes = new ArrayList<FsVolumeImpl>();
        int NUM_VOLUMES = 5;
        for (int i = 0; i < 5; ++i) {
            FsVolumeImpl volume = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
            oldVolumes.add(volume);
            Mockito.when((Object)volume.getBasePath()).thenReturn((Object)("data" + i));
            volumeList.addVolume(volume);
        }
        final FsVolumeImpl newVolume = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
        FsVolumeImpl blockedVolume = (FsVolumeImpl)volumeList.getVolumes().get(1);
        ((FsVolumeImpl)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                volumeList.removeVolume(new File("data4"));
                volumeList.addVolume(newVolume);
                return null;
            }
        }).when((Object)blockedVolume)).checkDirs();
        FsVolumeImpl brokenVolume = (FsVolumeImpl)volumeList.getVolumes().get(2);
        ((FsVolumeImpl)Mockito.doThrow((Throwable)new DiskChecker.DiskErrorException("broken")).when((Object)brokenVolume)).checkDirs();
        volumeList.checkDirs();
        for (FsVolumeImpl volume : oldVolumes) {
            ((FsVolumeImpl)Mockito.verify((Object)volume)).checkDirs();
        }
        ((FsVolumeImpl)Mockito.verify((Object)newVolume, (VerificationMode)Mockito.never())).checkDirs();
        Assert.assertTrue((boolean)volumeList.getVolumes().contains(newVolume));
        Assert.assertFalse((boolean)volumeList.getVolumes().contains(brokenVolume));
        Assert.assertEquals((long)4L, (long)volumeList.getVolumes().size());
    }

    @Test
    public void testAddVolumeFailureReleasesInUseLock() throws IOException {
        FsDatasetImpl spyDataset = (FsDatasetImpl)Mockito.spy((Object)this.dataset);
        FsVolumeImpl mockVolume = (FsVolumeImpl)Mockito.mock(FsVolumeImpl.class);
        File badDir = new File(BASE_DIR, "bad");
        badDir.mkdirs();
        ((FsDatasetImpl)Mockito.doReturn((Object)mockVolume).when((Object)spyDataset)).createFsVolume(Matchers.anyString(), (File)Matchers.any(File.class), (StorageType)Matchers.any(StorageType.class));
        ((FsVolumeImpl)Mockito.doThrow((Throwable)new IOException("Failed to getVolumeMap()")).when((Object)mockVolume)).getVolumeMap(Matchers.anyString(), (ReplicaMap)Matchers.any(ReplicaMap.class), (RamDiskReplicaTracker)Matchers.any(RamDiskReplicaLruTracker.class));
        Storage.StorageDirectory sd = TestFsDatasetImpl.createStorageDirectory(badDir);
        sd.lock();
        DataStorage.VolumeBuilder builder = new DataStorage.VolumeBuilder(this.storage, sd);
        Mockito.when((Object)this.storage.prepareVolume((DataNode)Matchers.eq((Object)this.datanode), (File)Matchers.eq((Object)badDir), (List)Matchers.any())).thenReturn((Object)builder);
        StorageLocation location = StorageLocation.parse((String)badDir.toString());
        ArrayList nsInfos = Lists.newArrayList();
        for (String bpid : BLOCK_POOL_IDS) {
            nsInfos.add(new NamespaceInfo(0, CLUSTER_ID, bpid, 1L));
        }
        try {
            spyDataset.addVolume(location, (List)nsInfos);
            Assert.fail((String)"Expect to throw MultipleIOException");
        }
        catch (MultipleIOException e) {
            // empty catch block
        }
        FsDatasetTestUtil.assertFileLockReleased(badDir.toString());
    }
}

