/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFSImageWithXAttr {
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static final String name1 = "user.a1";
    private static final byte[] value1;
    private static final byte[] newValue1;
    private static final String name2 = "user.a2";
    private static final byte[] value2;
    private static final String name3 = "user.a3";
    private static final byte[] value3;

    @BeforeClass
    public static void setUp() throws IOException {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
    }

    @AfterClass
    public static void tearDown() {
        cluster.shutdown();
    }

    private void testXAttr(boolean persistNamespace) throws IOException {
        Path path = new Path("/p");
        DistributedFileSystem fs = cluster.getFileSystem();
        fs.create(path).close();
        fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        fs.setXAttr(path, name3, null, EnumSet.of(XAttrSetFlag.CREATE));
        this.restart(fs, persistNamespace);
        Map xattrs = fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)3L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        Assert.assertArrayEquals((byte[])value3, (byte[])((byte[])xattrs.get(name3)));
        fs.setXAttr(path, name1, newValue1, EnumSet.of(XAttrSetFlag.REPLACE));
        this.restart(fs, persistNamespace);
        xattrs = fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)3L);
        Assert.assertArrayEquals((byte[])newValue1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        Assert.assertArrayEquals((byte[])value3, (byte[])((byte[])xattrs.get(name3)));
        fs.removeXAttr(path, name1);
        fs.removeXAttr(path, name2);
        fs.removeXAttr(path, name3);
        this.restart(fs, persistNamespace);
        xattrs = fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)0L);
    }

    @Test
    public void testPersistXAttr() throws IOException {
        this.testXAttr(true);
    }

    @Test
    public void testXAttrEditLog() throws IOException {
        this.testXAttr(false);
    }

    private void restart(DistributedFileSystem fs, boolean persistNamespace) throws IOException {
        if (persistNamespace) {
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
            fs.saveNamespace();
            fs.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        }
        cluster.restartNameNode(new String[0]);
        cluster.waitActive();
    }

    static {
        value1 = new byte[]{49, 50, 51};
        newValue1 = new byte[]{49, 49, 49};
        value2 = new byte[]{55, 56, 57};
        value3 = new byte[0];
    }
}

