/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.util.ajax.JSON;

public class TestFSNamesystemMBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNameNode().namesystem;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
            String snapshotStats = (String)mbs.getAttribute(mxbeanName, "SnapshotStats");
            Map stat = (Map)JSON.parse((String)snapshotStats);
            Assert.assertTrue((stat.containsKey("SnapshottableDirectories") && (Long)stat.get("SnapshottableDirectories") == (long)fsn.getNumSnapshottableDirs() ? 1 : 0) != 0);
            Assert.assertTrue((stat.containsKey("Snapshots") && (Long)stat.get("Snapshots") == (long)fsn.getNumSnapshots() ? 1 : 0) != 0);
            Object pendingDeletionBlocks = mbs.getAttribute(mxbeanName, "PendingDeletionBlocks");
            Assert.assertNotNull((Object)pendingDeletionBlocks);
            Assert.assertTrue((boolean)(pendingDeletionBlocks instanceof Long));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithFSNamesystemWriteLock() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        FSNamesystem fsn = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            fsn = cluster.getNameNode().namesystem;
            fsn.writeLock();
            MBeanClient client = new MBeanClient();
            client.start();
            client.join(20000L);
            Assert.assertTrue((String)"JMX calls are blocked when FSNamesystem's writerlockis owned by another thread", (boolean)client.succeeded);
            client.interrupt();
        }
        finally {
            if (fsn != null && fsn.hasWriteLock()) {
                fsn.writeUnlock();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static class MBeanClient
    extends Thread {
        private boolean succeeded = false;

        private MBeanClient() {
        }

        @Override
        public void run() {
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                ObjectName mxbeanNamefsn = new ObjectName("Hadoop:service=NameNode,name=FSNamesystem");
                ObjectName mxbeanNameFsns = new ObjectName("Hadoop:service=NameNode,name=FSNamesystemState");
                ObjectName mxbeanNameNni = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
                HashSet<ObjectName> mbeans = new HashSet<ObjectName>();
                mbeans.add(mxbeanNamefsn);
                mbeans.add(mxbeanNameFsns);
                mbeans.add(mxbeanNameNni);
                for (ObjectName mbean : mbeans) {
                    MBeanInfo attributes = mbs.getMBeanInfo(mbean);
                    for (MBeanAttributeInfo attributeInfo : attributes.getAttributes()) {
                        mbs.getAttribute(mbean, attributeInfo.getName());
                    }
                }
                this.succeeded = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

