/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestDFSInputStream {
    private void testSkipInner(MiniDFSCluster cluster) throws IOException {
        DistributedFileSystem fs = cluster.getFileSystem();
        DFSClient client = fs.dfs;
        Path file = new Path("/testfile");
        int fileLength = 0x400000;
        byte[] fileContent = new byte[fileLength];
        for (int i = 0; i < fileLength; ++i) {
            fileContent[i] = (byte)(i % 133);
        }
        FSDataOutputStream fout = fs.create(file);
        fout.write(fileContent);
        fout.close();
        Random random = new Random();
        for (int i = 3; i < 18; ++i) {
            DFSInputStream fin = client.open("/testfile");
            for (long pos = 0L; pos < (long)fileLength; ++pos) {
                long skip = random.nextInt(1 << i) + 1;
                long skipped = fin.skip(skip);
                if (pos + skip >= (long)fileLength) {
                    Assert.assertEquals((long)fileLength, (long)(pos + skipped));
                    break;
                }
                Assert.assertEquals((long)skip, (long)skipped);
                int data = fin.read();
                Assert.assertEquals((long)((pos += skipped) % 133L), (long)data);
            }
            fin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSkipWithRemoteBlockReader() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.client.use.legacy.blockreader", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            this.testSkipInner(cluster);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSkipWithRemoteBlockReader2() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            this.testSkipInner(cluster);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSkipWithLocalBlockReader() throws IOException {
        Assume.assumeThat((Object)DomainSocket.getLoadingFailureReason(), (Matcher)CoreMatchers.equalTo(null));
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        DomainSocket.disableBindPathValidation();
        Configuration conf = new Configuration();
        conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
        conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), "TestShortCircuitLocalRead._PORT.sock").getAbsolutePath());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            DFSInputStream.tcpReadsDisabledForTesting = true;
            this.testSkipInner(cluster);
        }
        finally {
            DFSInputStream.tcpReadsDisabledForTesting = false;
            cluster.shutdown();
            sockDir.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSeekToNewSource() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path path = new Path("/testfile");
        DFSTestUtil.createFile((FileSystem)fs, path, 1024L, (short)3, 0L);
        DFSInputStream fin = fs.dfs.open("/testfile");
        try {
            fin.seekToNewSource(100L);
            Assert.assertEquals((long)100L, (long)fin.getPos());
            DatanodeInfo firstNode = fin.getCurrentDatanode();
            Assert.assertNotNull((Object)firstNode);
            fin.seekToNewSource(100L);
            Assert.assertEquals((long)100L, (long)fin.getPos());
            Assert.assertFalse((boolean)firstNode.equals((Object)fin.getCurrentDatanode()));
        }
        finally {
            fin.close();
            cluster.shutdown();
        }
    }
}

