/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.RegisterCommand;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.net.Node;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestDeadDatanode {
    private static final Log LOG = LogFactory.getLog(TestDeadDatanode.class);
    private MiniDFSCluster cluster;

    @After
    public void cleanup() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testDeadDatanode() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setLong("dfs.heartbeat.interval", 1L);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        this.cluster.waitActive();
        String poolId = this.cluster.getNamesystem().getBlockPoolId();
        DataNode dn = this.cluster.getDataNodes().get(0);
        DatanodeRegistration reg = InternalDataNodeTestUtils.getDNRegistrationForBP(this.cluster.getDataNodes().get(0), poolId);
        DFSTestUtil.waitForDatanodeState(this.cluster, reg.getDatanodeUuid(), true, 20000);
        dn.shutdown();
        DFSTestUtil.waitForDatanodeState(this.cluster, reg.getDatanodeUuid(), false, 20000);
        NamenodeProtocols dnp = this.cluster.getNameNodeRpc();
        ReceivedDeletedBlockInfo[] blocks = new ReceivedDeletedBlockInfo[]{new ReceivedDeletedBlockInfo(new Block(0L), ReceivedDeletedBlockInfo.BlockStatus.RECEIVED_BLOCK, null)};
        StorageReceivedDeletedBlocks[] storageBlocks = new StorageReceivedDeletedBlocks[]{new StorageReceivedDeletedBlocks(new DatanodeStorage(reg.getDatanodeUuid()), blocks)};
        dnp.blockReceivedAndDeleted(reg, poolId, storageBlocks);
        BlockManager bm = this.cluster.getNamesystem().getBlockManager();
        bm.flushBlockOps();
        Assert.assertFalse((boolean)bm.getDatanodeManager().getDatanode((DatanodeID)reg).isRegistered());
        StorageBlockReport[] report = new StorageBlockReport[]{new StorageBlockReport(new DatanodeStorage(reg.getDatanodeUuid()), BlockListAsLongs.EMPTY)};
        try {
            dnp.blockReport(reg, poolId, report, new BlockReportContext(1, 0, System.nanoTime(), 0L));
            Assert.fail((String)"Expected IOException is not thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StorageReport[] rep = new StorageReport[]{new StorageReport(new DatanodeStorage(reg.getDatanodeUuid()), false, 0L, 0L, 0L, 0L, 0L)};
        DatanodeCommand[] cmd = dnp.sendHeartbeat(reg, rep, 0L, 0L, 0, 0, 0, null, true).getCommands();
        Assert.assertEquals((long)1L, (long)cmd.length);
        Assert.assertEquals((long)cmd[0].getAction(), (long)RegisterCommand.REGISTER.getAction());
    }

    @Test
    public void testDeadNodeAsBlockTarget() throws Exception {
        DatanodeStorageInfo[] results;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 500);
        conf.setLong("dfs.heartbeat.interval", 1L);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        this.cluster.waitActive();
        String poolId = this.cluster.getNamesystem().getBlockPoolId();
        DataNode dn = this.cluster.getDataNodes().get(0);
        DatanodeRegistration reg = InternalDataNodeTestUtils.getDNRegistrationForBP(this.cluster.getDataNodes().get(0), poolId);
        BlockManager bm = this.cluster.getNamesystem().getBlockManager();
        DatanodeManager dm = bm.getDatanodeManager();
        DatanodeDescriptor clientNode = dm.getDatanode((DatanodeID)reg);
        DFSTestUtil.waitForDatanodeState(this.cluster, reg.getDatanodeUuid(), true, 20000);
        dn.shutdown();
        DFSTestUtil.waitForDatanodeState(this.cluster, reg.getDatanodeUuid(), false, 20000);
        for (DatanodeStorageInfo datanodeStorageInfo : results = bm.chooseTarget4NewBlock("/hello", 3, (Node)clientNode, new HashSet(), 0x10000000L, null, (byte)7, null)) {
            Assert.assertFalse((String)"Dead node should not be choosen", (boolean)datanodeStorageInfo.getDatanodeDescriptor().equals((Object)clientNode));
        }
    }
}

