/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.NameNodeProxiesClient;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.server.federation.router.ConnectionContext;
import org.apache.hadoop.hdfs.server.federation.router.ConnectionPoolId;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryUtils;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.mortbay.util.ajax.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ConnectionPool {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionPool.class);
    private final Configuration conf;
    private final ConnectionPoolId connectionPoolId;
    private final String namenodeAddress;
    private final UserGroupInformation ugi;
    private volatile List<ConnectionContext> connections = new ArrayList<ConnectionContext>();
    private final AtomicInteger clientIndex = new AtomicInteger(0);
    private final int minSize;
    private final int maxSize;
    private volatile long lastActiveTime = 0L;

    protected ConnectionPool(Configuration config, String address, UserGroupInformation user, int minPoolSize, int maxPoolSize) throws IOException {
        this.conf = config;
        this.ugi = user;
        this.namenodeAddress = address;
        this.connectionPoolId = new ConnectionPoolId(this.ugi, this.namenodeAddress);
        this.minSize = minPoolSize;
        this.maxSize = maxPoolSize;
        for (int i = 0; i < this.minSize; ++i) {
            ConnectionContext newConnection = this.newConnection();
            this.connections.add(newConnection);
        }
        LOG.debug("Created connection pool \"{}\" with {} connections", (Object)this.connectionPoolId, (Object)this.minSize);
    }

    protected int getMaxSize() {
        return this.maxSize;
    }

    protected int getMinSize() {
        return this.minSize;
    }

    protected ConnectionPoolId getConnectionPoolId() {
        return this.connectionPoolId;
    }

    protected ConnectionContext getConnection() {
        this.lastActiveTime = Time.now();
        ConnectionContext conn = null;
        List<ConnectionContext> tmpConnections = this.connections;
        int size = tmpConnections.size();
        int threadIndex = this.clientIndex.getAndIncrement();
        for (int i = 0; i < size; ++i) {
            int index = (threadIndex + i) % size;
            conn = tmpConnections.get(index);
            if (conn == null || conn.isUsable()) continue;
            return conn;
        }
        return conn;
    }

    public synchronized void addConnection(ConnectionContext conn) {
        ArrayList<ConnectionContext> tmpConnections = new ArrayList<ConnectionContext>(this.connections);
        tmpConnections.add(conn);
        this.connections = tmpConnections;
        this.lastActiveTime = Time.now();
    }

    public synchronized List<ConnectionContext> removeConnections(int num) {
        LinkedList<ConnectionContext> removed = new LinkedList<ConnectionContext>();
        ArrayList<ConnectionContext> tmpConnections = new ArrayList<ConnectionContext>();
        for (int i = 0; i < this.connections.size(); ++i) {
            ConnectionContext conn = this.connections.get(i);
            if (i < this.minSize || i < this.connections.size() - num) {
                tmpConnections.add(conn);
                continue;
            }
            removed.add(conn);
        }
        this.connections = tmpConnections;
        return removed;
    }

    protected synchronized void close() {
        long timeSinceLastActive = TimeUnit.MILLISECONDS.toSeconds(Time.now() - this.getLastActiveTime());
        LOG.debug("Shutting down connection pool \"{}\" used {} seconds ago", (Object)this.connectionPoolId, (Object)timeSinceLastActive);
        for (ConnectionContext connection : this.connections) {
            connection.close();
        }
        this.connections.clear();
    }

    protected int getNumConnections() {
        return this.connections.size();
    }

    protected int getNumActiveConnections() {
        int ret = 0;
        List<ConnectionContext> tmpConnections = this.connections;
        for (ConnectionContext conn : tmpConnections) {
            if (!conn.isActive()) continue;
            ++ret;
        }
        return ret;
    }

    protected long getLastActiveTime() {
        return this.lastActiveTime;
    }

    public String toString() {
        return this.connectionPoolId.toString();
    }

    public String getJSON() {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        info.put("active", Integer.toString(this.getNumActiveConnections()));
        info.put("total", Integer.toString(this.getNumConnections()));
        if (LOG.isDebugEnabled()) {
            List<ConnectionContext> tmpConnections = this.connections;
            for (int i = 0; i < tmpConnections.size(); ++i) {
                ConnectionContext connection = tmpConnections.get(i);
                info.put(i + " active", Boolean.toString(connection.isActive()));
                info.put(i + " closed", Boolean.toString(connection.isClosed()));
            }
        }
        return JSON.toString(info);
    }

    public ConnectionContext newConnection() throws IOException {
        return ConnectionPool.newConnection(this.conf, this.namenodeAddress, this.ugi);
    }

    protected static ConnectionContext newConnection(Configuration conf, String nnAddress, UserGroupInformation ugi) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ClientNamenodeProtocolPB.class, ProtobufRpcEngine.class);
        RetryPolicy defaultPolicy = RetryUtils.getDefaultRetryPolicy((Configuration)conf, (String)"dfs.client.retry.policy.enabled", (boolean)false, (String)"dfs.client.retry.policy.spec", (String)"10000,6,60000,10", (String)"org.apache.hadoop.hdfs.server.namenode.SafeModeException");
        SocketFactory factory = SocketFactory.getDefault();
        if (UserGroupInformation.isSecurityEnabled()) {
            SaslRpcServer.init((Configuration)conf);
        }
        InetSocketAddress socket = NetUtils.createSocketAddr((String)nnAddress);
        long version = RPC.getProtocolVersion(ClientNamenodeProtocolPB.class);
        ClientNamenodeProtocolPB proxy = (ClientNamenodeProtocolPB)RPC.getProtocolProxy(ClientNamenodeProtocolPB.class, (long)version, (InetSocketAddress)socket, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)factory, (int)RPC.getRpcTimeout((Configuration)conf), (RetryPolicy)defaultPolicy, null).getProxy();
        ClientNamenodeProtocolTranslatorPB client = new ClientNamenodeProtocolTranslatorPB(proxy);
        Text dtService = SecurityUtil.buildTokenService((InetSocketAddress)socket);
        NameNodeProxiesClient.ProxyAndInfo clientProxy = new NameNodeProxiesClient.ProxyAndInfo((Object)client, dtService, socket);
        ConnectionContext connection = new ConnectionContext((NameNodeProxiesClient.ProxyAndInfo<ClientProtocol>)clientProxy);
        return connection;
    }
}

